/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.EditLog;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class KillSublineage
extends JPanel
implements ActionListener {
    Vector iCandidateCells;
    int iTime;
    String iCellName;
    Cell iCellToKill;
    AceTree iAceTree;
    EditLog iEditLog;
    NucleiMgr iNucleiMgr;
    private static final String CS = ", ";
    private static final String TAB = "\t";

    public KillSublineage(AceTree aceTree) {
        Cell cell;
        this.iAceTree = aceTree;
        this.setAlignmentX(0.5f);
        this.iNucleiMgr = aceTree.getNucleiMgr();
        this.iEditLog = aceTree.getEditLog();
        int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        this.iCellToKill = cell = this.iAceTree.getCurrentCell();
        this.iCellName = cell != null ? cell.getName() : "";
        this.iEditLog = this.iNucleiMgr.getEditLog();
        this.iCandidateCells = new Vector();
        this.iTime = time;
        Border blackline = BorderFactory.createLineBorder(Color.black);
        this.setLayout(new BoxLayout(this, 3));
        JLabel l = new JLabel("Kill Sublineage");
        l.setAlignmentX(0.5f);
        this.add(l);
        l = new JLabel(" ");
        l.setAlignmentX(0.5f);
        this.add(l);
        l = new JLabel("current Cell: " + this.iCellName);
        l.setAlignmentX(0.5f);
        this.add(l);
        JLabel lestimate = new JLabel("Estimated Count: 0");
        lestimate.setAlignmentX(0.5f);
        this.add(lestimate);
        JButton killem = new JButton("Kill Sublineage");
        killem.setAlignmentX(0.5f);
        killem.addActionListener(this);
        this.add(Box.createVerticalGlue());
        this.add(killem);
        Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(this.iTime - 1);
        this.iCandidateCells = new Vector();
        this.iCandidateCells.add(nuclei);
        int estimate = 0;
        if (cell != null) {
            estimate = this.collectCandidateCells();
            int nmax = this.iCandidateCells.size();
        } else {
            boolean nmax = false;
        }
        lestimate.setText("Estimate: " + estimate);
    }

    private int collectCandidateCells() {
        int k = this.iTime;
        int count = 1;
        int estimate = 1;
        boolean found = true;
        String name = this.iCellToKill.getName();
        Nucleus n = null;
        Vector nuclei = null;
        Vector nuclei_record = this.iNucleiMgr.getNucleiRecord();
        while (found && k < nuclei_record.size()) {
            nuclei = (Vector)nuclei_record.elementAt(k++);
            found = false;
            boolean foundonce = false;
            int j = 0;
            while (j < nuclei.size()) {
                n = (Nucleus)nuclei.elementAt(j);
                if (!n.identity.contains(name)) {
                    ++estimate;
                    if (!foundonce) {
                        this.iCandidateCells.add(nuclei);
                    }
                    foundonce = true;
                    found = true;
                }
                ++j;
            }
            ++count;
        }
        return estimate;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AncesTree ances;
        if (this.iNucleiMgr.getCurrentCellData(this.iCellName, this.iTime) == null) {
            System.out.println("Attempt to delete nonexistent cell quitting");
            return;
        }
        Object o = e.getSource();
        String indexString = this.iNucleiMgr.getIndex(this.iCellName, this.iTime);
        this.iEditLog.appendx("KILLING Sublineage" + this.iCellName + indexString + " at time " + this.iTime);
        int k = this.iCandidateCells.size();
        this.iNucleiMgr.makeBackupNucleiRecord();
        Nucleus predecessorNuc = null;
        if (this.iTime > 1) {
            Nucleus nc = this.iNucleiMgr.getCurrentCellData(this.iCellName, this.iTime);
            Vector predNuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(this.iTime - 2);
            if (nc.predecessor > 0) {
                predecessorNuc = (Nucleus)predNuclei.elementAt(nc.predecessor - 1);
            }
        }
        int i = 0;
        while (i < k) {
            Vector nuclei = (Vector)this.iCandidateCells.elementAt(i);
            Nucleus n = null;
            int j = 0;
            while (j < nuclei.size()) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.identity.contains(this.iCellName)) {
                    n.status = -1;
                    n.identity = "";
                    n.assignedID = "";
                }
                ++j;
            }
            ++i;
        }
        Cell c = null;
        int strTime = this.iTime - 1;
        if (predecessorNuc != null) {
            ances = this.iAceTree.getAncesTree();
            Hashtable h = ances.getCellsByName();
            c = (Cell)h.get(predecessorNuc.identity);
        }
        this.iAceTree.clearTree();
        this.iAceTree.buildTree(true);
        this.iEditLog.setModified(true);
        ances = this.iAceTree.getAncesTree();
        Hashtable h = ances.getCellsByName();
        if (c != null) {
            c = (Cell)h.get(c.getName());
        }
        System.out.println("killSublineage.actionPerformed: " + c + CS + strTime);
        if (c != null) {
            this.iAceTree.setStartingCell(c, strTime);
        }
    }
}

