/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.text.MaskFormatter;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.NucEditModel;

public final class NucEditDialog
extends JDialog
implements ActionListener {
    NucEditModel iNucEditModel;
    JMenuItem iEnd;
    JPanel newContentPane;
    JFormattedTextField iTimeField;
    JButton iButton;
    JButton iNextButton;
    JButton iPrevButton;
    int iTime;
    JLabel iLabel;
    private static final String TITLE = "Nuclei Viewer";
    private static final String TEST = "Test";
    private static final String TEST1 = "test1";
    private static final String TEST2 = "test2";
    private static final String READ = "Read";
    private static final String NEXT = "Next";
    private static final String PREV = "Prev";
    private static final String FIXX = "Fixx";
    private static final String TIME = "Time: ";
    private static final String ADD = "Add";
    private static final String ADD1 = "Add to first time";
    private static final String ADD2 = "Add to second time";
    private static final String EDIT = "Edit";
    private static final String COMMIT = "Commit changes";
    private static final String FILE = "File";
    private static final String QUIT = "Quit";
    private static final String END = "Exit";

    public NucEditDialog(AceTree acetree, Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle(TITLE);
        this.iNucEditModel = new NucEditModel(acetree);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu(FILE);
        menuBar.add(menu);
        this.iEnd = new JMenuItem(END);
        this.iEnd.addActionListener(this);
        menu.add(this.iEnd);
        this.setItemsEnabled(false);
        NucEditDialog dialog = this;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel s = new JPanel();
        s.setLayout(new FlowLayout());
        JLabel label2 = new JLabel(TIME);
        s.add(label2);
        MaskFormatter mf = this.createFormatter("###");
        this.iTimeField = new JFormattedTextField(mf);
        this.iTimeField.setFocusLostBehavior(3);
        this.iTimeField.setColumns(5);
        this.iTime = acetree.getImageTime() + acetree.getTimeInc();
        this.iTimeField.setValue(String.valueOf(this.iTime));
        s.add(this.iTimeField);
        this.iButton = new JButton(READ);
        this.iButton.addActionListener(this);
        s.add(this.iButton);
        this.iNextButton = new JButton(NEXT);
        this.iNextButton.addActionListener(this);
        s.add(this.iNextButton);
        this.iPrevButton = new JButton(PREV);
        this.iPrevButton.addActionListener(this);
        s.add(this.iPrevButton);
        s.setMaximumSize(new Dimension(1000, 20));
        p.add(s);
        JTable table = new JTable(this.iNucEditModel.getNucleiTableModel(0));
        table.setPreferredScrollableViewportSize(new Dimension(1000, 70));
        JScrollPane scrollPane = new JScrollPane(table);
        p.add(scrollPane);
        s = new JPanel();
        s.setLayout(new FlowLayout());
        this.iLabel = new JLabel(TIME + String.valueOf(this.iTime + 1));
        s.add(this.iLabel);
        s.setMaximumSize(new Dimension(500, 20));
        p.add(s);
        JTable table2 = new JTable(this.iNucEditModel.getNucleiTableModel(1));
        table2.setPreferredScrollableViewportSize(new Dimension(1000, 70));
        JScrollPane scrollPane2 = new JScrollPane(table2);
        p.add(scrollPane2);
        Font f = table.getFont();
        f = f.deriveFont(1);
        f = f.deriveFont(14.0f);
        table.setFont(f);
        table2.setFont(f);
        this.newContentPane = p;
        this.newContentPane.setOpaque(true);
        dialog.setContentPane(this.newContentPane);
        dialog.setSize(new Dimension(400, 600));
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        this.read();
        int tcount = table.getColumnCount();
        int width = 100;
        if (table.getColumnModel().getColumnCount() > 0) {
            table.getColumnModel().getColumn(0).setMinWidth(width);
        }
        if (table2.getColumnModel().getColumnCount() > 0) {
            table2.getColumnModel().getColumn(0).setMinWidth(width);
        }
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        String time = this.iTimeField.getText().trim();
        String command = e.getActionCommand();
        if (o == this.iEnd) {
            this.setVisible(false);
            this.dispose();
        } else if (command.equals(READ)) {
            this.read();
        } else if (command.equals(NEXT)) {
            this.iTime = Integer.parseInt(time) + 1;
            this.iNucEditModel.updateNucleiTableModel(this.iTime - 1);
            this.iLabel.setText(TIME + String.valueOf(this.iTime + 1));
            this.iTimeField.setText(String.valueOf(this.iTime));
            this.setItemsEnabled(true);
        } else if (command.equals(PREV)) {
            this.iTime = Integer.parseInt(time) - 1;
            if (this.iTime < 1) {
                return;
            }
            this.iNucEditModel.updateNucleiTableModel(this.iTime - 1);
            this.iLabel.setText(TIME + String.valueOf(this.iTime + 1));
            this.iTimeField.setText(String.valueOf(this.iTime));
            this.setItemsEnabled(true);
        }
    }

    private void read() {
        String time = this.iTimeField.getText().trim();
        this.iTime = Integer.parseInt(time);
        this.iNucEditModel.updateNucleiTableModel(this.iTime - 1);
        this.iLabel.setText(TIME + String.valueOf(this.iTime + 1));
        this.setItemsEnabled(true);
    }

    private void setItemsEnabled(boolean enabled) {
        this.iEnd.setEnabled(enabled);
    }

    public static void main(String[] args) {
    }
}

