/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;

public class NucleiTableModel
extends AbstractTableModel {
    NucleiMgr iNucleiMgr;
    Vector iVdata = new Vector();
    int iNumAdded;
    int iIndex;
    public static final String[] colnames = new String[]{"identity", "index", "status", "pred", "succ1", "succ2", "x", "y", "z", "size", "weight", "rweight"};
    public static final int IDENT = 0;
    public static final int INDEX = 1;
    public static final int STAT = 2;
    public static final int PRED = 3;
    public static final int SUCC1 = 4;
    public static final int SUCC2 = 5;
    public static final int X = 6;
    public static final int Y = 7;
    public static final int Z = 8;
    public static final int SIZE = 9;
    public static final int WT = 10;
    public static final String ADD = "ADD";

    public NucleiTableModel() {
        Vector row = new Vector();
        this.iVdata.add(row);
        this.iNumAdded = 0;
    }

    public void updateNucleiTableModel(NucleiMgr nucleiMgr, int index) {
        this.iVdata.clear();
        Vector va = nucleiMgr.getNucleiRecord();
        if (index < va.size()) {
            Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(index);
            int i = 0;
            while (i < nuclei.size()) {
                Nucleus n = (Nucleus)nuclei.elementAt(i);
                Vector<Object> row = new Vector<Object>();
                row.add(new String(n.identity));
                row.add(new Integer(n.index));
                row.add(new Integer(n.status));
                row.add(new Integer(n.predecessor));
                row.add(new Integer(n.successor1));
                row.add(new Integer(n.successor2));
                row.add(new Integer(n.x));
                row.add(new Integer(n.y));
                row.add(new Float(n.z));
                row.add(new Integer(n.size));
                row.add(new Integer(n.weight));
                row.add(new Integer(n.rweight));
                this.iVdata.add(row);
                ++i;
            }
        } else {
            this.iVdata.add(new Vector());
        }
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int col) {
        return colnames[col];
    }

    @Override
    public int getColumnCount() {
        if (this.iVdata.size() == 0) {
            return 0;
        }
        Object o = this.iVdata.elementAt(0);
        if (o == null) {
            return 0;
        }
        return ((Vector)this.iVdata.elementAt(0)).size();
    }

    @Override
    public int getRowCount() {
        return this.iVdata.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Vector)this.iVdata.elementAt(rowIndex)).elementAt(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ((Vector)this.iVdata.elementAt(row)).set(col, value);
        this.fireTableCellUpdated(row, col);
    }

    public void addRow() {
        Vector<Object> row = new Vector<Object>();
        Integer empty = new Integer(-1);
        int newRow = this.getRowCount() + 1;
        row.add(new Integer(newRow));
        int i = 1;
        while (i <= this.getColumnCount()) {
            row.add(empty);
            ++i;
        }
        ++this.iNumAdded;
        row.setElementAt(new String(ADD + this.iNumAdded), 0);
        row.setElementAt(String.valueOf(newRow), 1);
        this.iVdata.add(row);
        this.fireTableDataChanged();
    }

    public int getIndex() {
        return this.iIndex;
    }

    public void printDebugData() {
        int numRows = this.getRowCount();
        int numCols = this.getColumnCount();
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                System.out.print("\t" + this.getValueAt(i, j));
                ++j;
            }
            System.out.println();
            ++i;
        }
        this.fireTableDataChanged();
    }

    public static void main(String[] args) {
    }
}

