/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;

public class Overlaps
extends JPanel
implements ActionListener,
ListSelectionListener,
Comparator {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private JFrame iFrame;
    protected JToolBar iToolBar;
    protected JMenuBar iMenuBar;
    private String iTitle = "Overlaps";
    private JTextField iTextField;
    private JTextField iTextField2;
    private JList iCellList;
    private DefaultListModel iListModel;
    private boolean iNamesAvailable;
    private JScrollPane iScrollPane;
    private JComboBox iCombo;
    private int iTime;
    private String iCellName;
    private int iTest;
    private static int TOLERENCE = 15;
    private static final double TOL = 0.7;
    private static final double FACTOR = 0.5;
    private static final String CLEAR = "Clear";
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");
    private static final DecimalFormat DF1 = new DecimalFormat("###.#");
    private static final DecimalFormat DF000 = new DecimalFormat("000");

    public Overlaps() {
        this.setPreferredSize(new Dimension(700, 300));
        this.setLayout(new BoxLayout(this, 1));
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        this.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList();
        this.initialize();
        this.iFrame = new JFrame(this.iTitle);
        this.showMe();
    }

    private void test1() {
        Overlaps.println("test1 entered");
        this.initialize();
        this.iNamesAvailable = false;
        this.iTest = 1;
        NucUtils.setZPixRes(this.iNucleiMgr.getZPixRes());
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        t1 = Integer.parseInt(this.iTextField2.getText());
        t2 = Integer.parseInt(this.iTextField.getText());
        String filter = "";
        if (sa.length > 1) {
            filter = sa[1];
        }
        t2 = maxTime;
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows nuclei that are too close");
        this.iListModel.addElement("#where the separation is less than sum of radii - TOLERENCE ");
        int i = t1;
        while (i <= t2) {
            this.findOverlaps(i);
            ++i;
        }
        this.iNamesAvailable = true;
    }

    public void findOverlaps(int now) {
        this.iNamesAvailable = false;
        this.iTest = 1;
        Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        nuclei = this.cleanupAndSort(nuclei);
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n = ((Nuc)nuclei.get((int)i)).iNuc;
            int j = i + 1;
            while (j < nuclei.size()) {
                double valid;
                int dist;
                Nucleus n2 = ((Nuc)nuclei.get((int)j)).iNuc;
                if (n2.status >= 0 && !((double)(dist = NucUtils.distance(n, n2)) > (valid = (double)((n.size + n2.size) / 2)) - (double)TOLERENCE)) {
                    String plane = "above";
                    if (n2.z > n.z) {
                        plane = "below";
                    }
                    String s = String.valueOf(now) + CS + n.identity + CS + n2.identity + CS + plane + CS + DF1.format(dist) + CS + DF1.format(valid);
                    this.iListModel.addElement(s);
                }
                ++j;
            }
            ++i;
        }
        if (!this.isShowing()) {
            this.showMe();
        }
        this.iNamesAvailable = true;
    }

    private Vector cleanupAndSort(Vector nuclei) {
        Vector<Nuc> c = new Vector<Nuc>();
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.get(i);
            if (n.status >= 0) {
                c.add(new Nuc(n.identity, n));
            }
            ++i;
        }
        Collections.sort(c, new Nuc());
        return c;
    }

    private void showNucs() {
        this.initialize();
        this.iNamesAvailable = false;
        this.iTest = 1;
        NucUtils.setZPixRes(this.iNucleiMgr.getZPixRes());
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        t1 = Integer.parseInt(this.iTextField2.getText());
        t2 = Integer.parseInt(this.iTextField.getText());
        String filter = "";
        if (sa.length > 1) {
            filter = sa[1];
        }
        t2 = maxTime;
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows nucs and their plane");
        int i = t1;
        while (i <= t2) {
            this.showNucs(i);
            ++i;
        }
        this.iNamesAvailable = true;
    }

    private void showNucs(int now) {
        Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        nuclei = this.cleanupAndSort(nuclei);
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n = ((Nuc)nuclei.get((int)i)).iNuc;
            if (n.identity.indexOf("Nuc") == 0) {
                int plane = Math.round(n.z);
                String s = String.valueOf(now) + CS + n.identity + CS + plane;
                this.iListModel.addElement(s);
            }
            ++i;
        }
    }

    private void nucEm() {
        int[] remove = this.iCellList.getSelectedIndices();
        int i = remove.length - 1;
        while (i >= 0) {
            String s = (String)this.iListModel.elementAt(remove[i]);
            String[] sa = s.split(CS);
            int time = Integer.parseInt(sa[0]);
            String cellName = sa[1];
            Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(time - 1);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus n = (Nucleus)nuclei.elementAt(j);
                if (n.identity.equals(cellName)) {
                    n.status = -1;
                    n.identity = "";
                    n.assignedID = "";
                    Overlaps.println("nuking, " + cellName + CS + time);
                }
                ++j;
            }
            --i;
        }
        this.rebuildAndRename();
    }

    private void rebuildAndRename() {
        this.iAceTree.clearTree();
        this.iAceTree.buildTree(true);
        this.iNamesAvailable = false;
        this.iListModel.clear();
        this.initialize();
    }

    private void setParms() {
        Parms myDialog = new Parms(this.iFrame, true);
    }

    private int jump(CellData cd0, CellData cd1) {
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Nucleus n0 = cd0.iNucleus;
        Nucleus n1 = cd1.iNucleus;
        int x = n0.x;
        int y = n0.y;
        int z = (int)(zPixRes * (double)n0.z);
        int zz = (int)(zPixRes * (double)n1.z);
        int dx = n1.x - x;
        int dy = n1.y - y;
        int dz = zz - z;
        int d2 = dx * dx + dy * dy + dz * dz;
        d2 = (int)Math.round(Math.sqrt(d2));
        return d2;
    }

    public int compare(Object arg0, Object arg1) {
        double d1;
        int rtn = 1;
        String[] sa = ((String)arg0).split(CS);
        double d0 = Double.parseDouble(sa[2]);
        if (d0 > (d1 = Double.parseDouble((sa = ((String)arg1).split(CS))[2]))) {
            rtn = -1;
        }
        return rtn;
    }

    private String getConfigFileInfo(String longName) {
        String s = longName.substring(longName.lastIndexOf(47) + 1);
        s = s.substring(0, s.indexOf(46));
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (e.getSource() == this.iCombo) {
            String newSelection = (String)this.iCombo.getSelectedItem();
            this.iAceTree.restoreTree(newSelection);
        } else if (s.equals("Overlaps")) {
            this.test1();
        } else if (s.equals("ShowNucs")) {
            this.showNucs();
        } else if (s.equals("NucEm")) {
            this.nucEm();
        } else if (s.equals(CLEAR)) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
        } else if (s.equals("setParms")) {
            this.setParms();
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("start/end"));
        this.iTextField2 = new JTextField();
        this.iTextField2.setColumns(5);
        this.iTextField2.setText("100");
        this.iToolBar.add(this.iTextField2);
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("200");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton("Overlaps");
        this.addToolBarButton(jb);
        jb = new JButton("ShowNucs");
        this.addToolBarButton(jb);
        jb = new JButton("NucEm");
        this.addToolBarButton(jb);
        jb = new JButton("setParms");
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    protected void addComboBox(JComboBox jcb) {
        jcb.addActionListener(this);
        this.iToolBar.add(jcb);
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(2);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setVisibleRowCount(5);
        this.iScrollPane = new JScrollPane(this.iCellList);
        this.add(this.iScrollPane);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            if (this.iTest == 1) {
                name = sa[1];
                this.iTime = Integer.parseInt(sa[0]);
            }
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private class Nuc
    implements Comparator {
        String iName;
        Nucleus iNuc;

        public Nuc() {
        }

        public Nuc(String name, Nucleus n) {
            this.iName = name;
            this.iNuc = n;
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((Nuc)o1).iName;
            String s2 = ((Nuc)o2).iName;
            return s1.compareTo(s2);
        }
    }

    private class Parms
    extends JDialog
    implements ActionListener {
        private JPanel iPanel;
        private JButton iOKButton;
        private JButton iCancelButton;
        private JTextField iTolerence;

        public Parms(JFrame frame, boolean modal) {
            super((Frame)frame, modal);
            this.iPanel = null;
            this.iOKButton = null;
            this.iCancelButton = null;
            this.iPanel = new JPanel();
            this.getContentPane().add(this.iPanel);
            this.iPanel.setLayout(new GridLayout(0, 1));
            this.iTolerence = new JTextField(String.valueOf(TOLERENCE));
            this.iPanel.add(new JLabel("distance tolerence"));
            this.iPanel.add(this.iTolerence);
            this.iOKButton = new JButton("OK");
            this.iOKButton.addActionListener(this);
            this.iPanel.add(this.iOKButton);
            this.iCancelButton = new JButton("Cancel");
            this.iCancelButton.addActionListener(this);
            this.iPanel.add(this.iCancelButton);
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.iOKButton == e.getSource()) {
                TOLERENCE = Integer.parseInt(this.iTolerence.getText());
            }
            this.setVisible(false);
        }
    }
}

