/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.nucedit.NucRelinkDialog;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;

public class Siamese
extends JDialog
implements ActionListener,
ListSelectionListener,
Comparator {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private JFrame iFrame;
    protected JToolBar iToolBar;
    protected JMenuBar iMenuBar;
    private String iTitle = "Siamese";
    private JTextField iTextField;
    private JTextField iTextField2;
    private JList iCellList;
    private DefaultListModel iListModel;
    private boolean iNamesAvailable;
    private JScrollPane iScrollPane;
    private JComboBox iCombo;
    private int iTime;
    private String iCellName;
    private int iTest;
    int iDelT;
    int iDelD;
    int iDelJ;
    int iDelJD;
    private static int MINLIFETIME = 15;
    private static int MAXCGMOVEMENT = 20;
    private static int MAXMOVEMENT = 30;
    private static int MINMOVEMENT = 10;
    private static final double TOL = 0.7;
    private static final double FACTOR = 0.5;
    String[] shelp = new String[]{"# maxTime field accepts forms like 200:ABalaa", "# if the colon and cell are there then output will be filtered to that", "# and its decendents", "# Deaths: makes a queryable list of cell deaths", "# Adjacent backward: makes two queryable lists showing nearby cells at this ane previous time.", "#A djacent forward: makes a queryable list of cells near current cell at next time"};
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Deaths";
    private static final String TEST2 = "Adj back";
    private static final String TEST3 = "Adj forward";
    private static final String TEST4 = "Jumps";
    private static final String TEST5 = "Test5";
    private static final String HELP = "Help";
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");
    private static final DecimalFormat DF000 = new DecimalFormat("000");

    public Siamese() {
        this.setTitle(this.iTitle);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        p.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList();
        this.iCellList.setVisibleRowCount(10);
        p.add(this.iScrollPane);
        this.initialize();
        this.setVisible(true);
        this.pack();
    }

    private void test1() {
        this.initialize();
        this.iNamesAvailable = false;
        this.iTest = 1;
        NucUtils.setZPixRes(this.iNucleiMgr.getZPixRes());
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        t1 = Integer.parseInt(this.iTextField2.getText());
        t2 = Integer.parseInt(this.iTextField.getText());
        String filter = "";
        if (sa.length > 1) {
            filter = sa[1];
        }
        t2 = maxTime;
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows parent, division time, daughters 1 & 2, and score");
        int i = t1;
        while (i <= t2) {
            this.showDivisions(i);
            ++i;
        }
        this.iNamesAvailable = true;
    }

    public void showDivisions(int now) {
        this.iNamesAvailable = false;
        this.iTest = 1;
        Vector nucleiNow = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        Nucleus nnow = null;
        int j = 0;
        while (j < nucleiNow.size()) {
            Nucleus p;
            Vector nucleiNext;
            Nucleus a;
            int score;
            nnow = (Nucleus)nucleiNow.elementAt(j);
            if (nnow.status > 0 && nnow.successor1 > 0 && nnow.successor2 > 0 && (score = this.evaluateDivision(nnow, a = (Nucleus)(nucleiNext = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now)).elementAt(nnow.successor1 - 1), p = (Nucleus)nucleiNext.elementAt(nnow.successor2 - 1), now)) != 0) {
                this.iListModel.addElement(this.division(nnow.identity, a.identity, p.identity, now, score));
                if (score >= 100) {
                    Cell cnow = (Cell)this.iCellsByName.get(nnow.identity);
                    Cell parent = (Cell)cnow.getParent();
                    int endTime = parent.getEndTime();
                    Vector cellData = parent.getCellData();
                    if (cellData.size() == 0) break;
                    CellData cd = (CellData)cellData.get(cellData.size() - 1);
                    Nucleus parentN = cd.iNucleus;
                    nucleiNext = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(endTime);
                    a = (Nucleus)nucleiNext.elementAt(parentN.successor1 - 1);
                    p = (Nucleus)nucleiNext.elementAt(parentN.successor2 - 1);
                    score = this.evaluateDivision(parentN, a, p, endTime);
                    this.iListModel.addElement(String.valueOf(this.division(parentN.identity, a.identity, p.identity, endTime, score)) + CS + "PARENT");
                }
            }
            ++j;
        }
        if (!this.isShowing()) {
            this.showMe();
        }
        this.iNamesAvailable = true;
    }

    private int evaluateDivision(Nucleus parent, Nucleus dau1, Nucleus dau2, int now) {
        int ddau1 = NucUtils.distance(parent, dau1);
        int ddau2 = NucUtils.distance(parent, dau2);
        int dmax = Math.max(ddau1, ddau2);
        int dmin = Math.min(ddau1, ddau2);
        Cell pcell = (Cell)this.iCellsByName.get(parent.identity);
        int lifeTime = 2 * MINLIFETIME;
        if (pcell != null) {
            lifeTime = pcell.getLifeTime();
        }
        int cgdist = NucUtils.distance(parent, NucUtils.meanPos(dau1, dau2));
        int score = 1000;
        if (dmax > MAXMOVEMENT && dmin < MINMOVEMENT) {
            ++score;
        }
        if (cgdist > MAXCGMOVEMENT) {
            score += 10;
        }
        if (lifeTime < MINLIFETIME) {
            score += 100;
        }
        return score -= 1000;
    }

    public String division(String par, String dau, String dau2, int now, int score) {
        StringBuffer sb = new StringBuffer(par);
        sb.append(CS + now);
        sb.append(CS + dau);
        sb.append(CS + dau2);
        sb.append(CS + DF000.format(score));
        return sb.toString();
    }

    private void unDivide() {
        int[] remove = this.iCellList.getSelectedIndices();
        int i = remove.length - 1;
        while (i >= 0) {
            String s = (String)this.iListModel.elementAt(remove[i]);
            String[] sa = s.split(CS);
            Siamese.println("unlink, " + sa[2] + CS + sa[3]);
            int time = Integer.parseInt(sa[1]) + 1;
            NucRelinkDialog.iNucleiMgr = this.iNucleiMgr;
            NucRelinkDialog.createAndAddCells(sa[2], time, "ROOT", 1);
            NucRelinkDialog.createAndAddCells(sa[3], time, "ROOT", 1);
            --i;
        }
        this.rebuildAndRename();
    }

    private void rebuildAndRename() {
        this.iAceTree.clearTree();
        this.iAceTree.buildTree(true);
        this.iNamesAvailable = false;
        this.iListModel.clear();
        this.initialize();
        this.test1();
    }

    private void setParms() {
        Parms myDialog = new Parms(this.iFrame, true);
    }

    private int jump(CellData cd0, CellData cd1) {
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Nucleus n0 = cd0.iNucleus;
        Nucleus n1 = cd1.iNucleus;
        int x = n0.x;
        int y = n0.y;
        int z = (int)(zPixRes * (double)n0.z);
        int zz = (int)(zPixRes * (double)n1.z);
        int dx = n1.x - x;
        int dy = n1.y - y;
        int dz = zz - z;
        int d2 = dx * dx + dy * dy + dz * dz;
        d2 = (int)Math.round(Math.sqrt(d2));
        return d2;
    }

    public int compare(Object arg0, Object arg1) {
        double d1;
        int rtn = 1;
        String[] sa = ((String)arg0).split(CS);
        double d0 = Double.parseDouble(sa[2]);
        if (d0 > (d1 = Double.parseDouble((sa = ((String)arg1).split(CS))[2]))) {
            rtn = -1;
        }
        return rtn;
    }

    private void addItems(Vector vv, ImageWindow imgWin) {
        int last = Math.min(vv.size(), 10);
        int i = 0;
        while (i < last) {
            D dd = (D)vv.get(i);
            imgWin.addAnnotation(dd.id, dd.x, dd.y);
            StringBuffer sb = new StringBuffer();
            sb.append(i);
            sb.append(CS + dd.id);
            sb.append(CS + dd.d);
            sb.append(CS + dd.time);
            sb.append(CS + dd.n.z);
            this.iListModel.addElement(sb.toString());
            ++i;
        }
    }

    private void help() {
        int i = 0;
        while (i < this.shelp.length) {
            this.iListModel.addElement(this.shelp[i]);
            ++i;
        }
    }

    private String getConfigFileInfo(String longName) {
        String s = longName.substring(longName.lastIndexOf(47) + 1);
        s = s.substring(0, s.indexOf(46));
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (e.getSource() == this.iCombo) {
            String newSelection = (String)this.iCombo.getSelectedItem();
            this.iAceTree.restoreTree(newSelection);
        } else if (s.equals("Divisions")) {
            this.test1();
        } else if (s.equals("UnDivide")) {
            this.unDivide();
        } else if (s.equals(CLEAR)) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
            this.help();
        } else if (s.equals("setParms")) {
            this.setParms();
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("start/end"));
        this.iTextField2 = new JTextField();
        this.iTextField2.setColumns(5);
        this.iTextField2.setText("100");
        this.iToolBar.add(this.iTextField2);
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("200");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton("Divisions");
        this.addToolBarButton(jb);
        jb = new JButton("UnDivide");
        this.addToolBarButton(jb);
        jb = new JButton("setParms");
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    protected void addComboBox(JComboBox jcb) {
        jcb.addActionListener(this);
        this.iToolBar.add(jcb);
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(2);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iScrollPane = new JScrollPane(this.iCellList);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            if (this.iTest == 2) {
                name = sa[1];
                this.iTime = Integer.parseInt(sa[3]);
            } else if (this.iTest == 1) {
                name = sa[0];
                this.iTime = Integer.parseInt(sa[1]);
            } else if (this.iTest == 3) {
                name = sa[0];
                this.iTime = Integer.parseInt(sa[2]);
            } else if (this.iTest == 4) {
                name = sa[1];
            }
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private class D
    implements Comparator {
        String id;
        int d;
        int x;
        int y;
        float z;
        Nucleus n;
        int k;
        int time;

        public D() {
        }

        public D(String s, int dd, int xx, int yy, float zz, Nucleus nn, int kk, int t) {
            this.id = s;
            this.d = dd;
            this.x = xx;
            this.y = yy;
            this.z = zz;
            this.n = nn;
            this.k = kk;
            this.time = t;
        }

        public int compare(Object o1, Object o2) {
            D d1 = (D)o1;
            D d2 = (D)o2;
            int rtn = 0;
            if (d1.d < d2.d) {
                rtn = -1;
            } else if (d1.d > d2.d) {
                rtn = 1;
            }
            return rtn;
        }
    }

    private class Parms
    extends JDialog
    implements ActionListener {
        private JPanel iPanel;
        private JButton iOKButton;
        private JButton iCancelButton;
        private JTextField iMinDauMove;
        private JTextField iMaxDauMove;
        private JTextField iMaxCGMove;
        private JTextField iMinLifeTime;

        public Parms(JFrame frame, boolean modal) {
            super((Frame)frame, modal);
            this.iPanel = null;
            this.iOKButton = null;
            this.iCancelButton = null;
            this.iPanel = new JPanel();
            this.getContentPane().add(this.iPanel);
            this.iPanel.setLayout(new GridLayout(0, 1));
            this.iMinLifeTime = new JTextField(String.valueOf(MINLIFETIME));
            this.iMaxCGMove = new JTextField(String.valueOf(MAXCGMOVEMENT));
            this.iMaxDauMove = new JTextField(String.valueOf(MAXMOVEMENT));
            this.iMinDauMove = new JTextField(String.valueOf(MINMOVEMENT));
            this.iPanel.add(new JLabel("min lifetime"));
            this.iPanel.add(this.iMinLifeTime);
            this.iPanel.add(new JLabel("max CG move"));
            this.iPanel.add(this.iMaxCGMove);
            this.iPanel.add(new JLabel("max dau move"));
            this.iPanel.add(this.iMaxDauMove);
            this.iPanel.add(new JLabel("min dau move"));
            this.iPanel.add(this.iMinDauMove);
            this.iOKButton = new JButton("OK");
            this.iOKButton.addActionListener(this);
            this.iPanel.add(this.iOKButton);
            this.iCancelButton = new JButton("Cancel");
            this.iCancelButton.addActionListener(this);
            this.iPanel.add(this.iCancelButton);
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.iOKButton == e.getSource()) {
                MINLIFETIME = Integer.parseInt(this.iMinLifeTime.getText());
                MAXCGMOVEMENT = Integer.parseInt(this.iMaxCGMove.getText());
                MINMOVEMENT = Integer.parseInt(this.iMinDauMove.getText());
                MAXMOVEMENT = Integer.parseInt(this.iMaxDauMove.getText());
            }
            this.setVisible(false);
        }
    }
}

