/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.EditLog;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Log;

public class SkipFalseNegatives
extends JDialog
implements ActionListener {
    private AceTree iAceTree = AceTree.getAceTree(null);
    private NucleiMgr iNucleiMgr = this.iAceTree.getNucleiMgr();
    private JTextField iRelinkTime;
    private JTextField iRelinkNuc;
    private JTextField iLinkTime;
    private JTextField iLinkNuc;
    private JButton iDoit;
    private JButton iApplyAndRebuild;
    private JButton iApplyOnly;
    private JButton iLinkButton;
    private JButton iSkipFalseNegativesButton;
    private JButton iContinueButton;
    private EditLog iEditLog = this.iAceTree.getEditLog();
    private Log iDLog = this.iAceTree.getDebugLog();
    private int iStrTime;
    private static final String TITLE = "Skip False Negatives";
    private static final String RELINKTIME = "Later time";
    private static final String RELINKNUC = "Cell name";
    private static final String LINKTIME = "Earlier time";
    private static final String LINKNUC = "Cell name";
    private static final String DOIT = "Apply";
    private static final String CS = ", ";
    private static final String NL = "\n";
    private static final String APPLYANDREBUILD = "apply/rebuild";
    private static final String APPLYONLY = "apply only";
    private static final String SETCURRENTCELL = "set current cell";
    private static final String SKIPFALSENEGS = "skip false negatives";
    private static final String CONTINUESKIPPING = "continue skipping";
    private static final String LATER = "cell at earlier time";
    private static final String EARLIER = "search for ancesters of";
    private static final int LARGETIME = 1000;

    public SkipFalseNegatives() {
        super((Frame)AceTree.getAceTree(null).getMainFrame(), false);
        this.setTitle(TITLE);
        SkipFalseNegatives dialog = this;
        JPanel pWhole = new JPanel();
        pWhole.setLayout(new BoxLayout(pWhole, 3));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        Border topBorder = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        Border botBorder = BorderFactory.createEmptyBorder(0, 0, 10, 0);
        JPanel labelAtTop = new JPanel();
        labelAtTop.setLayout(new GridLayout(2, 1));
        labelAtTop.setBorder(blackline);
        JLabel topLab = new JLabel(EARLIER);
        Font f = topLab.getFont();
        int size = (int)((double)f.getSize() * 1.3);
        Font f2 = new Font(f.getName(), f.getStyle(), size);
        topLab.setFont(f2);
        labelAtTop.add(topLab);
        JLabel botLab = new JLabel(LATER);
        botLab.setFont(f2);
        labelAtTop.add(botLab);
        pWhole.add(labelAtTop);
        JPanel pStr = new JPanel();
        pStr.setLayout(new BoxLayout(pStr, 3));
        pStr.setBorder(blackline);
        JPanel s = new JPanel();
        s.setLayout(new FlowLayout());
        JLabel label = new JLabel(LINKTIME);
        s.add(label);
        this.iLinkTime = new JTextField();
        this.iLinkTime.setColumns(5);
        s.add(this.iLinkTime);
        s.setBorder(topBorder);
        pStr.add(s);
        s = new JPanel();
        s.setLayout(new FlowLayout());
        label = new JLabel("Cell name");
        s.add(label);
        this.iLinkNuc = new JTextField();
        this.iLinkNuc.setColumns(12);
        s.add(this.iLinkNuc);
        s.setBorder(botBorder);
        pStr.add(s);
        this.iLinkButton = new JButton(SETCURRENTCELL);
        this.iLinkButton.addActionListener(this);
        s = new JPanel();
        s.setLayout(new GridLayout(1, 1));
        s.setBorder(topBorder);
        s.add(this.iLinkButton);
        pStr.add(s);
        pWhole.add(pStr);
        JPanel pEnd = new JPanel();
        pEnd.setLayout(new BoxLayout(pEnd, 3));
        pEnd.setBorder(blackline);
        s = new JPanel();
        s.setLayout(new FlowLayout());
        label = new JLabel(RELINKTIME);
        s.add(label);
        this.iRelinkTime = new JTextField();
        this.iRelinkTime.setColumns(5);
        s.setBorder(topBorder);
        s.add(this.iRelinkTime);
        pEnd.add(s);
        s = new JPanel();
        s.setLayout(new FlowLayout());
        label = new JLabel("Cell name");
        s.add(label);
        this.iRelinkNuc = new JTextField();
        this.iRelinkNuc.setColumns(12);
        s.add(this.iRelinkNuc);
        s.setBorder(botBorder);
        pEnd.add(s);
        this.iSkipFalseNegativesButton = new JButton(SKIPFALSENEGS);
        this.iSkipFalseNegativesButton.addActionListener(this);
        this.iContinueButton = new JButton(CONTINUESKIPPING);
        this.iContinueButton.addActionListener(this);
        s = new JPanel();
        s.setLayout(new GridLayout(0, 1));
        s.setBorder(topBorder);
        s.add(this.iSkipFalseNegativesButton);
        s.add(this.iContinueButton);
        pEnd.add(s);
        pWhole.add(pEnd);
        JPanel xp = new JPanel();
        xp.setBorder(blackline);
        xp.setLayout(new BoxLayout(xp, 3));
        Border b = BorderFactory.createEmptyBorder(10, 0, 10, 0);
        s = new JPanel();
        s.setLayout(new GridLayout(3, 1));
        s.add(new JLabel(""));
        this.iApplyAndRebuild = new JButton(APPLYANDREBUILD);
        this.iApplyAndRebuild.addActionListener(this);
        s.add(this.iApplyAndRebuild);
        this.iApplyOnly = new JButton(APPLYONLY);
        this.iApplyOnly.addActionListener(this);
        s.add(this.iApplyOnly);
        pWhole.add(s);
        pWhole.setOpaque(true);
        dialog.setContentPane(pWhole);
        dialog.setSize(new Dimension(220, 400));
        dialog.setLocationRelativeTo(AceTree.getAceTree(null).getMainFrame());
        dialog.setVisible(true);
    }

    private void skipFalseNegatives(boolean fresh) {
        boolean b;
        int strIncrement = 0;
        if (fresh) {
            try {
                this.iStrTime = Integer.parseInt(this.iLinkTime.getText());
            }
            catch (NumberFormatException nfe) {
                this.showMessage("invalid link time, aborting");
                return;
            }
        }
        try {
            strIncrement = Integer.parseInt(this.iRelinkTime.getText()) + 1 - this.iStrTime;
        }
        catch (NumberFormatException nfe) {
            this.showMessage("invalid relink time, aborting");
            return;
        }
        int strTime = this.iStrTime;
        String strCellName = this.iLinkNuc.getText();
        if (fresh) {
            Cell c = this.iAceTree.getCellByName(strCellName);
            strTime = c.getEndTime();
        }
        this.iLinkTime.setText(String.valueOf(strTime));
        if (fresh && !(b = this.checkStartingCellValidity(strCellName, strTime))) {
            return;
        }
        Nucleus n = this.iNucleiMgr.getCurrentCellData(strCellName, strTime);
        if (n == null) {
            return;
        }
        int endingIndex = this.iNucleiMgr.getEndingIndex();
        Nucleus nc = null;
        int i = strTime + 1 + strIncrement;
        while (i <= endingIndex) {
            nc = this.iNucleiMgr.findClosestNucleusXYZ(n.x, n.y, n.z, i);
            if (nc != null) break;
            ++i;
        }
        if (nc == null) {
            this.showMessage("nothing found");
            return;
        }
        Cell cc = (Cell)this.iAceTree.getAncesTree().getCellsByName().get(nc.identity);
        this.iAceTree.setCurrentCell(cc, i, 4);
        this.iRelinkTime.setText(String.valueOf(i));
        this.iRelinkNuc.setText(nc.identity);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iLinkButton) {
            int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
            this.iLinkTime.setText(String.valueOf(time));
            this.iLinkNuc.setText(this.iAceTree.getCurrentCell().getName());
        } else if (o == this.iSkipFalseNegativesButton) {
            this.skipFalseNegatives(true);
        } else if (o == this.iContinueButton) {
            this.skipFalseNegatives(false);
        } else if (o == this.iApplyAndRebuild || o == this.iApplyOnly) {
            String strCellName;
            int strTime;
            int endTime;
            try {
                endTime = Integer.parseInt(this.iRelinkTime.getText());
            }
            catch (NumberFormatException nfe) {
                this.showMessage("invalid relink time, aborting");
                return;
            }
            try {
                strTime = Integer.parseInt(this.iLinkTime.getText());
            }
            catch (NumberFormatException nfe) {
                this.showMessage("invalid link time, aborting");
                return;
            }
            if (endTime <= strTime) {
                this.showMessage("endTime is not greater than start time, aborting");
                return;
            }
            String endCellName = this.iRelinkNuc.getText();
            boolean b = this.checkCellValidities(endCellName, endTime, strCellName = this.iLinkNuc.getText(), strTime);
            if (!b) {
                return;
            }
            StringBuffer sb = new StringBuffer("RELINKING: ");
            sb.append(endTime);
            sb.append(CS + endCellName);
            sb.append(this.iNucleiMgr.getIndex(endCellName, endTime));
            sb.append(CS + strTime);
            sb.append(CS + strCellName);
            sb.append(this.iNucleiMgr.getIndex(strCellName, strTime));
            System.out.println(sb.toString());
            this.iEditLog.append(sb.toString());
            this.iNucleiMgr.makeBackupNucleiRecord();
            this.createAndAddCells(endCellName, endTime, strCellName, strTime);
            if (o == this.iApplyAndRebuild) {
                this.iAceTree.clearTree();
                this.iAceTree.buildTree(true);
                AncesTree ances = this.iAceTree.getAncesTree();
                Hashtable h = ances.getCellsByName();
                Cell c = (Cell)h.get(strCellName);
                this.iAceTree.setStartingCell(c, 1000);
                this.iEditLog.setModified(true);
            }
        }
    }

    private boolean checkStartingCellValidity(String strCellName, int strTime) {
        Nucleus nStr = this.iNucleiMgr.getCurrentCellData(strCellName, strTime);
        if (nStr == null) {
            String s = "";
            String s0 = "";
            String s1 = "";
            if (nStr == null) {
                s1 = "invalid cell: " + strCellName + CS + strTime + NL;
            }
            this.showMessage(String.valueOf(s0) + s1);
            return false;
        }
        if (nStr.successor2 > 0) {
            String s = "Cell " + strCellName + " already has 2 successors\n";
            s = String.valueOf(s) + "cannot complete relink.";
            this.showMessage(s);
            return false;
        }
        return true;
    }

    private boolean checkCellValidities(String endCellName, int endTime, String strCellName, int strTime) {
        Nucleus nEnd = this.iNucleiMgr.getCurrentCellData(endCellName, endTime);
        Nucleus nStr = this.iNucleiMgr.getCurrentCellData(strCellName, strTime);
        if (nEnd == null || nStr == null) {
            String s = "";
            String s0 = "";
            String s1 = "";
            if (nEnd == null) {
                s0 = "invalid cell: " + endCellName + CS + endTime + NL;
            }
            if (nStr == null) {
                s1 = "invalid cell: " + strCellName + CS + strTime + NL;
            }
            this.showMessage(String.valueOf(s0) + s1);
            return false;
        }
        if (nStr.successor2 > 0) {
            String s = "Cell " + strCellName + " already has 2 successors\n";
            s = String.valueOf(s) + "cannot complete relink.";
            this.showMessage(s);
            return false;
        }
        return true;
    }

    private void showMessage(String s) {
        JOptionPane pane = new JOptionPane(s);
        JDialog dialog = pane.createDialog(this.iAceTree, "About AceTree");
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    private void createAndAddCells(String endCellName, int endTime, String strCellName, int strTime) {
        Nucleus nEnd = this.getNucleus(endCellName, endTime);
        Nucleus nStr = this.getNucleus(strCellName, strTime);
        Vector nuclei_record = this.iNucleiMgr.getNucleiRecord();
        Vector nucleiAdd = null;
        Nucleus n = nStr;
        int predecessor = nStr.index;
        int k = strTime + 1;
        while (k < endTime) {
            nucleiAdd = (Vector)nuclei_record.elementAt(k - 1);
            n = this.interpolateNucleus(nEnd, nStr, endTime, strTime, k);
            n.index = nucleiAdd.size() + 1;
            n.predecessor = predecessor;
            predecessor = n.index;
            this.iEditLog.append("adding: " + n.toString());
            nucleiAdd.add(n);
            ++k;
        }
        nEnd.predecessor = n.index;
    }

    private Nucleus getNucleus(String name, int time) {
        Nucleus n = null;
        Vector nuclei_record = this.iNucleiMgr.getNucleiRecord();
        Vector nuclei = (Vector)nuclei_record.elementAt(time - 1);
        int j = 0;
        while (j < nuclei.size()) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.identity.equals(name)) break;
            ++j;
        }
        return n;
    }

    private Nucleus interpolateNucleus(Nucleus nEnd, Nucleus nStr, int endTime, int strTime, int midTime) {
        Nucleus n = nStr.copy();
        int deltaT = endTime - strTime;
        int deltaM = midTime - strTime;
        n.x = (nEnd.x - nStr.x) * deltaM / deltaT + nStr.x;
        n.y = (nEnd.y - nStr.y) * deltaM / deltaT + nStr.y;
        n.z = (nEnd.z - nStr.z) * (float)deltaM / (float)deltaT + nStr.z;
        n.size = (nEnd.size - nStr.size) * deltaM / deltaT + nStr.size;
        return n;
    }
}

