/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.nucedit.NucRelinkDialog;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class UnifiedNucRelinkDialog
extends NucRelinkDialog {
    private JButton iAddKeyframe;
    private JButton iInactivate;
    private JCheckBox iWarned;
    private boolean addKeyframeActive = false;
    private JLabel iStatus;
    public static final String KEYFRAME = "Add Intermediate Cell";
    public static final String KEYFRAMEHEADER = "Add Cell as Intermediate (Optional)";
    public static final String WARNING = "Warning:Is early set correctly?";
    public static final String DEACTIVATE = "Deactivate";

    public UnifiedNucRelinkDialog(AceTree aceTree, Frame owner, boolean modal, Cell cell, int time) {
        super(owner, modal);
        Border blackline = BorderFactory.createLineBorder(Color.black);
        this.iAceTree = aceTree;
        iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iEditLog = this.iAceTree.getEditLog();
        this.setTitle("Edit Track");
        UnifiedNucRelinkDialog dialog = this;
        this.addWindowListener(new NucRelinkDialog.WindowEventHandler(this));
        dialog.setDefaultCloseOperation(2);
        JPanel pWhole = new JPanel();
        this.createEarlyPanel(pWhole);
        JPanel middle = new JPanel();
        middle.setLayout(new BoxLayout(middle, 3));
        middle.setAlignmentX(0.5f);
        middle.setBackground(Color.white);
        middle.setForeground(Color.white);
        this.iAddKeyframe = new JButton(KEYFRAME);
        this.iAddKeyframe.addActionListener(this);
        JLabel label = new JLabel(KEYFRAMEHEADER, 0);
        label.setAlignmentX(0.5f);
        middle.add(label);
        JPanel warngroup = new JPanel();
        warngroup.setBackground(Color.white);
        label = new JLabel(WARNING);
        label.setAlignmentX(0.5f);
        warngroup.add(label);
        this.iWarned = new JCheckBox();
        warngroup.add(this.iWarned);
        warngroup.setAlignmentX(0.5f);
        middle.add(warngroup);
        middle.add(this.iAddKeyframe);
        this.iAddKeyframe.setAlignmentX(0.5f);
        this.iStatus = new JLabel("Inactive");
        this.iStatus.setAlignmentX(0.5f);
        middle.add(this.iStatus);
        middle.add(Box.createVerticalGlue());
        middle.add(new JPanel());
        pWhole.add(new JSeparator(0));
        pWhole.add(new JSeparator(0));
        pWhole.add(middle);
        pWhole.add(new JSeparator(0));
        pWhole.add(new JSeparator(0));
        this.createLatePanel(pWhole, owner);
        this.setSize(new Dimension(230, 460));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        String cmd = e.getActionCommand();
        if (o != this.iAddKeyframe) {
            super.actionPerformed(e);
            this.addKeyframeActive = false;
            this.iAddKeyframe.setText(KEYFRAME);
            this.iStatus.setText("Inactive");
            this.iStatus.setForeground(Color.black);
            this.iWarned.setSelected(false);
            return;
        }
        if (this.addKeyframeActive) {
            this.addKeyframeActive = false;
            this.iAddKeyframe.setText(KEYFRAME);
            this.iStatus.setText("Inactive");
            this.iStatus.setForeground(Color.black);
            this.iWarned.setSelected(false);
            return;
        }
        if (this.iWarned.isSelected()) {
            this.addKeyframeActive = true;
            this.iAddKeyframe.setText("Stop Adding");
            this.iStatus.setText("Active");
            this.iStatus.setForeground(Color.red);
            return;
        }
        this.iStatus.setText("Warning Checkbox Not Selected!");
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.addKeyframeActive & this.iWarned.isSelected()) {
            String strCellName = this.iLinkNuc.getText();
            int x = e.getX();
            int y = e.getY();
            int z = this.iAceTree.getImagePlane() + this.iAceTree.getPlaneInc();
            int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
            if (!this.iStartArmed || strCellName.equals("ROOT")) {
                String ID = this.addCell(x, y);
                this.iAceTree.clearTree();
                this.iAceTree.buildTree(true);
            } else {
                int startTime;
                try {
                    startTime = Integer.parseInt(this.iLinkTime.getText());
                }
                catch (NumberFormatException nfe) {
                    System.out.println("invalid relink time, aborting");
                    return;
                }
                if (startTime < time) {
                    this.relinkIntermediateCell(x, y);
                } else {
                    System.out.println("Start: " + startTime + " current " + time + " cannot extend before end of track");
                    return;
                }
            }
            Nucleus itself = ImageWindow.cNucleiMgr.findClosestNucleusXYZ(x, y, z, time);
            Cell itselfcell = (Cell)this.iAceTree.getAncesTree().getCellsByName().get(itself.identity);
            this.iAceTree.setStartingCell(itselfcell, time);
            this.iLinkTime.setText(Integer.toString(time));
            this.iLinkNuc.setText(itself.identity);
            this.iStartArmed = true;
        }
    }

    protected String addCell(int x, int y) {
        int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)ImageWindow.cNucleiMgr.getNucleiRecord().elementAt(time - 1);
        Nucleus n = new Nucleus();
        n.index = nuclei.size() + 1;
        String hashKey = NucUtils.makeHashKey(time, n);
        n.setHashKey(hashKey);
        n.status = 1;
        n.x = x;
        n.y = y;
        int plane = this.iAceTree.getImagePlane() + this.iAceTree.getPlaneInc();
        n.z = plane;
        System.out.println("make nucleus " + x + " " + y + " " + plane + " " + time);
        Cell ccur = this.iAceTree.getCurrentCell();
        if (ccur != null) {
            int diameter = (int)ccur.getDiam();
            if (diameter <= 0) {
                diameter = 5;
            }
            n.size = diameter;
        } else {
            n.size = 20;
        }
        n.identity = "_" + hashKey;
        n.predecessor = -1;
        n.successor1 = -1;
        n.successor2 = -1;
        nuclei.add(n);
        Cell c = new Cell(n.identity, time);
        c.setHashKey(hashKey);
        this.iAceTree.getAncesTree().getCells().put(hashKey, c);
        this.iAceTree.setShowCentroids(true);
        c.setParameters(time, time, n);
        Cell root = this.iAceTree.getAncesTree().getRoot();
        c.setParent(root);
        this.iAceTree.setCurrentCell(c, time, 7);
        this.iAceTree.getImageWindow().addAnnotation(x, y, true);
        return n.identity;
    }

    protected void relinkIntermediateCell(int x, int y) {
        System.out.println("adding tween");
        String ID = this.addCell(x, y);
        int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        this.iRelinkTime.setText(Integer.toString(time));
        this.iRelinkNuc.setText(ID);
        this.relinkAndRebuild();
        AncesTree ances = this.iAceTree.getAncesTree();
        Hashtable h = ances.getCellsByName();
        Cell c = (Cell)h.get(this.iLinkNuc);
        if (c != null) {
            System.out.println("not null so setting current cell " + c);
        }
        this.iAceTree.setStartingCell(c, time);
    }
}

