/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;

public class Zafer1
extends JDialog
implements ActionListener,
ListSelectionListener {
    String iTitle = "Zafer1";
    JToolBar iToolBar;
    JFrame iFrame;
    JTextField iTextField;
    JTextField iTextField2;
    DefaultListModel iListModel;
    JList iCellList;
    JScrollPane iScrollPane;
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    AncesTree iAncesTree;
    Hashtable iCellsByName;
    Cell iRoot;
    int iLastTime;
    Vector iSortedCellNames;
    Hashtable iZafer1Hash;
    Hashtable iZafer2Hash;
    boolean iNamesAvailable;
    int iTest;
    int iTime;
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Deaths";
    private static final String TEST2 = "Adj back";
    private static final String TEST3 = "Adj forward";
    private static final String TEST4 = "Jumps";
    private static final String TEST5 = "Test5";
    private static final String HELP = "Help";
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String SP = " ";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public Zafer1() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        p.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList();
        p.add(this.iScrollPane);
        this.initialize();
        this.setVisible(true);
        this.pack();
    }

    double evaluateDivision1(Nucleus parent, Nucleus dau1, Nucleus dau2, int now) {
        int index = parent.index;
        String key = this.makeZaferKey(now, index);
        Object o1 = this.iZafer1Hash.get(key);
        if (o1 == null) {
            return 999.0;
        }
        return (Double)o1;
    }

    double evaluateDivision2(Nucleus parent, Nucleus dau1, Nucleus dau2, int now) {
        int index = parent.index;
        String key = this.makeZaferKey(now, index);
        Object o1 = this.iZafer2Hash.get(key);
        if (o1 == null) {
            return 999.0;
        }
        return (Double)o1;
    }

    private String help() {
        return "### DIVISIONS: dividing cell, dau1, dau2, time, divScore";
    }

    private String helpMovements() {
        return "### MOVEMENTS: dividing cell, dau1, dau2, time, moveScore";
    }

    void fillList() {
        this.initialize();
        this.iNamesAvailable = false;
        this.iTest = 1;
        NucUtils.setZPixRes(this.iNucleiMgr.getZPixRes());
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        t1 = Integer.parseInt(this.iTextField2.getText());
        t2 = Integer.parseInt(this.iTextField.getText());
        this.iListModel.clear();
        this.iListModel.addElement(this.help());
        int i = t1;
        while (i <= t2) {
            this.showDivisions(i);
            ++i;
        }
        this.iNamesAvailable = true;
    }

    public void showDivisions(int now) {
        this.iNamesAvailable = false;
        this.iTest = 1;
        Vector nucleiNow = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        Nucleus nnow = null;
        int j = 0;
        while (j < nucleiNow.size()) {
            Nucleus p;
            Vector nucleiNext;
            Nucleus a;
            double score1;
            nnow = (Nucleus)nucleiNow.elementAt(j);
            if (nnow.status > 0 && nnow.successor1 > 0 && nnow.successor2 > 0 && ((score1 = this.evaluateDivision1(nnow, a = (Nucleus)(nucleiNext = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now)).elementAt(nnow.successor1 - 1), p = (Nucleus)nucleiNext.elementAt(nnow.successor2 - 1), now)) != 999.0 || score1 != 999.0)) {
                this.iListModel.addElement(this.division(nnow.identity, a.identity, p.identity, now, score1));
            }
            ++j;
        }
        if (!this.isShowing()) {
            this.showMe();
        }
        this.iNamesAvailable = true;
    }

    public String division(String par, String dau, String dau2, int now, double score1) {
        StringBuffer sb = new StringBuffer(par);
        sb.append(CS + now);
        sb.append(CS + dau);
        sb.append(CS + dau2);
        if (score1 != 999.0) {
            sb.append(CS + DF4.format(score1));
        } else {
            sb.append(",              ");
        }
        return sb.toString();
    }

    void fillMovementsList() {
        this.initialize();
        this.iNamesAvailable = false;
        this.iTest = 1;
        NucUtils.setZPixRes(this.iNucleiMgr.getZPixRes());
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        t1 = Integer.parseInt(this.iTextField2.getText());
        t2 = Integer.parseInt(this.iTextField.getText());
        this.iListModel.clear();
        this.iListModel.addElement(this.helpMovements());
        int i = t1;
        while (i <= t2) {
            this.showMovements(i);
            ++i;
        }
        this.iNamesAvailable = true;
    }

    public void showMovements(int now) {
        this.iNamesAvailable = false;
        this.iTest = 1;
        Vector nucleiNow = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        Nucleus nnow = null;
        int j = 0;
        while (j < nucleiNow.size()) {
            Nucleus p;
            Vector nucleiNext;
            Nucleus a;
            double score2;
            nnow = (Nucleus)nucleiNow.elementAt(j);
            if (nnow.status > 0 && nnow.successor1 > 0 && nnow.successor2 > 0 && (score2 = this.evaluateDivision2(nnow, a = (Nucleus)(nucleiNext = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now)).elementAt(nnow.successor1 - 1), p = (Nucleus)nucleiNext.elementAt(nnow.successor2 - 1), now)) != 999.0) {
                this.iListModel.addElement(this.movement(nnow.identity, a.identity, p.identity, now, score2));
            }
            ++j;
        }
        if (!this.isShowing()) {
            this.showMe();
        }
        this.iNamesAvailable = true;
    }

    public String movement(String par, String dau, String dau2, int now, double score2) {
        StringBuffer sb = new StringBuffer(par);
        sb.append(CS + now);
        sb.append(CS + dau);
        sb.append(CS + dau2);
        if (score2 != 999.0) {
            sb.append(CS + DF4.format(score2));
        } else {
            sb.append(",              ");
        }
        return sb.toString();
    }

    void prepareZaferDivisions() {
        this.iZafer1Hash = new Hashtable();
        this.iZafer2Hash = new Hashtable();
        Config config = this.iNucleiMgr.getConfig();
        Zafer1.println("prepareZaferDivisions, " + config.iParent);
        Zafer1.println("prepareZaferDivisions, " + config.iConfigFileName);
        File z1 = new File(String.valueOf(config.iParent) + "/svm_output_correct_division_calls.txt");
        File z2 = new File(String.valueOf(config.iParent) + "/svm_output_movements_called_as_divisions.txt");
        boolean bz1 = z1.exists();
        boolean bz2 = z2.exists();
        Zafer1.println("prepareZaferDivisions, " + bz1 + CS + bz2);
        Hashtable h = null;
        if (bz1) {
            h = this.iZafer1Hash;
            this.readZafer(z1, h);
        }
        if (bz2) {
            h = this.iZafer2Hash;
            this.readZafer(z2, h);
        }
        this.fillList();
    }

    void prepareZaferMovements() {
        this.iZafer2Hash = new Hashtable();
        Config config = this.iNucleiMgr.getConfig();
        Zafer1.println("prepareZaferMovements, " + config.iParent);
        Zafer1.println("prepareZaferMovements, " + config.iConfigFileName);
        File z2 = new File(String.valueOf(config.iParent) + "/svm_output_movements_called_as_divisions.txt");
        boolean bz2 = z2.exists();
        Hashtable h = null;
        if (bz2) {
            h = this.iZafer2Hash;
            this.readZafer(z2, h);
        }
        this.fillMovementsList();
    }

    void readZafer(File f, Hashtable h) {
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while (br.ready()) {
                String s = br.readLine();
                this.parseZaferLine(s, h);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void parseZaferLine(String s, Hashtable h) {
        String[] sa = s.split("\\s+");
        int time = Integer.parseInt(sa[2]);
        int index = Integer.parseInt(sa[6]);
        double score = Double.parseDouble(sa[10]);
        String key = this.makeZaferKey(time, index);
        h.put(key, new Double(score));
    }

    String makeZaferKey(int time, int index) {
        String s1 = EUtils.makePaddedInt(time, 4);
        String s2 = EUtils.makePaddedInt(index, 4);
        String r = String.valueOf(s1) + s2;
        return r;
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAceTree.getRoot();
        this.makeSortedCellNames();
        this.iLastTime = this.estimate350CellStage();
    }

    private void makeSortedCellNames() {
        this.iSortedCellNames = new Vector();
        Enumeration e = this.iCellsByName.keys();
        boolean i = false;
        while (e.hasMoreElements()) {
            this.iSortedCellNames.add((String)e.nextElement());
        }
        Collections.sort(this.iSortedCellNames);
    }

    private int estimate350CellStage() {
        int stage = 355;
        boolean r = false;
        int size = 0;
        int time = 0;
        int i = 0;
        while (i < this.nuclei_record.size()) {
            Vector nuclei = (Vector)this.nuclei_record.get(i);
            int t = nuclei.size();
            if (t > size) {
                size = t;
                time = i;
            }
            int count = 0;
            if (size > stage) {
                count = 0;
                int j = 0;
                while (j < nuclei.size()) {
                    Nucleus n = (Nucleus)nuclei.get(j);
                    if (n.status > 0 && !n.identity.startsWith("N")) {
                        ++count;
                    }
                    ++j;
                }
            }
            if (count > stage) break;
            ++i;
        }
        return time + 1;
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(2);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setVisibleRowCount(10);
        this.iScrollPane = new JScrollPane(this.iCellList);
        this.iListModel.addElement(this.help());
    }

    private void buildOutToolBar() {
        this.iToolBar.add(new JLabel("start/end"));
        this.iTextField2 = new JTextField();
        this.iTextField2.setColumns(5);
        this.iTextField2.setText("1");
        this.iToolBar.add(this.iTextField2);
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("40");
        this.iToolBar.add(this.iTextField);
        JButton jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton("Divisions");
        this.addToolBarButton(jb);
        jb = new JButton("Movements");
        this.addToolBarButton(jb);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Divisions")) {
            this.prepareZaferDivisions();
        } else if (s.equals("Movements")) {
            this.prepareZaferMovements();
        } else if (s.equals(CLEAR)) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
            this.iListModel.addElement(this.help());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            name = sa[0];
            this.iTime = Integer.parseInt(sa[1]);
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

