/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.MeasureCSV;
import org.rhwlab.snight.Nucleus;

public class DivisionCaller {
    Hashtable iRulesHash;
    Hashtable iSulstonHash;
    String iAxis;
    String iAxisUse;
    double iZPixRes;
    MeasureCSV iMeasureCSV;
    double iAng;
    double iEMajor;
    double iEMinor;
    double iZSlope;
    Vector2d iAngVec;
    double iDMajor;
    double iDMinor;
    double iDSlope;
    boolean iDebug;
    double[] iDaCorrected;
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public DivisionCaller(String axis, double zpixRes, MeasureCSV measureCSV) {
        this.iRulesHash = new Hashtable();
        this.readNewRules();
        this.readSulstonRules();
        this.iAxis = axis.toUpperCase();
        this.iZPixRes = zpixRes;
        this.iMeasureCSV = measureCSV;
        this.getScalingParms();
    }

    public DivisionCaller() {
    }

    void getScalingParms() {
        String sang = (String)this.iMeasureCSV.iMeasureHash.get("ang");
        this.iAng = sang.length() > 0 ? Math.toRadians(-Double.parseDouble(sang)) : Math.toRadians(-Double.parseDouble(MeasureCSV.defaultAtt[7]));
        this.iAngVec = new Vector2d(Math.cos(this.iAng), Math.sin(this.iAng));
        String smaj = (String)this.iMeasureCSV.iMeasureHash.get("maj");
        this.iEMajor = smaj.length() > 0 ? Double.parseDouble(smaj) : Double.parseDouble(MeasureCSV.defaultAtt[5]);
        String smin = (String)this.iMeasureCSV.iMeasureHash.get("min");
        this.iEMinor = smin.length() > 0 ? Double.parseDouble(smin) : Double.parseDouble(MeasureCSV.defaultAtt[6]);
        String szslope = (String)this.iMeasureCSV.iMeasureHash.get("zslope");
        this.iZSlope = szslope.length() > 0 ? Double.parseDouble(szslope) : Double.parseDouble(MeasureCSV.defaultAtt[9]);
        this.iDMajor = Double.parseDouble(MeasureCSV.defaultAtt[5]);
        this.iDMinor = Double.parseDouble(MeasureCSV.defaultAtt[6]);
        this.iDSlope = Double.parseDouble(MeasureCSV.defaultAtt[9]);
    }

    void showMeasureCSV() {
        Enumeration e = this.iMeasureCSV.iMeasureHash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.iMeasureCSV.iMeasureHash.get(key);
            DivisionCaller.println("showMeasureCSV, " + key + CS + value);
        }
    }

    public String getRuleString(String parent) {
        Rule r = (Rule)this.iRulesHash.get(parent);
        if (r == null) {
            return "";
        }
        return r.toString();
    }

    Rule getRule(Nucleus parent) {
        Rule r = (Rule)this.iRulesHash.get(parent.identity);
        if (r == null) {
            String pname = parent.identity;
            String sulston = (String)this.iSulstonHash.get(pname);
            sulston = sulston == null || pname.startsWith("Nuc") ? "a" : sulston.substring(0, 1);
            String sdau1 = String.valueOf(parent.identity) + sulston;
            char c = this.complement(sulston.charAt(0));
            String sdau2 = String.valueOf(parent.identity) + c;
            boolean x = false;
            boolean y = false;
            boolean z = false;
            if (sulston.equals("a")) {
                x = true;
            } else if (sulston.equals("l")) {
                z = true;
            } else {
                y = true;
            }
            sulston = String.valueOf(sulston) + "0";
            r = new Rule(pname, sulston, sdau1, sdau2, (double)x, (double)y, (double)z);
            if (this.iAxis.equals("ADL")) {
                this.iAxisUse = "ARD";
            }
            if (this.iAxis.equals("AVR")) {
                this.iAxisUse = "ALV";
            }
            if (this.iAxis.equals("PDR")) {
                this.iAxisUse = "PLD";
            }
            if (this.iAxis.equals("PVL")) {
                this.iAxisUse = "PRV";
            }
        }
        return r;
    }

    public double getDotProduct(Nucleus parent, Nucleus dau1, Nucleus dau2) {
        Rule r = this.getRule(parent);
        return this.getDotProduct(parent, dau1, dau2, r);
    }

    public double[] getDaCorrected() {
        return this.iDaCorrected;
    }

    double getDotProduct(Nucleus parent, Nucleus dau1, Nucleus dau2, Rule r) {
        double dotCorrected;
        this.iAxisUse = this.iAxis;
        Vector3d template = new Vector3d(r.iX, r.iY, r.iZ);
        double[] daCorrected = this.diffsCorrected(dau1, dau2);
        this.iDaCorrected = daCorrected;
        Vector3d sample = new Vector3d(daCorrected);
        sample.normalize();
        double dot = dotCorrected = template.dot(sample);
        Double Dot = new Double(dot);
        if (Dot.isNaN()) {
            dot = 0.0;
        }
        return dot;
    }

    StringBuffer assignNames(Nucleus parent, Nucleus dau1, Nucleus dau2) {
        String newd1 = "";
        String newd2 = "";
        Rule r = this.getRule(parent);
        double dot = this.getDotProduct(parent, dau1, dau2, r);
        if (dot > 0.0) {
            newd1 = r.iDau1;
            newd2 = r.iDau2;
        } else {
            newd1 = r.iDau2;
            newd2 = r.iDau1;
        }
        dau1.identity = newd1;
        dau2.identity = newd2;
        return null;
    }

    StringBuffer assignNames(Nucleus parent, Nucleus dau1, Nucleus dau2, boolean obsolete) {
        double dotCorrected;
        StringBuffer sb = null;
        this.iDebug = false;
        this.iAxisUse = this.iAxis;
        if (parent.identity.equals("ABalaaapa")) {
            this.iDebug = true;
        }
        String newd1 = "";
        String newd2 = "";
        Rule r = (Rule)this.iRulesHash.get(parent.identity);
        if (r == null) {
            String pname = parent.identity;
            String sulston = (String)this.iSulstonHash.get(pname);
            sulston = sulston == null || pname.startsWith("Nuc") ? "a" : sulston.substring(0, 1);
            String sdau1 = String.valueOf(parent.identity) + sulston;
            char c = this.complement(sulston.charAt(0));
            String sdau2 = String.valueOf(parent.identity) + c;
            boolean x = false;
            boolean y = false;
            boolean z = false;
            if (sulston.equals("a")) {
                x = true;
            } else if (sulston.equals("l")) {
                z = true;
            } else {
                y = true;
            }
            sulston = String.valueOf(sulston) + "0";
            r = new Rule(pname, sulston, sdau1, sdau2, (double)x, (double)y, (double)z);
            if (this.iAxis.equals("ADL")) {
                this.iAxisUse = "ARD";
            }
            if (this.iAxis.equals("AVR")) {
                this.iAxisUse = "ALV";
            }
            if (this.iAxis.equals("PDR")) {
                this.iAxisUse = "PLD";
            }
            if (this.iAxis.equals("PVL")) {
                this.iAxisUse = "PRV";
            }
            this.iAxisUse.equals(this.iAxis);
        }
        Vector3d template = new Vector3d(r.iX, r.iY, r.iZ);
        double[] daCorrected = this.diffsCorrected(dau1, dau2);
        Vector3d sample = new Vector3d(daCorrected);
        sample.normalize();
        double dot = dotCorrected = template.dot(sample);
        if (dot > 0.0) {
            newd1 = r.iDau1;
            newd2 = r.iDau2;
        } else {
            newd1 = r.iDau2;
            newd2 = r.iDau1;
        }
        dau1.identity = newd1;
        dau2.identity = newd2;
        return sb;
    }

    double[] diffs(Nucleus d1, Nucleus d2) {
        double[] da = new double[]{d2.x - d1.x, d2.y - d1.y, d2.z - d1.z};
        da[2] = da[2] * this.iZPixRes;
        this.measurementCorrection(da);
        if (this.iAxisUse.equals("AVR")) {
            da[1] = da[1] * -1.0;
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("PVL")) {
            da[0] = da[0] * -1.0;
            da[1] = da[1] * -1.0;
        } else if (this.iAxisUse.equals("PDR")) {
            da[0] = da[0] * -1.0;
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("ARD")) {
            da[1] = da[1] * -1.0;
        } else if (this.iAxisUse.equals("ALV")) {
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("PLD")) {
            da[0] = da[0] * -1.0;
        } else if (this.iAxisUse.equals("PRV")) {
            da[1] = da[1] * -1.0;
            da[2] = da[2] * -1.0;
        }
        return da;
    }

    double[] diffsStraight(Nucleus d1, Nucleus d2) {
        double[] da = new double[]{d2.x - d1.x, d2.y - d1.y, d2.z - d1.z};
        da[2] = da[2] * this.iZPixRes;
        if (this.iAxisUse.equals("AVR")) {
            da[1] = da[1] * -1.0;
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("PVL")) {
            da[0] = da[0] * -1.0;
            da[1] = da[1] * -1.0;
        } else if (this.iAxisUse.equals("PDR")) {
            da[0] = da[0] * -1.0;
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("ARD")) {
            da[1] = da[1] * -1.0;
        } else if (this.iAxisUse.equals("ALV")) {
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("PLD")) {
            da[0] = da[0] * -1.0;
        } else if (this.iAxisUse.equals("PRV")) {
            da[1] = da[1] * -1.0;
            da[2] = da[2] * -1.0;
        }
        return da;
    }

    double[] diffsCorrected(Nucleus d1, Nucleus d2) {
        double[] da = new double[]{d2.x - d1.x, d2.y - d1.y, d2.z - d1.z};
        da[2] = da[2] * this.iZPixRes;
        this.measurementCorrection(da);
        if (this.iAxisUse.equals("AVR")) {
            da[1] = da[1] * -1.0;
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("PVL")) {
            da[0] = da[0] * -1.0;
            da[1] = da[1] * -1.0;
        } else if (this.iAxisUse.equals("PDR")) {
            da[0] = da[0] * -1.0;
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("ARD")) {
            da[1] = da[1] * -1.0;
        } else if (this.iAxisUse.equals("ALV")) {
            da[2] = da[2] * -1.0;
        } else if (this.iAxisUse.equals("PLD")) {
            da[0] = da[0] * -1.0;
        } else if (this.iAxisUse.equals("PRV")) {
            da[1] = da[1] * -1.0;
            da[2] = da[2] * -1.0;
        }
        return da;
    }

    void measurementCorrection(double[] da) {
        double[] dxy = DivisionCaller.handleRotation(da[0], da[1], this.iAng);
        da[0] = dxy[0];
        da[1] = dxy[1];
        da[0] = da[0] * (this.iEMajor / this.iDMajor);
        da[1] = da[1] * (this.iEMinor / this.iDMinor);
        da[2] = da[2] * (this.iZSlope / this.iDSlope);
    }

    public static double[] handleRotation(double x, double y, double ang) {
        double cosang = Math.cos(ang);
        double sinang = Math.sin(ang);
        double denom = cosang * cosang + sinang * sinang;
        double xpnum = x * cosang + y * sinang;
        double xp = xpnum / denom;
        double yp = (y - xp * sinang) / cosang;
        double[] da = new double[]{xp, yp};
        return da;
    }

    void readNewRules() {
        URL url = AceTree.class.getResource("/org/rhwlab/snight/NewRules.txt");
        InputStream istream = null;
        try {
            istream = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istream));
            br.readLine();
            while (br.ready()) {
                String s = br.readLine();
                if (s.length() == 0) continue;
                String[] sa = s.split(TAB);
                Rule r = new Rule(sa);
                this.iRulesHash.put(sa[0], r);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSulstonRules() {
        Hashtable<String, String> namingHash = new Hashtable<String, String>();
        URL url = AceTree.class.getResource("/org/rhwlab/snight/namesHash.txt");
        InputStream istream = null;
        try {
            istream = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istream));
            while (br.ready()) {
                String s = br.readLine();
                if (s.length() == 0) continue;
                String[] sa = s.split(C);
                namingHash.put(sa[0], sa[1]);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iSulstonHash = namingHash;
    }

    private char complement(char x) {
        switch (x) {
            case 'a': {
                return 'p';
            }
            case 'p': {
                return 'a';
            }
            case 'd': {
                return 'v';
            }
            case 'v': {
                return 'd';
            }
            case 'l': {
                return 'r';
            }
            case 'r': {
                return 'l';
            }
        }
        return 'g';
    }

    public static void test() {
        double x = 20.0;
        double y = 10.0;
        double deg = -15.0;
        double ang = Math.toRadians(deg);
        double cosang = Math.cos(ang);
        double sinang = Math.sin(ang);
        double denom = cosang * cosang + sinang * sinang;
        double xpnum = x * cosang + y * sinang;
        double xp = xpnum / denom;
        double yp = (y - xp * sinang) / cosang;
        DivisionCaller.println("test, " + x + CS + y + CS + DivisionCaller.fmt4(xp) + CS + DivisionCaller.fmt4(yp));
        double check0 = x * x + y * y;
        double check1 = xp * xp + yp * yp;
        DivisionCaller.println("test, " + DivisionCaller.fmt4(check0) + CS + DivisionCaller.fmt4(check1));
    }

    public static void test2() {
        double hyp = 50.0;
        double deg = 30.0;
        double ang = Math.toRadians(deg);
        double y = hyp * Math.sin(ang);
        double x = hyp * Math.cos(ang);
        double[] da = DivisionCaller.handleRotation(x, y, ang);
        double xp = da[0];
        double yp = da[1];
    }

    public static void main(String[] args) {
        DivisionCaller.test2();
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }

    public class Rule {
        double DOTTOL = 0.6;
        String iParent;
        String iRule;
        String iDau1;
        String iDau2;
        public double iX;
        public double iY;
        public double iZ;

        public Rule(String[] sa) {
            this.iParent = sa[0];
            this.iRule = sa[1];
            this.iDau1 = sa[2];
            this.iDau2 = sa[3];
            this.iX = Double.parseDouble(sa[4]);
            this.iY = Double.parseDouble(sa[5]);
            this.iZ = Double.parseDouble(sa[6]);
        }

        public Rule(String parent, String rule, String dau1, String dau2, double x, double y, double z) {
            this.iParent = parent;
            this.iRule = rule;
            this.iDau1 = dau1;
            this.iDau2 = dau2;
            this.iX = x;
            this.iY = y;
            this.iZ = z;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.iParent);
            sb.append(DivisionCaller.C + this.iDau1);
            sb.append(DivisionCaller.C + this.iDau2);
            sb.append(DivisionCaller.C + DivisionCaller.fmt4(this.iX));
            sb.append(DivisionCaller.C + DivisionCaller.fmt4(this.iY));
            sb.append(DivisionCaller.C + DivisionCaller.fmt4(this.iZ));
            return sb.toString();
        }
    }
}

