/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Hashtable;

public class MeasureCSV {
    Hashtable iMeasureHash = new Hashtable();
    String iFilePath;
    int iGoodLinesRead;
    public static String[] att = new String[]{"name", "slope", "intercept", "xc", "yc", "maj", "min", "ang", "zc", "zslope", "time", "zpixres", "axis"};
    public static String[] defaultAtt = new String[]{"xxxx", "0.9", "-27", "360", "255", "585", "390", "0", "14", "10.4", "160", "11.1", "XXX"};
    public static final int SERIES = 0;
    public static final int TSLOPE = 1;
    public static final int TINTERCEPT = 2;
    public static final int EXCENTER = 3;
    public static final int EYCENTER = 4;
    public static final int EMAJOR = 5;
    public static final int EMINOR = 6;
    public static final int EANG = 7;
    public static final int ZCENTER = 8;
    public static final int ZSLOPE = 9;
    public static final int TIME = 10;
    public static final int ZPIXRES = 11;
    public static final int AXIS = 12;
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public MeasureCSV() {
        int i = 0;
        while (i < att.length) {
            this.iMeasureHash.put(att[i], "");
            ++i;
        }
    }

    public MeasureCSV(String filepath) {
        this();
        this.iFilePath = filepath;
        int goodLinesRead = 0;
        boolean namesRead = false;
        String[] names = null;
        try {
            FileInputStream fis = new FileInputStream(filepath);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while (br.ready()) {
                String s = br.readLine();
                if (s.length() >= 2) {
                    ++goodLinesRead;
                    if (!namesRead) {
                        names = s.split(C);
                        namesRead = true;
                        continue;
                    }
                    String[] values = s.split(C);
                    int i = 0;
                    while (i < values.length) {
                        String value = (String)this.iMeasureHash.get(names[i]);
                        this.iMeasureHash.put(names[i], values[i]);
                        ++i;
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            MeasureCSV.println("MeasureCSV file exception");
        }
        this.iGoodLinesRead = goodLinesRead;
    }

    public int getGoodLinesRead() {
        return this.iGoodLinesRead;
    }

    public int isMeasured() {
        int i = 0;
        while (i < att.length - 2) {
            String value = (String)this.iMeasureHash.get(att[i]);
            if (value.length() == 0) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public void put(String item, String value) {
        this.iMeasureHash.put(item, value);
    }

    public String get(String item) {
        return (String)this.iMeasureHash.get(item);
    }

    public String toString() {
        String r = this.get("name");
        int i = 1;
        while (i < att.length) {
            r = String.valueOf(r) + C + this.get(att[i]);
            ++i;
        }
        return r;
    }

    public void writeCSV() {
        this.writeCSV(this.iFilePath);
    }

    public void writeCSV(String filePath) {
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            pw = new PrintWriter(fos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
        StringBuffer sb = new StringBuffer(att[0]);
        int i = 1;
        while (i < att.length) {
            sb.append(C + att[i]);
            ++i;
        }
        pw.println(sb.toString());
        sb = new StringBuffer((String)this.iMeasureHash.get(att[0]));
        i = 1;
        while (i < att.length) {
            sb.append(C + (String)this.iMeasureHash.get(att[i]));
            ++i;
        }
        pw.println(sb.toString());
        pw.close();
    }

    public void checkHash() {
        int i = 0;
        while (i < att.length) {
            String value = (String)this.iMeasureHash.get(att[i]);
            MeasureCSV.println("checkHash, " + att[i] + CS + value);
            ++i;
        }
    }

    public static void main(String[] args) {
        MeasureCSV.println("MeasureCSV.main, ");
        String filepath = "/nfs/waterston1/annots/bao/081505/dats/081505AuxInfo.csv";
        filepath = "/nfs/waterston1/annots/murray/20060706_pha4_b2/dats/20060706_pha4_b2AuxInfo.csv";
        filepath = "/net/waterston/vol1/annots/murray/010306_pha4red/dats/010306_pha4redAuxInfo.csv";
        MeasureCSV mcsv = new MeasureCSV(filepath);
        mcsv.checkHash();
        int g = mcsv.getGoodLinesRead();
        if (g != 2) {
            MeasureCSV.println("MeasureCSV.main, " + g + CS + "questionable AuxInfo");
        }
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

