/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.rhwlab.help.AceTreeHelp;
import org.rhwlab.snight.ChannelCopy;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.ZipNuclei;
import org.rhwlab.utils.EUtils;

public class NucZipper {
    private static final String CS = ", ";
    private static final String C = ",";

    public NucZipper(File file, NucleiMgr nucleiMgr) {
        File targetFile = file;
        String parent = file.getParent();
        File tempFile = new File(String.valueOf(parent) + "/temp.zip");
        String filePath = tempFile.getPath();
        while (tempFile.exists()) {
            filePath = this.addExtNumber(filePath);
            tempFile = new File(filePath);
        }
        String nucDir = nucleiMgr.getConfig().iZipNucDir;
        try {
            int lastEmptyIndex;
            FileOutputStream fos = new FileOutputStream(tempFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Vector nuclei = nucleiMgr.getNucleiRecord();
            int i = lastEmptyIndex = nuclei.size() - 1;
            while (i >= 0) {
                Vector currentVec = (Vector)nuclei.elementAt(i);
                if (!currentVec.isEmpty()) {
                    lastEmptyIndex = i + 1;
                    break;
                }
                --i;
            }
            System.out.println("Last non-empty index in nuclei_record: " + lastEmptyIndex);
            i = 0;
            while (i < lastEmptyIndex) {
                String ename = String.valueOf(nucDir) + "t" + EUtils.makePaddedInt(i + 1) + "-nuclei";
                zos.putNextEntry(new ZipEntry(ename));
                int j = 0;
                while (j < ((Vector)nuclei.elementAt(i)).size()) {
                    Nucleus n = (Nucleus)((Vector)nuclei.elementAt(i)).elementAt(j);
                    String s = this.formatNucleus(j, n);
                    byte[] b = s.getBytes();
                    zos.write(b, 0, b.length);
                    ++j;
                }
                zos.closeEntry();
                ++i;
            }
            this.addParameters(zos, nucleiMgr);
            zos.close();
            ChannelCopy.transferCopy(tempFile, targetFile);
            try {
                tempFile.delete();
            }
            catch (Exception e) {
                System.out.println("Failed to delete temp file.");
            }
        }
        catch (IOException ioe) {
            System.out.println("NucZipper exception: " + ioe);
            new AceTreeHelp("/org/rhwlab/help/messages/PermissionError.html", 200, 200);
        }
    }

    private String addExtNumber(String path) {
        int right;
        int left = path.indexOf("(");
        if (left < (right = path.indexOf(").zip"))) {
            String between = path.substring(left + 1, right);
            try {
                int ext = Integer.parseInt(between);
                path = String.valueOf(path.substring(0, left)) + "(" + ++ext + ").zip";
            }
            catch (Exception e) {
                path = String.valueOf(path.substring(0, path.length() - 4)) + "(1).zip";
                return path;
            }
        } else {
            path = String.valueOf(path.substring(0, path.length() - 4)) + "(1).zip";
        }
        return path;
    }

    private void addParameters(ZipOutputStream zos, NucleiMgr nucleiMgr) throws IOException {
        ZipNuclei zn = nucleiMgr.getZipNuclei();
        String ename = nucleiMgr.getParameterEntry();
        zos.putNextEntry(new ZipEntry(ename));
        Vector parameterFileInfo = nucleiMgr.getParameterFileInfo();
        String s = null;
        if (parameterFileInfo != null) {
            int i = 0;
            while (i < parameterFileInfo.size()) {
                s = (String)parameterFileInfo.elementAt(i);
                s = String.valueOf(s) + "\n";
                byte[] b = s.getBytes();
                zos.write(b, 0, b.length);
                ++i;
            }
        }
        zos.closeEntry();
    }

    private String formatNucleus(int j, Nucleus n) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(String.valueOf(j + 1)) + CS);
        int status = 0;
        if (n.status > 0) {
            status = 1;
        }
        sb.append(String.valueOf(String.valueOf(status)) + CS);
        sb.append(String.valueOf(String.valueOf(n.predecessor)) + CS);
        sb.append(String.valueOf(String.valueOf(n.successor1)) + CS);
        sb.append(String.valueOf(String.valueOf(n.successor2)) + CS);
        sb.append(String.valueOf(String.valueOf(n.x)) + CS);
        sb.append(String.valueOf(String.valueOf(n.y)) + CS);
        sb.append(String.valueOf(String.valueOf(n.z)) + CS);
        sb.append(String.valueOf(String.valueOf(n.size)) + CS);
        sb.append(String.valueOf(n.identity) + CS);
        sb.append(String.valueOf(String.valueOf(n.weight)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rweight)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rsum)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rcount)) + CS);
        sb.append(String.valueOf(n.assignedID) + CS);
        sb.append(String.valueOf(String.valueOf(n.rwraw)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rwcorr1)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rwcorr2)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rwcorr3)) + CS);
        sb.append(String.valueOf(String.valueOf(n.rwcorr4)) + CS);
        sb.append("\n");
        return sb.toString();
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }
}

