/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.dbaccess.DBAccess;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.nucedit.EditLog;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.Identity3;
import org.rhwlab.snight.MeasureCSV;
import org.rhwlab.snight.Movie;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.Parameters;
import org.rhwlab.snight.ZipNuclei;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;
import org.rhwlab.utils.Log;

public class NucleiMgr {
    ZipNuclei iZipNuclei;
    File iFile;
    FileOutputStream iFOS;
    PrintWriter iPWriter;
    Vector nuclei_record;
    Vector nuclei_record_backup;
    Parameters Parametersx;
    String iParameterEntry;
    int iStartingIndex;
    int iEndingIndex;
    int iImageWidth;
    int iImageHeight;
    int iIndexOffset;
    int iNumNucleiFiles;
    String[] parameterFileData;
    boolean iFakeNuclei;
    boolean iDebug;
    Identity3 iIdentity;
    AncesTree iAncesTree;
    Config iConfig;
    MeasureCSV iMeasureCSV;
    Parameters iParameters;
    Movie iMovie;
    EditLog iEditLog;
    Log iDDLog;
    Log iDLog;
    boolean iEditLogInitialized;
    double iZPixRes;
    int iPlaneEnd;
    int iPlaneStart;
    int iLastNucleiFile;
    public boolean iGoodNucleiMgr;
    public int iUseStack;
    PrintWriter iPrintWriter;
    int iStartTime;
    static String p2 = "t";
    static String p3 = "-nuclei";
    private static final int[] XX = new int[]{6, 5, 5, 6, 14, 4, 8, 4, 5, 6, 5, 6, 5, 5, 5};
    public static final int LAST = 10000;
    public static final String PARAMETERS = "parameters";
    public static final String NL = "\n";
    public static final String CS = ", ";

    public NucleiMgr() {
    }

    public NucleiMgr(String configFileName) {
        this.iUseStack = 0;
        this.iEditLog = new EditLog("EditLog");
        int k2 = configFileName.lastIndexOf(".");
        String measureCSVpath = String.valueOf(configFileName.substring(0, k2)) + "AuxInfo.csv";
        System.out.println("NucleiMgr measureCSVpath: " + measureCSVpath);
        this.iMeasureCSV = new MeasureCSV(measureCSVpath);
        this.println(this.iMeasureCSV.toString());
        String s2 = configFileName.substring(k2 + 1);
        this.iConfig = s2.equals("xml") ? Config.createConfigFromXMLFile(configFileName) : new Config(configFileName);
        this.iStartingIndex = this.iConfig.iStartingIndex;
        this.iEndingIndex = this.iConfig.iEndingIndex;
        String zipPath = this.iConfig.iZipFileName;
        String nucleiDir = String.valueOf(this.iConfig.iZipNucDir) + "/";
        this.iUseStack = this.iConfig.iUseStack;
        this.iStartTime = this.iConfig.getStartTime();
        int k = this.iConfig.iTifPrefix.lastIndexOf("/");
        String s = this.iConfig.iTifPrefix.substring(k + 1);
        this.setParameterEntry(s);
        this.iLastNucleiFile = 0;
        int m = zipPath.lastIndexOf("NULL");
        m = zipPath.length() - m;
        if (m == 4) {
            System.out.println(" Direct opening of images is no longer supported");
            this.iGoodNucleiMgr = false;
        } else {
            this.iParameters = this.dummyParameters();
            this.iZipNuclei = new ZipNuclei(zipPath);
            if (this.iZipNuclei.iZipFile != null) {
                long timeStart = System.nanoTime();
                this.readNuclei();
                long timeEnd = System.nanoTime();
                double timeDiff = (double)(timeEnd - timeStart) / 1000000.0;
                System.out.println("Time to read nuclei: " + timeDiff + " ms.");
                this.getScopeParameters();
                this.findImageParameters();
                this.iGoodNucleiMgr = true;
            }
        }
        this.computeRWeights();
        System.gc();
    }

    public NucleiMgr(Config config, PrintWriter printWriter) {
        this(config);
        this.iPrintWriter = printWriter;
    }

    public NucleiMgr(Config config) {
        this.iEditLog = new EditLog("EditLog");
        String configFileName = config.iConfigFileName;
        int k2 = configFileName.lastIndexOf(".");
        String measureCSVpath = String.valueOf(configFileName.substring(0, k2)) + "AuxInfo.csv";
        this.println("NucleiMgr, " + measureCSVpath + CS + DBAccess.cDBLocation);
        this.iMeasureCSV = new MeasureCSV(measureCSVpath);
        this.iConfig = config;
        this.iStartingIndex = this.iConfig.iStartingIndex;
        this.iEndingIndex = this.iConfig.iEndingIndex;
        String zipPath = this.iConfig.iZipFileName;
        String nucleiDir = String.valueOf(this.iConfig.iZipNucDir) + "/";
        this.iUseStack = this.iConfig.iUseStack;
        int k = this.iConfig.iTifPrefix.lastIndexOf("/");
        String s = this.iConfig.iTifPrefix.substring(k + 1);
        this.setParameterEntry(s);
        this.iLastNucleiFile = 0;
        int m = zipPath.lastIndexOf("NULL");
        m = zipPath.length() - m;
        if (m == 4) {
            this.iGoodNucleiMgr = false;
        } else {
            this.iParameters = this.dummyParameters();
            this.iZipNuclei = new ZipNuclei(zipPath);
            if (this.iZipNuclei.iZipFile != null) {
                long timeStart = System.nanoTime();
                this.readNuclei();
                long timeEnd = System.nanoTime();
                double timeDiff = (double)(timeEnd - timeStart) / 1000000.0;
                System.out.println("Time to read nuclei in constructor(Config c): " + timeDiff + " ms.");
                this.getScopeParameters();
                this.findImageParameters();
                this.iGoodNucleiMgr = true;
            }
        }
        this.computeRWeights();
        System.gc();
    }

    public int getStartTime() {
        return this.iStartTime;
    }

    public int getStartingIndex() {
        return this.iStartingIndex;
    }

    public void computeRWeights() {
        int k = this.getWeightMethodIndex();
        try {
            int i = this.iStartingIndex;
            while (i <= this.iEndingIndex) {
                Vector v = (Vector)this.nuclei_record.get(i - 1);
                int j = 0;
                while (j < v.size()) {
                    Nucleus n = (Nucleus)v.get(j);
                    if (n.status >= 0) {
                        this.computeRWeight(n, k);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            return;
        }
    }

    public void computeRWeight(Nucleus n, int k) {
        if (n.rwraw <= 0) {
            return;
        }
        n.rweight = n.rwraw;
        switch (k) {
            case 1: {
                n.rweight -= n.rwcorr1;
                break;
            }
            case 2: {
                n.rweight -= n.rwcorr2;
                break;
            }
            case 3: {
                n.rweight -= n.rwcorr3;
                break;
            }
            case 4: {
                n.rweight -= n.rwcorr4;
            }
        }
    }

    private int getWeightMethodIndex() {
        String method = this.iConfig.iExprCorr;
        if (method.equals("global")) {
            return 1;
        }
        if (method.equals("local")) {
            return 2;
        }
        if (method.equals("blot")) {
            return 3;
        }
        if (method.equals("cross")) {
            return 4;
        }
        return 0;
    }

    private void findImageParameters() {
        String zipTifFilePath = ImageWindow.cZipTifFilePath;
        String tifPrefix = ImageWindow.cTifPrefix;
        String tifPrefixR = ImageWindow.cTifPrefixR;
        int useZip = ImageWindow.cUseZip;
        int width = ImageWindow.cImageHeight;
        int height = ImageWindow.cImageWidth;
        this.sendStaticParametersToImageWindow();
        int plane = this.iMovie.plane_start;
        int time = this.iStartTime;
        String imageName = this.makeImageName(time, plane);
        ImageWindow.makeImage(String.valueOf(this.getConfig().iTifPrefix) + imageName);
        this.iImageWidth = ImageWindow.cImageWidth;
        this.iImageHeight = ImageWindow.cImageHeight;
        ImageWindow.cZipTifFilePath = zipTifFilePath;
        ImageWindow.cTifPrefix = tifPrefix;
        ImageWindow.cTifPrefixR = tifPrefixR;
        ImageWindow.cUseZip = useZip;
        ImageWindow.cImageWidth = width;
        ImageWindow.cImageHeight = height;
        ImageWindow.imagewindowUseStack = this.iUseStack;
    }

    private String makeImageName(int time, int plane) {
        StringBuffer name = new StringBuffer("t");
        name.append(EUtils.makePaddedInt(time));
        name.append("-p");
        String p = EUtils.makePaddedInt(plane, 2);
        name.append(p);
        switch (this.getConfig().iUseZip) {
            case 0: 
            case 1: 
            case 3: {
                name.append(".tif");
                break;
            }
            default: {
                name.append(".zip");
            }
        }
        System.out.println("NucleiMgr made name: " + name.toString());
        return name.toString();
    }

    public Parameters dummyParameters() {
        this.iParameters = new Parameters();
        this.iMovie = this.iParameters.getMovie();
        this.iMovie.xy_res = this.iConfig.iXy_res;
        this.iMovie.z_res = this.iConfig.iZ_res;
        this.iParameters.polar_size = this.iConfig.iPolar_size;
        this.iMovie.plane_start = this.iConfig.iPlaneStart;
        this.iMovie.plane_end = this.iConfig.iPlaneEnd;
        this.iUseStack = this.iConfig.iUseStack;
        return this.iParameters;
    }

    private void createDummies(Parameters p) {
        this.iMovie = p.getMovie();
        this.iMovie.xy_res = this.iConfig.iXy_res;
        this.iMovie.z_res = this.iConfig.iZ_res;
        p.polar_size = this.iConfig.iPolar_size;
        this.iMovie.plane_start = this.iConfig.iPlaneStart;
        this.iMovie.plane_end = this.iConfig.iPlaneEnd;
        this.iUseStack = this.iConfig.iUseStack;
    }

    public Parameters readParameterInfo(String zipPath) {
        this.iZipNuclei = new ZipNuclei(zipPath);
        this.iParameters = this.iZipNuclei.iZipFile != null ? this.readParameterInfo(this.iZipNuclei, this.iParameterEntry) : null;
        this.iParameters = new Parameters();
        this.iMovie = this.iParameters.getMovie();
        this.iMovie.xy_res = 0.09f;
        this.iMovie.z_res = 1.0f;
        this.iParameters.polar_size = 45;
        return this.iParameters;
    }

    private Parameters readParameterInfo(ZipNuclei zn, String testParams) {
        this.iParameters = new Parameters();
        this.iMovie = this.iParameters.getMovie();
        this.iMovie.tp_number = this.iMovie.time_end - this.iMovie.time_start + 1;
        this.println("readParameters: iMovie.tp_number: " + this.iMovie.tp_number);
        this.iNumNucleiFiles = this.iMovie.time_end - this.iMovie.time_start + 1;
        System.out.println("SN_time_start: " + this.iMovie.time_start);
        System.out.println("SN_time_end: " + this.iMovie.time_end);
        System.out.println("SN_plane_start: " + this.iMovie.plane_start);
        System.out.println("SN_plane_end: " + this.iMovie.plane_end);
        return this.iParameters;
    }

    public void readEditLog(Log editLog) {
        ZipEntry ze = this.iZipNuclei.getZipEntry("parameters/EditLog.txt");
        if (ze == null) {
            System.out.println("no edit log found");
            this.iEditLog.append("\nSTART: " + new GregorianCalendar().getTime().toString());
            this.iEditLog.append("from config file: " + this.iConfig.iConfigFileName);
            return;
        }
        String s = null;
        if (ze != null) {
            while ((s = this.iZipNuclei.readLine(ze)) != null) {
                this.iEditLog.append(s);
            }
        }
    }

    public void readNuclei() {
        int last = this.readNuclei(this.iZipNuclei);
        if (last < this.iEndingIndex) {
            this.iConfig.iEndingIndex = this.iEndingIndex = last;
        }
        if (last < this.iConfig.iEndingIndex) {
            this.iConfig.iEndingIndex = last;
        }
        System.out.println("last, iEndingIndex: " + last + CS + this.iEndingIndex + CS + this.iConfig.iEndingIndex + CS + this.iMovie);
        this.iUseStack = this.iConfig.iUseStack;
    }

    private int readNuclei(ZipNuclei zn) {
        int newSize;
        System.out.println("readNuclei:1 " + this.iMovie.time_end + CS + this.iMovie.time_start);
        this.fakeNuclei();
        this.iFakeNuclei = false;
        Nucleus n = null;
        boolean debugCount = false;
        System.out.println("readNuclei:2 " + this.iMovie.time_end + CS + this.iMovie.time_start);
        Enumeration<? extends ZipEntry> e = zn.iZipFile.entries();
        while (e.hasMoreElements()) {
            int index;
            ZipEntry ze = e.nextElement();
            Vector<Nucleus> v = new Vector<Nucleus>();
            String[] saa = zn.parseZipEntry(ze);
            if (saa.length < 2 || !saa[0].equals("nuclei") || (index = zn.parseZipEntryName(saa[1]) - 1) < 0) continue;
            String s = zn.readLine(ze);
            if (s == null) {
                if (this.nuclei_record.size() <= index) continue;
                this.nuclei_record.setElementAt(v, index);
                if (index <= this.iLastNucleiFile) continue;
                this.iLastNucleiFile = index;
                continue;
            }
            boolean newFormat = true;
            if (s.indexOf(44) == -1) {
                newFormat = false;
            }
            int j = 1;
            while (s != null && s.length() > 10) {
                try {
                    String[] sa = newFormat ? this.getTokens(s, 0) : this.getTokens(s);
                    if (sa[0] != null && sa[0].length() > 0 && Integer.parseInt(sa[0]) != j++) break;
                    n = newFormat ? new Nucleus(sa) : new Nucleus(sa, !newFormat);
                    v.add(n);
                    s = zn.readLine(ze);
                }
                catch (Exception ee) {
                    System.out.println("readNuclei exception: " + ee);
                    System.out.println(s);
                    System.out.println("time=" + index + ", j = " + j);
                    zn.closeEntry();
                    ee.printStackTrace();
                    System.exit(1);
                    break;
                }
            }
            if (this.nuclei_record.size() > index) {
                this.nuclei_record.setElementAt(v, index);
                if (index > this.iLastNucleiFile) {
                    this.iLastNucleiFile = index;
                }
            }
            zn.closeEntry();
        }
        this.println("readNuclei: iEndingIndex=" + this.iEndingIndex + CS + this.iLastNucleiFile + CS + this.nuclei_record.size());
        if (this.iEndingIndex == 1) {
            this.iConfig.iEndingIndex = this.iEndingIndex = this.iLastNucleiFile + 1;
            int i = 9999;
            while (i > this.iLastNucleiFile) {
                this.nuclei_record.remove(i);
                --i;
            }
        }
        if ((newSize = this.iLastNucleiFile + 1) < this.iEndingIndex) {
            newSize = this.iEndingIndex + 1;
        }
        this.nuclei_record.setSize(newSize);
        this.println("readNuclei: at end, nuclei_record.size: " + this.nuclei_record.size());
        System.out.println("readNuclei:3 " + this.iMovie.time_end + CS + this.iMovie.time_start);
        return this.nuclei_record.size();
    }

    public Vector getElementAt(int i) {
        if (this.nuclei_record.size() - 1 < i) {
            int oldSize = this.nuclei_record.size();
            this.nuclei_record.setSize(i + 30);
            int j = oldSize;
            while (j < this.nuclei_record.size()) {
                this.nuclei_record.setElementAt(new Vector(), j);
                ++j;
            }
        }
        return (Vector)this.nuclei_record.elementAt(i);
    }

    public void sendStaticParametersToImageWindow() {
        ImageWindow.setStaticParameters(this.iConfig.iZipTifFilePath, this.iConfig.iTifPrefix, this.iConfig.iUseZip, this.iConfig.iSplitChannelImage);
    }

    public int getiEndingIndex() {
        return this.iEndingIndex;
    }

    public Identity3 getIdentity() {
        return this.iIdentity;
    }

    public Movie getMovie() {
        return this.iMovie;
    }

    public Parameters getParameters() {
        return this.iParameters;
    }

    public Config getConfig() {
        return this.iConfig;
    }

    public void setConfig(Config config) {
        this.iConfig = config;
    }

    public MeasureCSV getMeasureCSV() {
        return this.iMeasureCSV;
    }

    public EditLog getEditLog() {
        return this.iEditLog;
    }

    public int getiLastNucleiFile() {
        return this.iLastNucleiFile;
    }

    public double getZPixRes() {
        return this.iZPixRes;
    }

    public String getIndex(String name, int time) {
        Vector nuclei;
        int k = 0;
        if (this.nuclei_record.size() < time) {
            this.nuclei_record.setSize(time);
            int i = this.getiLastNucleiFile() + 1;
            while (i < time) {
                this.nuclei_record.setElementAt(new Vector(), i);
                ++i;
            }
            nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        } else {
            nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        }
        Nucleus n = null;
        int j = 0;
        while (j < nuclei.size()) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.identity.equals(name)) {
                k = n.index;
                break;
            }
            ++j;
        }
        String s = "(" + k + ")";
        return s;
    }

    public Nucleus findClosestNucleusXYZ(int mx, int my, float mz, int time) {
        Vector nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        Nucleus candidate = null;
        double d = 100000.0;
        mz = (float)((double)mz * this.iZPixRes);
        int j = 0;
        while (j < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.elementAt(j);
            if (n.status != -1) {
                boolean g;
                double x = n.x;
                double y = n.y;
                double z = (double)n.z * this.iZPixRes;
                double r = (double)n.size / 2.0;
                boolean bl = g = Math.abs(x - (double)mx) < r;
                if (g) {
                    boolean bl2 = g = Math.abs(y - (double)my) < r;
                    if (g) {
                        double xyz;
                        boolean bl3 = g = Math.abs(z - (double)mz) < r;
                        if (g && (xyz = Math.abs(x - (double)mx) + Math.abs(y - (double)my) + Math.abs(z - (double)mz)) < d) {
                            d = xyz;
                            candidate = n;
                        }
                    }
                }
            }
            ++j;
        }
        return candidate;
    }

    public Nucleus findClosestNucleus(int mx, int my, int time) {
        Vector nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        Nucleus candidate = null;
        double d = 100000.0;
        int j = 0;
        while (j < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.elementAt(j);
            if (n.status != -1) {
                boolean g;
                double x = n.x;
                double y = n.y;
                double r = (double)n.size / 2.0;
                double xy = Math.abs(x - (double)mx) + Math.abs(y - (double)my);
                boolean bl = g = Math.abs(x - (double)mx) < r;
                if (g) {
                    boolean bl2 = g = Math.abs(y - (double)my) < r;
                    if (g && xy < d) {
                        d = xy;
                        candidate = n;
                    }
                }
            }
            ++j;
        }
        return candidate;
    }

    public Nucleus findClosestNucleus(int mx, int my, int mz, int time) {
        if (time < 1) {
            time = 1;
        }
        Vector nuclei = null;
        try {
            nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        }
        catch (Exception e) {
            return null;
        }
        Nucleus candidate = null;
        double d = 100000.0;
        mz = (int)((double)mz * this.iZPixRes);
        int j = 0;
        while (j < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.elementAt(j);
            if (n.status != -1) {
                boolean g;
                double x = n.x;
                double y = n.y;
                double z = (int)((double)n.z * this.iZPixRes);
                double r = (double)n.size / 2.0;
                double xy = Math.abs(x - (double)mx) + Math.abs(y - (double)my) + Math.abs(z - (double)mz);
                boolean bl = g = Math.abs(x - (double)mx) < r;
                if (g) {
                    boolean bl2 = g = Math.abs(y - (double)my) < r;
                    if (g) {
                        boolean bl3 = g = Math.abs(z - (double)mz) < r;
                        if (g && xy < d) {
                            d = xy;
                            candidate = n;
                        }
                    }
                }
            }
            ++j;
        }
        return candidate;
    }

    public Nucleus getCurrentCellData(String cellName, int time) {
        Vector nucData = (Vector)this.nuclei_record.elementAt(time - 1);
        return NucUtils.getCurrentCellData(nucData, cellName);
    }

    public boolean isValidCell(String name, int time) {
        boolean rtn = false;
        Nucleus n = this.getCurrentCellData(name, time);
        this.iDLog.append("isValidCell " + name + CS + time);
        this.iDLog.append("isValidCell " + n);
        return n != null;
    }

    public Vector getNuclei(int time) {
        return (Vector)this.nuclei_record.elementAt(time);
    }

    public Nucleus getNucleusFromHashkey(String hashKey, int time) {
        Nucleus r = null;
        boolean found = false;
        Vector nucData = (Vector)this.nuclei_record.elementAt(time - 1);
        int j = 0;
        while (j < nucData.size()) {
            Nucleus n = (Nucleus)nucData.elementAt(j);
            if (n.status >= 0 && n.hashKey.equals(hashKey)) {
                found = true;
                r = n;
                break;
            }
            ++j;
        }
        return r;
    }

    public double nucDiameter(Nucleus n, double imgPlane) {
        if (n == null) {
            return -1.0;
        }
        double r = -0.5;
        double cellPlane = n.z;
        double R = (double)n.size / 2.0;
        double y = (cellPlane - imgPlane) * this.iZPixRes / R;
        double r2 = 1.0 - y * y;
        if (r2 >= 0.0) {
            r = Math.sqrt(r2) * R;
        }
        return 2.0 * r;
    }

    public boolean hasCircle(Nucleus n, double imgPlane) {
        return this.nucDiameter(n, imgPlane) > 0.0;
    }

    public String getOrientation() {
        String orientation = "A";
        String late = "A";
        if (this.iParameters.ap < 0) {
            orientation = "P";
        }
        orientation = this.iParameters.dv > 0 ? String.valueOf(orientation) + "D" : String.valueOf(orientation) + "V";
        orientation = this.iParameters.lr > 0 ? String.valueOf(orientation) + "L" : String.valueOf(orientation) + "R";
        if (orientation.equals("ADL")) {
            late = "ARD";
        } else if (orientation.equals("AVR")) {
            late = "ALV";
        } else if (orientation.equals("PDR")) {
            late = "PLD";
        } else if (orientation.equals("PVL")) {
            late = "PRV";
        }
        return orientation;
    }

    public String getConfigFileName() {
        return this.iConfig.iConfigFileName;
    }

    private void getScopeParameters() {
        if (!this.iFakeNuclei) {
            this.iMovie = this.iParameters.getMovie();
            this.iPlaneEnd = this.iMovie.plane_end;
            this.iZPixRes = this.iMovie.z_res / this.iMovie.xy_res * this.iParameters.z_res_fudge;
        } else {
            this.iPlaneEnd = this.iConfig.iPlaneEnd;
            this.iPlaneStart = this.iConfig.iPlaneStart;
            this.iZPixRes = this.iConfig.iZ_res / this.iConfig.iXy_res;
        }
        NucUtils.setZPixRes(this.iZPixRes);
    }

    public void setParameterEntry(String parameterLocation) {
        this.iParameterEntry = "parameters/" + parameterLocation + PARAMETERS;
    }

    public String getParameterEntry() {
        return this.iParameterEntry;
    }

    public Vector getParameterFileInfo() {
        Vector v = this.iParameters.getParameterFileInfo();
        return v;
    }

    public void fakeNuclei() {
        this.iFakeNuclei = true;
        this.nuclei_record = new Vector();
        Object n = null;
        int last = 10000;
        int i = 0;
        while (i < last) {
            this.nuclei_record.add(new Vector());
            ++i;
        }
    }

    private void addFakeNuclei(Vector nuclei_record, int iEndingIndex) {
        Nucleus n = null;
        int i = 0;
        while (i < iEndingIndex) {
            nuclei_record.add(new Vector());
            n = new Nucleus(true);
            if (i == 0) {
                n.predecessor = -1;
            }
            ((Vector)nuclei_record.elementAt(i)).add(n);
            ++i;
        }
    }

    public boolean isFake() {
        return this.iFakeNuclei;
    }

    void reviewNuclei() {
        Vector nr = this.nuclei_record;
        int i = 194;
        while (i < 195) {
            Vector nuclei = (Vector)nr.get(i);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus n = (Nucleus)nuclei.get(j);
                this.println("reviewNuclei, " + i + CS + j + CS + n);
                ++j;
            }
            ++i;
        }
    }

    public void processNuclei(boolean doIdentity, int namingMethod) {
        this.setAllSuccessors();
        if (this.iIdentity == null) {
            this.iIdentity = new Identity3(this);
        }
        this.iIdentity.setNamingMethod(this.getConfig().iNamingMethod);
        this.iIdentity.setPrintWriter(this.iPrintWriter);
        this.println("about to create names");
        if (doIdentity) {
            System.out.println("doing identity");
            this.iIdentity.identityAssignment();
        }
        this.println("about to create tree data structure");
        this.println("reviewNuclei, 3");
        int newstart = this.iStartingIndex;
        if (this.iStartingIndex < this.iStartTime) {
            newstart = this.iStartTime;
        }
        this.iAncesTree = new AncesTree(null, this, newstart, this.iEndingIndex);
        Cell PP = (Cell)this.iAncesTree.getCellsByName().get("P");
        int kk = PP.getChildCount();
    }

    public Hashtable getCellsByName() {
        return this.iAncesTree.getCellsByName();
    }

    public AncesTree getAncesTree() {
        return this.iAncesTree;
    }

    public void clearAllHashkeys() {
        Vector v = null;
        int i = 0;
        while (i < this.nuclei_record.size()) {
            v = (Vector)this.nuclei_record.elementAt(i);
            int j = 0;
            while (j < v.size()) {
                ((Nucleus)v.elementAt((int)j)).hashKey = null;
                ++j;
            }
            ++i;
        }
    }

    private String[] getTokens(String s, int x) {
        String[] sa = new String[30];
        StringTokenizer st = new StringTokenizer(s, ",");
        int k = 0;
        while (st.hasMoreTokens()) {
            sa[k++] = st.nextToken().trim();
        }
        return sa;
    }

    public Vector getNucleiRecord() {
        return this.nuclei_record;
    }

    public void makeBackupNucleiRecord() {
        System.out.println("Refusing to make backup, waste of memory");
    }

    public void restoreNucleiRecord() {
        System.out.println("cannot restore no backup made");
    }

    public void setEndingIndex(int endTime) {
        this.iEndingIndex = endTime;
    }

    public int getEndingIndex() {
        return this.iEndingIndex;
    }

    public int getPlaneEnd() {
        return this.iPlaneEnd;
    }

    public int getPlaneStart() {
        return this.iPlaneStart;
    }

    public int getImageWidth() {
        return this.iImageWidth;
    }

    public int getImageHeight() {
        return this.iImageHeight;
    }

    public ZipNuclei getZipNuclei() {
        return this.iZipNuclei;
    }

    public void setAllSuccessors() {
        System.out.println("setAllSuccessors: " + this.iStartingIndex + CS + this.iEndingIndex + CS + this.nuclei_record.size());
        int i = this.iStartingIndex - 1;
        while (i < this.nuclei_record.size()) {
            int r = this.setSuccessors(i);
            if (r != 0) break;
            ++i;
        }
    }

    public int setSuccessors(int i) {
        Vector next;
        if (this.iConfig.iNamingMethod == 2) {
            return 0;
        }
        Vector now = (Vector)this.nuclei_record.elementAt(i);
        Nucleus n = null;
        int m1 = -1;
        int j = 0;
        while (j < now.size()) {
            n = (Nucleus)now.elementAt(j);
            n.successor1 = m1;
            n.successor2 = m1;
            ++j;
        }
        if (i == this.iEndingIndex - 1) {
            return 1;
        }
        try {
            next = (Vector)this.nuclei_record.elementAt(i + 1);
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            return 1;
        }
        int j2 = 0;
        while (j2 < next.size()) {
            block13: {
                int pred;
                n = (Nucleus)next.elementAt(j2);
                if (n.status != -1 && (pred = n.predecessor) != -1) {
                    Nucleus p = null;
                    try {
                        p = (Nucleus)now.elementAt(pred - 1);
                    }
                    catch (Exception e) {
                        break block13;
                    }
                    if (p.successor1 == m1) {
                        p.successor1 = j2 + 1;
                    } else if (p.successor2 == m1) {
                        p.successor2 = j2 + 1;
                    } else {
                        System.out.println("error: MORE THAN 2 SUCCESSORS");
                    }
                }
            }
            ++j2;
        }
        return 0;
    }

    private void open(String s) {
        try {
            this.iFile = new File(s);
            this.iFOS = new FileOutputStream(this.iFile);
            this.iPWriter = new PrintWriter(this.iFOS);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void close() {
        try {
            this.iPWriter.close();
            this.iFOS.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void write(String s) {
        this.iPWriter.println(s);
    }

    private void printNuclei() {
        System.out.println("Saving printNuclei loop end: " + this.iMovie.tp_number);
        int i = 0;
        while (i < this.iMovie.tp_number) {
            String name = "t" + EUtils.makePaddedInt(i + 1) + "-nuclei";
            this.open(name);
            Vector nuclei = (Vector)this.nuclei_record.elementAt(i);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus nucleij = (Nucleus)nuclei.elementAt(j);
                this.write(nucleij.toString());
                ++j;
            }
            this.close();
            ++i;
        }
    }

    private String[] getTokens(String s) {
        String[] sa = new String[15];
        int k = 0;
        int j = 0;
        int max = s.length();
        int i = 0;
        while (i < 15) {
            if ((k += XX[i]) > max) break;
            sa[i] = s.substring(j, k).trim();
            j = k;
            ++i;
        }
        return sa;
    }

    public static void main(String[] args) {
        System.out.println("NucleiMgr test main entered");
        NucleiMgr test = null;
        String testZip = "t220.zip";
        ZipNuclei zn = new ZipNuclei(testZip);
        String testParams = "parameters/t220-parameters";
        super.readParameterInfo(zn, testParams);
        Movie Movie2 = test.iParameters.getMovie();
        int timePts = Movie2.time_end - Movie2.time_start + 1;
        Vector[] na = new Vector[timePts];
        timePts = 20;
        test.readNuclei(zn);
        int start = 7;
        int end = 10;
        int i = start;
        while (i < end) {
            Vector a = test.nuclei_record;
            Vector b = (Vector)a.elementAt(i);
            int c = b.size();
            int j = 0;
            while (j < c) {
                Nucleus n = (Nucleus)b.elementAt(j);
                n.identity = "";
                ++j;
            }
            ++i;
        }
        int[] lineage_ct_p = new int[]{0};
        System.out.println("lineage_ct_p=" + lineage_ct_p[0]);
        test.printNuclei();
        System.out.println("main exiting");
    }

    private void println(String s) {
        System.out.println(s);
    }
}

