/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;
import wormguides.model.LineageData;

public class NucleiMgrAdapter
implements LineageData {
    private NucleiMgr nucleiMgr;

    public NucleiMgrAdapter(NucleiMgr nucleiMgr) {
        this.nucleiMgr = nucleiMgr;
    }

    public String[] getNames(int time) {
        ArrayList<String> namesAL = new ArrayList<String>();
        Vector v = (Vector)this.nucleiMgr.nuclei_record.get(time);
        int m = 0;
        while (m < v.size()) {
            Nucleus n = (Nucleus)v.get(m);
            namesAL.add(n.identity);
            ++m;
        }
        int size = namesAL.size();
        String[] names = new String[size];
        int i = 0;
        while (i < size) {
            names[i] = (String)namesAL.get(i);
            ++i;
        }
        return names;
    }

    public Integer[][] getPositions(int time) {
        ArrayList<ArrayList<Integer>> positionsAL = new ArrayList<ArrayList<Integer>>();
        Vector v = (Vector)this.nucleiMgr.nuclei_record.get(time);
        int m = 0;
        while (m < v.size()) {
            Nucleus n = (Nucleus)v.get(m);
            ArrayList<Integer> position = new ArrayList<Integer>(Arrays.asList(n.x, n.y, (int)n.z));
            positionsAL.add(position);
            ++m;
        }
        int size = positionsAL.size();
        Integer[][] positions = new Integer[size][3];
        int i = 0;
        while (i < size) {
            ArrayList row = (ArrayList)positionsAL.get(i);
            positions[i][0] = (Integer)row.get(0);
            positions[i][1] = (Integer)row.get(1);
            positions[i][2] = (Integer)row.get(2);
            ++i;
        }
        return positions;
    }

    public Integer[] getDiameters(int time) {
        ArrayList<Integer> diametersAL = new ArrayList<Integer>();
        Vector v = (Vector)this.nucleiMgr.nuclei_record.get(time);
        int m = 0;
        while (m < v.size()) {
            Nucleus n = (Nucleus)v.get(m);
            diametersAL.add(n.size);
            ++m;
        }
        int size = diametersAL.size();
        Integer[] diameters = new Integer[size];
        int i = 0;
        while (i < size) {
            diameters[i] = (Integer)diametersAL.get(i);
            ++i;
        }
        return diameters;
    }

    public ArrayList<String> getAllCellNames() {
        Hashtable allCellNamesHash = this.nucleiMgr.getCellsByName();
        ArrayList cells = new ArrayList(allCellNamesHash.values());
        ArrayList<String> allCellNames = new ArrayList<String>();
        int i = 0;
        while (i < cells.size()) {
            allCellNames.add(((Cell)cells.get(i)).getName());
            ++i;
        }
        return allCellNames;
    }

    public int getTotalTimePoints() {
        return this.nucleiMgr.iEndingIndex + 1;
    }

    public int getNumberOfCellsAtTime(int time) {
        return ((Vector)this.nucleiMgr.nuclei_record.get(time)).size();
    }
}

