/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.IOException;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.rhwlab.snight.AceTreeResource;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.NucleiMgrAdapter;
import wormguides.ImageLoader;
import wormguides.MainApp;

public class WormGUIDESWindow
extends Application {
    private Scene scene;
    private Stage primaryStage;
    private BorderPane rootLayout;
    private static AceTreeResource aceTreeResource;
    private static NucleiMgrAdapter nucleiMgrAdapter;
    private static final String JAR_NAME = "WormGUIDES.jar";

    public void start(Stage primaryStage) {
        System.out.println("start");
        ImageLoader.loadImages((String)JAR_NAME);
        this.primaryStage = primaryStage;
        this.primaryStage.setTitle("WormGUIDES");
        long start_time = System.nanoTime();
        this.initRootLayout();
        long end_time = System.nanoTime();
        double difference = (double)(end_time - start_time) / 1000000.0;
        System.out.println("root layout init " + difference + "ms");
        primaryStage.setResizable(true);
        primaryStage.show();
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                System.out.println("exiting...");
                System.exit(0);
            }
        });
    }

    public void initRootLayout() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(MainApp.class.getResource("view/RootLayout.fxml"));
            loader.setResources((ResourceBundle)aceTreeResource);
            this.rootLayout = (BorderPane)loader.load();
            this.scene = new Scene((Parent)this.rootLayout);
            this.primaryStage.setScene(this.scene);
            this.primaryStage.setResizable(true);
            Parent root = this.scene.getRoot();
            for (Node node : root.getChildrenUnmodifiable()) {
                node.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
            }
        }
        catch (IOException e) {
            System.out.println("could not initialize root layout.");
            e.printStackTrace();
        }
    }

    public static void initializeWormGUIDES(NucleiMgr nucleiMgr) {
        nucleiMgrAdapter = new NucleiMgrAdapter(nucleiMgr);
        aceTreeResource = new AceTreeResource(nucleiMgrAdapter);
        WormGUIDESWindow.launch(null);
    }
}

