/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.EventFile;

public class CanonicalTree {
    private Hashtable iCells = new Hashtable();
    private Cell iLastDaughter;
    private Cell iRoot;
    private Vector iSortedCellNames;
    private Hashtable iCanonicalNamesHash = new Hashtable();
    private Hashtable iCanonicalSimpleNamesHash = new Hashtable();
    private static CanonicalTree iCanonicalTree;
    private static final int DIVISIONTIME = 50;
    private static final String CS = ", ";
    private static final char E = 'e';
    private static final char W = 'w';
    private static final char V = 'v';
    private static final char D = 'd';
    private static final char B = 'b';
    private static final char T = 't';
    private static final char A = 'a';
    private static final char P = 'p';
    private static final char L = 'l';
    private static final char R = 'r';
    private static final char X = 'X';

    public static synchronized CanonicalTree getCanonicalTree() {
        if (iCanonicalTree == null) {
            iCanonicalTree = new CanonicalTree();
        }
        return iCanonicalTree;
    }

    private CanonicalTree() {
        this.iRoot = this.createNodes();
        this.makeSortedCellNames();
        this.makeCanonicalHashes();
        Cell c = (Cell)this.iCells.get("Ealaa");
        c.showParameters();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private Cell createNodes() {
        String evtFile = "lineage2.gtr";
        EventFile ef = new EventFile(evtFile);
        String[] s = new String[]{};
        Cell daughter = new Cell("P0");
        int i = 0;
        while (i < 5000) {
            try {
                s = ef.getNextEvent();
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                break;
            }
            if (s.length == 2) {
                this.processCellDeath(s);
            } else {
                Cell parent = (Cell)this.iCells.get(s[0]);
                if (parent == null) {
                    parent = new Cell(s[0], 500);
                    this.iCells.put(s[0], parent);
                }
                int time = Integer.parseInt(s[3]);
                parent.setEndTime(time);
                parent.setEndFate(1);
                daughter = new Cell(s[1], 500);
                daughter.setStartTime(time);
                parent.add(daughter);
                this.iCells.put(s[1], daughter);
                daughter = new Cell(s[2], 500);
                daughter.setStartTime(time);
                parent.add(daughter);
                this.iCells.put(s[2], daughter);
            }
            ++i;
        }
        this.iLastDaughter = daughter;
        this.postProcessTree((Cell)this.iCells.get("P0"));
        return (Cell)this.iCells.get("P0");
    }

    private void postProcessTree(Cell root) {
        Cell c;
        int maxEndTime = 0;
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            c = (Cell)e.nextElement();
            int end = c.getEndTime();
            maxEndTime = Math.max(end, maxEndTime);
        }
        maxEndTime += 50;
        e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            c = (Cell)e.nextElement();
            c.setEndingIndex(maxEndTime);
            if (c.getEnd() != 0) continue;
            c.setEndTime(maxEndTime);
        }
    }

    private void processCellDeath(String[] sa) {
        Cell c = (Cell)this.iCells.get(sa[0]);
        if (c != null) {
            int dt = Integer.parseInt(sa[1]);
            c.setEndTime(dt);
            c.setEndFate(2);
        } else {
            System.out.println("canonical lineage error -- unknown cell dying: " + sa[0]);
        }
    }

    private void makeSortedCellNames() {
        this.iSortedCellNames = new Vector();
        Enumeration e = this.iCells.keys();
        while (e.hasMoreElements()) {
            this.iSortedCellNames.add((String)e.nextElement());
        }
        Collections.sort(this.iSortedCellNames);
    }

    private void makeCanonicalHashes() {
        Enumeration e = this.iSortedCellNames.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Cell c = (Cell)this.iCells.get(name);
            Cell p = (Cell)c.getParent();
            if (p == null) continue;
            String pname = p.getName();
            String spname = CanonicalTree.makeSimpleName(pname);
            Cell d1 = (Cell)p.getChildAt(0);
            String dname = d1.getName();
            this.iCanonicalNamesHash.put(pname, dname);
            this.iCanonicalSimpleNamesHash.put(spname, dname);
        }
    }

    public Hashtable getCanonicalNamesHash() {
        return this.iCanonicalNamesHash;
    }

    public Hashtable getCanonicalSimpleNamesHash() {
        return this.iCanonicalSimpleNamesHash;
    }

    public static String makeNewName(String name, char tag) {
        int k = name.length();
        StringBuffer sb = new StringBuffer(name);
        sb.setCharAt(k - 1, tag);
        if (!name.equals(sb.toString())) {
            System.out.println("makeNewName: " + name + CS + sb.toString() + CS + tag);
        }
        return sb.toString();
    }

    public static String makeSisterName(String s) {
        String sis = null;
        char x = s.charAt(0);
        int n = s.length();
        boolean b = n == 1;
        switch (x) {
            case 'C': {
                if (b) {
                    return "P3";
                }
            }
            case 'D': {
                if (b) {
                    return "P4";
                }
                sis = CanonicalTree.replaceLastChar(s);
                break;
            }
            case 'E': {
                if (b) {
                    return "MS";
                }
                sis = CanonicalTree.replaceLastChar(s);
                break;
            }
            case 'M': {
                if (n == 2) {
                    return "E";
                }
                sis = CanonicalTree.replaceLastChar(s);
                break;
            }
            case 'A': {
                if (s.equals("ABal")) {
                    return "ABar";
                }
                if (s.equals("ABpl")) {
                    return "ABpr";
                }
                sis = CanonicalTree.replaceLastChar(s);
                break;
            }
            case 'Z': {
                sis = s.equals("Z2") ? "Z3" : "Z2";
            }
            case 'P': {
                if (s.equals("P2")) {
                    sis = "EMS";
                    break;
                }
                if (s.equals("P3")) {
                    sis = "C";
                    break;
                }
                if (!s.equals("P4")) break;
                sis = "D";
            }
        }
        return sis;
    }

    private static String replaceLastChar(String s) {
        StringBuffer sb = new StringBuffer(s);
        int n = sb.length() - 1;
        char x = sb.charAt(n);
        switch (x) {
            case 'a': {
                sb.setCharAt(n, 'p');
                break;
            }
            case 'l': {
                sb.setCharAt(n, 'r');
                break;
            }
            case 'd': {
                sb.setCharAt(n, 'v');
                break;
            }
            case 'p': {
                sb.setCharAt(n, 'a');
                break;
            }
            case 'r': {
                sb.setCharAt(n, 'l');
                break;
            }
            case 'v': {
                sb.setCharAt(n, 'd');
            }
        }
        return sb.toString();
    }

    public static String makeSimpleName(String name) {
        String s = name;
        s = s.replace('d', 'a');
        s = s.replace('l', 'a');
        s = s.replace('v', 'p');
        s = s.replace('r', 'p');
        return s;
    }

    public Cell getRoot() {
        return this.iRoot;
    }

    public Hashtable getCellsHash() {
        return this.iCells;
    }

    public Vector getSortedCellNames() {
        return this.iSortedCellNames;
    }

    public static void main(String[] args) {
    }
}

