/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class VTreeImplZ {
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    AncesTree iAncesTree;
    Hashtable iCellsByName;
    Cell iRoot;
    Vector iCellLines;
    Vector iLines;
    Vector iNames;
    int iKlast;
    int iKincInit;
    String iPSFileName;
    int iLineWidth;
    int iLineInc;
    int iFontSize;
    Hashtable iDaughters;
    TestCanvas iTestCanvas;
    double[] iLimits;
    double iYScale;
    int iYTranslate;
    private static final String[][] SUBLINEAGES = new String[][]{{"P1", "EMS", "MS", "E", "P2", "C", "P3", "D", "P4", "Z"}, {"P2", "C", "P3", "D", "P4", "Z"}, {"P3", "D", "P4", "Z"}, {"P4", "Z"}, {"EMS", "MS", "E"}};
    private static final String[] PSHEADER = new String[]{"%!", "/n {newpath} bind def", "/m {moveto} bind def", "/l {lineto} bind def", "/r {rlineto} bind def", "/c {setrgbcolor} bind def", "/cp {closepath} bind def", "/s {stroke} bind def", "/x {moveto setrgbcolor lineto closepath stroke} bind def", "/sg {setgray} bind def", "/Courier findfont "};
    private static final String MOVETO = " m";
    private static final String LINETO = " l";
    private static final String RLINETO = " r";
    private static final String NEWPATH = "n";
    private static final String COLOR = " c";
    private static final String CLOSEPATH = "cp";
    private static final String X = "x";
    private static final String FILL = "fill";
    private static final String STROKE = "s";
    private static final String SHOW = " show";
    private static final String COMMENT = " %";
    private static final String SP = " ";
    private static final String LEFT = "(";
    private static final String RITE = ")";
    private static final int ROOTNAME = 0;
    private static final int MINRED = 1;
    private static final int MAXRED = 2;
    private static final int YINCLOC = 3;
    private static final int LINEWIDTH = 4;
    private static final int PSFILE = 5;
    private static final int SEPARATORS = 6;
    private static final int TOP = 8000;
    private static final int OFFSET = 100;
    private static final int DELTAY = 5;
    private static final int DELTAT = 1;
    private static final int YINC = 20;
    private static final int YOFFSET = 500;
    private static final int MINFONTSIZE = 10;
    private static final String CS = ", ";

    public VTreeImplZ() {
        this.initialize();
        this.iKincInit = 20;
        this.iFontSize = 10;
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    private String setParams(JTextField[] params) {
        String rootName = "P0";
        String minRed = "10000";
        String maxRed = "90000";
        String yInc = "2";
        Cell.setMinRed(Integer.parseInt(minRed));
        Cell.setMaxRed(Integer.parseInt(maxRed));
        this.iKincInit = Integer.parseInt(yInc);
        this.iLineWidth = 1;
        this.iLineInc = Integer.parseInt(yInc);
        return rootName;
    }

    private void prepareIt(String rootName) {
        this.iCellLines = new Vector();
        this.iLines = new Vector();
        this.iNames = new Vector();
        this.prepare(rootName);
    }

    public void showTree(JTextField[] params) {
        String rootName = this.setParams(params);
        this.prepareIt(rootName);
        TestCanvas tc = new TestCanvas(rootName);
        tc.showIt();
        this.iTestCanvas = tc;
    }

    public void printTree(JTextField[] params, String fileName, String dir) {
        String rootName = this.setParams(params);
        this.iPSFileName = String.valueOf(dir) + "/" + fileName;
        if (fileName.indexOf("png") >= 0) {
            this.iTestCanvas.captureImage(fileName, dir);
            return;
        }
        Vector vSep = this.getSeparators("NONE");
        this.prepareIt(rootName);
        Vector v = this.packageIt();
        v = this.segregate(v, vSep);
        this.printIt(v);
    }

    private Vector getSeparators(String ss) {
        Vector<String[]> v = new Vector<String[]>();
        String[] sa = null;
        String[] sb = null;
        sb = new String[]{""};
        v.add(sb);
        if (ss.indexOf("NONE") != 0) {
            sa = ss.split(",");
            int i = 0;
            while (i < sa.length) {
                if (sa[i].equals("P1")) {
                    v.add(0, SUBLINEAGES[0]);
                } else if (sa[i].equals("P2")) {
                    v.add(0, SUBLINEAGES[1]);
                } else if (sa[i].equals("P3")) {
                    v.add(0, SUBLINEAGES[2]);
                } else if (sa[i].equals("P2")) {
                    v.add(0, SUBLINEAGES[3]);
                } else if (sa[i].equals("EMS")) {
                    v.add(0, SUBLINEAGES[4]);
                } else {
                    sb = new String[]{sa[i]};
                    v.add(0, sb);
                }
                ++i;
            }
        }
        return v;
    }

    private Vector segregate(Vector vIn, Vector vSep) {
        Vector va = new Vector();
        Vector<String> v = null;
        String pattern = null;
        Object patternVec = null;
        Vector<String> vKill = null;
        int j = 0;
        while (j < vSep.size()) {
            String[] sa = (String[])vSep.get(j);
            v = new Vector<String>();
            vKill = new Vector<String>();
            Enumeration e = vIn.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                int i = 0;
                while (i < sa.length) {
                    pattern = sa[i];
                    if (s.indexOf(COMMENT + pattern) >= 0) {
                        v.add(s);
                        vKill.add(s);
                    }
                    ++i;
                }
            }
            Enumeration ee = vKill.elements();
            while (ee.hasMoreElements()) {
                vIn.remove(ee.nextElement());
            }
            v.add("showpage");
            va.add(v);
            ++j;
        }
        v = (Vector<String>)va.get(0);
        return va;
    }

    public Vector packageIt() {
        this.println("packageIt, entered");
        this.iLimits = this.findYLimits();
        double scale = 700.0 / (this.iLimits[0] - this.iLimits[1]);
        this.iYScale = Math.ceil(scale * 100.0) / 100.0;
        this.iYScale = Math.min(this.iYScale, 1.0);
        this.iYTranslate = (int)this.iLimits[0] - 8000 + 100;
        Vector<String> v = new Vector<String>();
        int offset = 100;
        int i = 0;
        while (i < this.iCellLines.size()) {
            Object p;
            Object o = this.iCellLines.get(i);
            if (o instanceof CellLine) {
                int x1;
                p = (CellLine)o;
                int x2 = x1 = ((CellLine)p).c.getTime() + offset;
                if (((CellLine)p).y1 == ((CellLine)p).y2) {
                    x2 = ((CellLine)p).c.getEnd() + offset;
                }
                String ss = this.prepareLine(x1, ((CellLine)p).y1, x2, ((CellLine)p).y2, ((CellLine)p).c);
                v.add(ss);
                if (((CellLine)p).y1 != ((CellLine)p).y2) {
                    ss = this.prepareErrorBars(x1, ((CellLine)p).y1, ((CellLine)p).y2, ((CellLine)p).c);
                    v.add(ss);
                }
            } else {
                p = (Name)o;
                v.add(this.prepareString(((Name)p).c, ((Name)p).name, ((Name)p).x, ((Name)p).y));
            }
            ++i;
        }
        return v;
    }

    public double[] findYLimits() {
        int ymax = 0;
        int ymin = Integer.MAX_VALUE;
        int offset = 100;
        int i = 0;
        while (i < this.iCellLines.size()) {
            Object p;
            Object o = this.iCellLines.get(i);
            if (o instanceof CellLine) {
                p = (CellLine)o;
                int y = Math.max(((CellLine)p).y1, ((CellLine)p).y2);
                ymax = Math.max(ymax, y);
                y = Math.min(((CellLine)p).y1, ((CellLine)p).y2);
                ymin = Math.min(ymin, y);
            } else {
                p = (Name)o;
                ymax = Math.max(ymax, ((Name)p).y);
                ymin = Math.min(ymin, ((Name)p).y);
            }
            ++i;
        }
        double[] rtn = new double[]{ymax, ymin};
        System.out.println("findYLimits, " + rtn[0] + CS + rtn[1]);
        return rtn;
    }

    public void printIt(Vector vIn) {
        PrintWriter pw = null;
        try {
            FileOutputStream fs = new FileOutputStream(this.iPSFileName);
            pw = new PrintWriter(fs);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return;
        }
        Vector v = null;
        String s = null;
        int i = 0;
        while (i < PSHEADER.length) {
            pw.println(PSHEADER[i]);
            ++i;
        }
        pw.println(String.valueOf(this.iLineInc) + " scalefont setfont");
        pw.println(String.valueOf(this.iLineWidth) + " setlinewidth");
        System.out.println("printIt, " + this.iYScale + CS + this.iYTranslate);
        pw.println("1 " + this.iYScale + " scale");
        pw.println("0 " + this.iYTranslate + " translate");
        i = 0;
        while (i < vIn.size()) {
            v = (Vector)vIn.get(i);
            int j = 0;
            while (j < v.size()) {
                s = (String)v.get(j);
                pw.println(s);
                ++j;
            }
            ++i;
        }
        pw.flush();
        pw.close();
    }

    private String prepareLine(int x1, int y1, int x2, int y2, Cell c) {
        DecimalFormat df = new DecimalFormat("#.##");
        int top = 8000;
        String s = "";
        StringBuffer sb = new StringBuffer();
        int y = top - y1;
        if (x1 == x2) {
            sb = new StringBuffer(NEWPATH);
            s = SP + x1 + SP + (top - y1) + MOVETO;
            sb.append(SP + s);
            Color cc = null;
            try {
                cc = c.getColor(0);
            }
            catch (Exception e) {
                cc = Color.BLACK;
            }
            float[] cf = cc.getColorComponents(null);
            s = SP + df.format(cf[0]) + SP + df.format(cf[1]) + SP + df.format(cf[2]);
            s = String.valueOf(s) + COLOR;
            s = String.valueOf(s) + SP + 0 + SP + (y1 - y2) + RLINETO;
            sb.append(SP + s);
            sb.append(" cp s %" + c.getName());
            return sb.toString();
        }
        int x = x1;
        while (x <= x2) {
            Color cc = null;
            try {
                cc = c.getColor(x - x1);
            }
            catch (Exception e) {
                cc = Color.BLACK;
            }
            float[] cf = cc.getColorComponents(null);
            s = NEWPATH;
            s = String.valueOf(s) + SP + x + SP + y;
            s = String.valueOf(s) + SP + df.format(cf[0]) + SP + df.format(cf[1]) + SP + df.format(cf[2]);
            s = String.valueOf(s) + SP + (x + 1) + SP + y + SP + X;
            sb.append(SP + s);
            ++x;
        }
        sb.append(COMMENT + c.getName());
        return sb.toString();
    }

    private String prepareErrorBars(int x, int y1, int y2, Cell c) {
        StringBuffer sb = new StringBuffer();
        int low = 3;
        int high = 7;
        int halfTab = 2;
        int y = (y1 + y2) / 2;
        y = 8000 - y;
        sb.append(this.mockDrawLine(x - low, y, x + high, y));
        sb.append(this.mockDrawLine(x - low, y - halfTab, x - low, y + halfTab));
        sb.append(this.mockDrawLine(x + high, y - halfTab, x + high, y + halfTab));
        sb.append(COMMENT + c.getName());
        return sb.toString();
    }

    private String mockDrawLine(int x1, int y1, int x2, int y2) {
        DecimalFormat df = new DecimalFormat("#.##");
        StringBuffer sb = new StringBuffer(String.valueOf(2 * this.iLineWidth) + SP + "setlinewidth" + SP + NEWPATH);
        Color cc = null;
        cc = Color.BLACK;
        float[] cf = cc.getColorComponents(null);
        String color = String.valueOf(df.format(cf[0])) + SP + df.format(cf[1]) + SP + df.format(cf[2]);
        sb.append(SP + x1 + SP + y1);
        sb.append(SP + color);
        sb.append(SP + x2 + SP + y2 + SP + X + SP);
        sb.append(SP + this.iLineWidth + SP + "setlinewidth" + SP);
        return sb.toString();
    }

    private String prepareLineX(int x1, int y1, int x2, int y2, Cell c) {
        DecimalFormat df = new DecimalFormat("#.##");
        int top = 8000;
        String s = "";
        StringBuffer sb = new StringBuffer(NEWPATH);
        s = String.valueOf(x1) + SP + (top - y1) + MOVETO;
        sb.append(SP + s);
        int y = y1 - y2;
        if (x1 == x2) {
            s = "0 " + y + RLINETO;
            sb.append(SP + s);
        } else {
            int x = 1;
            while (x <= x2 - x1) {
                Color cc = null;
                try {
                    cc = c.getColor(x - 1);
                }
                catch (Exception e) {
                    cc = Color.BLACK;
                }
                float[] cf = cc.getColorComponents(null);
                s = String.valueOf(df.format(cf[0])) + SP + df.format(cf[1]) + SP + df.format(cf[2]) + COLOR;
                s = String.valueOf(s) + SP + 1 + SP + y + SP + RLINETO;
                sb.append(SP + s);
                ++x;
            }
        }
        sb.append(" cp s %" + c.getName());
        return sb.toString();
    }

    private String prepareString(Cell c, String n, int x, int y) {
        int top = 8000;
        DecimalFormat df = new DecimalFormat("#.##");
        String s = null;
        Color cc = c.getLastColor();
        float[] cf = cc.getColorComponents(null);
        s = String.valueOf(df.format(cf[0])) + SP + df.format(cf[1]) + SP + df.format(cf[2]) + COLOR;
        s = String.valueOf(s) + SP + x + SP + (top - y) + MOVETO + SP + LEFT + n + RITE + SHOW + COMMENT + n;
        return s;
    }

    public void prepare(String rootName) {
        Hashtable<Cell, Cell> doneHash = new Hashtable<Cell, Cell>();
        this.iDaughters = new Hashtable();
        String s = "";
        int kStart = 50;
        this.iKlast = 0;
        int k = kStart;
        int kInc = this.iKincInit;
        int nameInterval = Math.max(this.iFontSize / kInc, 1);
        int xOffset = 100;
        Cell root = (Cell)this.iCellsByName.get(rootName);
        if (root == null) {
            System.out.println("rootName not found: " + rootName);
            return;
        }
        int rootLevel = root.getLevel();
        int rootDepth = root.getDepth();
        Cell x = null;
        Object y = null;
        Cell parent = null;
        Vector v = this.getLeaves(rootName);
        boolean leafPass = true;
        Hashtable allCells = this.getAllCells(rootName);
        Vector<Cell> p = new Vector<Cell>();
        int i = 0;
        while (i <= root.getDepth()) {
            Vector<Cell> readds = new Vector<Cell>();
            if (i > 0) {
                v = (Vector)p.clone();
                p = new Vector();
                leafPass = false;
            }
            s = "v size: " + v.size();
            this.println(s);
            int j = 0;
            while (j < v.size()) {
                block25: {
                    x = (Cell)v.get(j);
                    if (allCells.get(x) != null && x != this.iRoot) {
                        int xStart;
                        block24: {
                            Cell o;
                            this.println("\nNOW CONSIDERING: " + x.getName());
                            parent = (Cell)x.getParent();
                            xStart = x.getTime() + xOffset;
                            if (parent.getName() != "P") {
                                Cell sister = (Cell)parent.getChildAt(1);
                                if (x == sister) {
                                    sister = (Cell)parent.getChildAt(0);
                                }
                                boolean itsInThere = v.contains(sister);
                                this.println("sister: " + sister.getName() + CS + itsInThere + CS + (i > 0));
                                if (!itsInThere && i > 0) {
                                    this.println("add parent: " + x.getName() + " because sister not present " + sister.getName());
                                    p.add(x);
                                }
                                boolean soloLeaf = false;
                                if (i == 0 && x.getDepth() < sister.getDepth()) {
                                    soloLeaf = true;
                                }
                                if (soloLeaf) {
                                    this.println("add parent: " + parent + " because of soloLeaf " + x.getName());
                                    p.add(parent);
                                }
                            }
                            Daughters myD = null;
                            Daughter da = null;
                            Daughter db = null;
                            if (i > 0) {
                                try {
                                    myD = (Daughters)this.iDaughters.get(x);
                                    da = myD.da[0];
                                    db = myD.da[1];
                                    this.println("available daughters: " + da + CS + db);
                                    if (da != null && db != null) {
                                        k = (da.y + db.y) / 2;
                                        if (doneHash.get(x) == null) {
                                            doneHash.put(x, x);
                                            o = (Cell)allCells.remove(x);
                                            if (o == null) {
                                                this.println("REMOVING NON EXISTANT CELL: " + o.getName());
                                            }
                                            this.println("drawing from " + x.getName() + CS + da + CS + db);
                                            this.handleCellLine(x, k, k);
                                            this.iKlast = Math.max(k, this.iKlast);
                                        }
                                        break block24;
                                    }
                                    if (da != null && db != null) break block24;
                                    if (!readds.contains(x)) {
                                        readds.add(x);
                                        v.add(x);
                                        this.println("readded: " + x.getName());
                                    } else {
                                        p.add(x);
                                        this.println("add parent: " + x.getName() + " because I cannot process it this time");
                                    }
                                    break block25;
                                }
                                catch (NullPointerException npe) {
                                    this.println("NULLPOINTER: " + x.getName() + CS + myD);
                                    break block24;
                                }
                            }
                            if (doneHash.get(x) == null) {
                                this.println("drawing from " + x.getName() + CS + da + CS + db);
                                this.handleCellLine(x, k, k);
                                this.iKlast = Math.max(k, this.iKlast);
                                doneHash.put(x, x);
                                o = (Cell)allCells.remove(x);
                                if (o == null) {
                                    this.println("REMOVING NON EXISTANT CELL: " + o.getName());
                                }
                            }
                        }
                        Daughter d1 = new Daughter(x, xStart, k);
                        Daughters ds = (Daughters)this.iDaughters.get(parent);
                        if (ds == null) {
                            ds = new Daughters(d1, null);
                            this.iDaughters.put(parent, ds);
                            p.add(parent);
                            this.println("add parent: " + parent.getName() + " create daughters with daughter " + d1.d.getName());
                        } else {
                            ds.addSecond(d1);
                            this.println("adding to daughters of parent " + parent.getName() + " with daughter " + d1.d.getName());
                            Daughter d2 = ds.getFirst();
                            if (d2 != null) {
                                this.println("drawing connector between " + x.getName() + CS + d2.d.getName());
                                this.handleCellLine(x, k, d2.y);
                            }
                        }
                        if (i == 0 && j % nameInterval == 0) {
                            this.handleString(x, this.iNucleiMgr.getEndingIndex() + xOffset + 10, k);
                        }
                        k += this.iKincInit * (parent.getLeafCount() - 1);
                    }
                }
                ++j;
            }
            s = "parentSize: " + p.size();
            this.println(s);
            ++i;
        }
        this.println("check all cells: " + allCells.size());
        this.println("iKlast: " + this.iKlast);
    }

    private void println(String s) {
        System.out.println(s);
    }

    private void handleCellLine(Cell c, int y1, int y2) {
        CellLine cLine = new CellLine(c, y1, y2);
        this.iCellLines.add(cLine);
    }

    private void handleString(Cell c, int x, int y) {
        Name name = new Name(c, x, y);
        this.iCellLines.add(name);
    }

    private Hashtable getAllCells(String rootName) {
        Hashtable<Cell, Cell> h = new Hashtable<Cell, Cell>();
        Cell x = (Cell)this.iCellsByName.get(rootName);
        Enumeration<TreeNode> e = x.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Cell cn = (Cell)e.nextElement();
            h.put(cn, cn);
        }
        return h;
    }

    private Vector getLeaves(String rootName) {
        Vector<Cell> v = new Vector<Cell>();
        Cell d = (Cell)this.iCellsByName.get(rootName);
        int last = d.getLeafCount();
        boolean k = false;
        Cell x = (Cell)d.getFirstLeaf();
        int i = 0;
        while (i < last) {
            v.add(0, x);
            x = (Cell)x.getNextLeaf();
            if (x == null) break;
            ++i;
        }
        return v;
    }

    public static void main(String[] args) {
    }

    private class CellLine {
        Cell c;
        int y1;
        int y2;

        private CellLine(Cell cc, int yy1, int yy2) {
            this.c = cc;
            this.y1 = yy1;
            this.y2 = yy2;
        }
    }

    private class Daughter {
        Cell d;
        int x;
        int y;

        private Daughter(Cell c, int xx, int yy) {
            this.d = c;
            this.x = 0;
            this.y = yy;
        }

        public String toString() {
            String s = "";
            s = String.valueOf(s) + this.d.getName();
            s = String.valueOf(s) + VTreeImplZ.CS + this.x + VTreeImplZ.CS + this.y;
            return s;
        }
    }

    private class Daughters {
        Daughter[] da = new Daughter[2];

        private Daughters(Daughter d1, Daughter d2) {
            this.da[0] = d1;
            this.da[1] = d2;
        }

        private boolean addSecond(Daughter d2) {
            if (this.da[0].d.getName().equals(d2.d.getName())) {
                return false;
            }
            this.da[1] = d2;
            return true;
        }

        private Daughter getFirst() {
            return this.da[0];
        }
    }

    private class Name {
        Cell c;
        String name;
        int x;
        int y;

        private Name(Cell cc, int xx, int yy) {
            this.c = cc;
            this.name = this.c.getName();
            this.x = xx;
            this.y = yy;
        }
    }

    class TestCanvas
    extends Canvas {
        private boolean iWasDrawn;
        private String rootName;
        int height;
        int width;

        public TestCanvas(String rName) {
            this.rootName = rName;
            this.setBackground(Color.white);
            int height = VTreeImplZ.this.iKlast + 100;
            this.width = 500;
            this.setSize(new Dimension(this.width, height));
            MouseHandler mh = new MouseHandler(this);
            this.addMouseMotionListener(mh);
            this.addMouseListener(mh);
        }

        private void println(String s) {
            if (!this.iWasDrawn) {
                System.out.println(s);
            }
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int offset = 100;
            Graphics2D g2 = (Graphics2D)g;
            int width = 4;
            g2.setStroke(new BasicStroke(VTreeImplZ.this.iLineWidth));
            int i = 0;
            while (i < VTreeImplZ.this.iCellLines.size()) {
                Object p;
                Object o = VTreeImplZ.this.iCellLines.get(i);
                if (o instanceof CellLine) {
                    int x1;
                    p = (CellLine)o;
                    int x2 = x1 = ((CellLine)p).c.getTime() + offset;
                    if (((CellLine)p).y1 == ((CellLine)p).y2) {
                        x2 = ((CellLine)p).c.getEnd() + offset;
                    }
                    g2.setColor(Color.black);
                    this.drawLine(g2, x1, ((CellLine)p).y1, x2, ((CellLine)p).y2, ((CellLine)p).c);
                    if (((CellLine)p).y1 != ((CellLine)p).y2) {
                        this.drawErrorBars(g2, x1, ((CellLine)p).y1, ((CellLine)p).y2, ((CellLine)p).c);
                    }
                } else {
                    p = (Name)o;
                    this.drawString(g2, ((Name)p).x, ((Name)p).y, ((Name)p).c);
                }
                ++i;
            }
        }

        private void drawErrorBars(Graphics2D g2, int x, int y1, int y2, Cell c) {
            int low = 3;
            int high = 7;
            int halfTab = 2;
            g2.setStroke(new BasicStroke(2 * VTreeImplZ.this.iLineWidth));
            Color colIn = g2.getColor();
            g2.setColor(Color.magenta);
            int y = (y1 + y2) / 2;
            g2.drawLine(x - low, y, x + high, y);
            g2.drawLine(x - low, y - halfTab, x - low, y + halfTab);
            g2.drawLine(x + high, y - halfTab, x + high, y + halfTab);
            g2.setStroke(new BasicStroke(VTreeImplZ.this.iLineWidth));
            g2.setColor(colIn);
        }

        public void captureImage(String fileName, String dir) {
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics g = image.getGraphics();
            this.paint(g);
            File f = new File(String.valueOf(dir) + "/" + fileName);
            try {
                ImageIO.write((RenderedImage)image, "png", f);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.makeWebPage(fileName, dir);
        }

        public void makeWebPage(String fileName, String dir) {
            String s = fileName.substring(0, fileName.length() - 4);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(String.valueOf(dir) + "/" + s + ".html", false);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return;
            }
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println("<html>");
            pw.println("<head><title>" + s + "</title></head>");
            pw.println("<body>");
            pw.println("<img src=\"" + s + ".png\">");
            pw.println("</body>");
            pw.println("</html>");
        }

        public void showIt() {
            JFrame jf = new JFrame();
            JFrame.setDefaultLookAndFeelDecorated(false);
            ScrollPane sp = new ScrollPane(1);
            sp.add(this);
            jf.getContentPane().add((Component)sp, "Center");
            jf.setSize(new Dimension(600, 500));
            jf.setVisible(true);
        }

        private Cell findIt(int xx, int yy) {
            CellLine cL = null;
            Cell c = null;
            int t = xx - 100;
            int i = 0;
            while (i < VTreeImplZ.this.iCellLines.size()) {
                Object o = VTreeImplZ.this.iCellLines.get(i);
                if (o instanceof CellLine) {
                    cL = (CellLine)o;
                    if (yy >= cL.y1 - 5 && yy <= cL.y2 + 5 && t >= (c = cL.c).getTime() - 1 && t <= c.getEnd() + 1) break;
                }
                ++i;
            }
            return c;
        }

        private void drawLine(Graphics g, int x1, int y1, int x2, int y2, Cell c) {
            if (x1 == x2) {
                try {
                    Color cc = c.getColor(0);
                    g.setColor(cc);
                }
                catch (Exception e) {
                    g.setColor(Color.BLACK);
                }
                g.drawLine(x1, y1, x2, y2);
            } else {
                int k = 0;
                int x = x1;
                while (x < x2) {
                    try {
                        Color cc = c.getColor(k++);
                        g.setColor(cc);
                    }
                    catch (Exception e) {
                        g.setColor(Color.BLACK);
                    }
                    g.drawLine(x, y1, x + 1, y2);
                    ++x;
                }
            }
        }

        private void drawString(Graphics g, int x, int y, Cell c) {
            Color cc = c.getLastColor();
            g.setColor(cc);
            Font f = new Font("Courier", 0, 10);
            g.setFont(f);
            g.drawString(c.getName(), x, y);
        }

        class MouseHandler
        extends MouseInputAdapter {
            public MouseHandler(Object o) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            public void notifyAceTree(Cell c, int time) {
                Vector<String> v = new Vector<String>();
                v.add("InputCtrl1");
                v.add(String.valueOf(time));
                v.add(c.getName());
                ((TestCanvas)TestCanvas.this).VTreeImplZ.this.iAceTree.controlCallback(v);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Cell cs = TestCanvas.this.findIt(e.getX(), e.getY());
                if (cs != null) {
                    int intTime = e.getX() - 100;
                    int button = e.getButton();
                    if (button == 1) {
                        this.notifyAceTree(cs, intTime);
                    } else if (button == 3) {
                        this.notifyAceTree(cs, cs.getEndTime());
                    }
                }
            }
        }
    }
}

