/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.utils;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.tree.CanonicalTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.SulstonTree;

public class AuxFrame
extends JPanel
implements ActionListener,
TreeSelectionListener {
    public String iTitle;
    private JFrame iFrame;
    private JToolBar iToolBar;
    private JTree iTree;
    private AceTree iAceTree;
    private Cell iRoot;
    private Cell iCurrentCell;
    private CanonicalTree iCanonicalTree;
    private static final int WIDTH = 300;
    private static final int HEIGHT = 400;
    private static final String CS = ", ";

    public AuxFrame(AceTree aceTree, String title, CanonicalTree canonicalTree) {
        this.iTitle = title;
        this.iAceTree = aceTree;
        this.iCanonicalTree = canonicalTree;
        this.iRoot = this.iCanonicalTree.getRoot();
        this.iTree = new JTree(this.iRoot);
        this.iCurrentCell = this.iRoot;
        this.iTree.addTreeSelectionListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 10));
        JButton jb1 = new JButton("Sulston style tree");
        jb1.addActionListener(this);
        this.iToolBar.add(jb1);
        this.add(this.iToolBar);
        this.displayTree();
        this.iFrame = new JFrame(this.iTitle);
        this.showMe();
    }

    private void displayTree() {
        this.iTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setLeafIcon(null);
        this.setLayout(new BoxLayout(this, 1));
        JPanel treev = new JPanel();
        treev.setLayout(new BorderLayout());
        JScrollPane treeView = new JScrollPane(this.iTree);
        treeView.setPreferredSize(new Dimension(300, 400));
        treeView.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        treev.add(treeView);
        this.add(treev);
    }

    public void expandTree() {
        Cell c = (Cell)this.iRoot.getFirstLeaf();
        while (c != null) {
            this.showTreeCell(c);
            c = (Cell)c.getNextLeaf();
        }
    }

    private void showTreeCell(Cell c) {
        Object[] tna = c.getPath();
        TreePath tp = new TreePath(tna);
        this.iTree.makeVisible(tp);
        int row = this.iTree.getRowForPath(tp);
        this.iTree.setSelectionInterval(row, row);
        this.iTree.scrollRowToVisible(row);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int endingIndex = Cell.getEndingIndex();
        Cell.setEndingIndexS(500);
        Cell.setEndingIndexS(endingIndex);
        new SulstonTree(this.iCanonicalTree, this.iTitle, this.iCurrentCell, false, null);
        Cell.setEndingIndexS(endingIndex);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.iCurrentCell = (Cell)e.getPath().getLastPathComponent();
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

