/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ConfigFileList
implements ActionListener {
    private JMenuItem iConfigList;
    private JMenuItem iChoose;
    private JMenuItem iExit;
    private JMenu iMenu;
    private Vector iConfigFiles;
    private int iItem;
    private int iItems;
    private JPanel iPanel;
    private static final String CONFIGS = "ConfigFiles";
    private static final String CHOOSE = "Choose";
    private static final String EXIT = "Exit";

    public ConfigFileList(JPanel jpanel) {
        this.iPanel = jpanel;
    }

    public void createMenu(JMenuBar menuBar) {
        this.iMenu = new JMenu("File");
        menuBar.add(this.iMenu);
        this.iConfigList = new JMenuItem(CONFIGS);
        this.iExit = new JMenuItem(EXIT);
        this.iMenu.add(this.iConfigList);
        this.iMenu.add(this.iExit);
        this.iConfigList.addActionListener(this);
        this.iExit.addActionListener(this);
    }

    private void getFile() {
        JFileChooser fc = new JFileChooser(".");
        int returnVal = fc.showOpenDialog(this.iPanel);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.readConfigFileList(file);
        } else {
            System.out.println("Save command cancelled by user.");
        }
    }

    private void readConfigFileList(File f) {
        String sr = null;
        this.iConfigFiles = new Vector();
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            sr = br.readLine();
            while (sr != null && sr.length() > 2) {
                this.iConfigFiles.add(sr);
                sr = br.readLine();
            }
            br.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.iItem = 0;
        this.iItems = this.iConfigFiles.size();
    }

    public Vector getConfigFiles() {
        return this.iConfigFiles;
    }

    public String getItem(int i) {
        return (String)this.iConfigFiles.elementAt(i);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(CONFIGS)) {
            this.getFile();
        } else if (s.equals(EXIT)) {
            // empty if block
        }
    }

    public static void main(String[] args) {
    }
}

