/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.utils;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class HeatMap
extends Canvas {
    int iNumTimes;
    int iNumCells;
    int iNumColors;
    int[][] iR;
    String[] iLabels;
    int iMin;
    int iMax;
    double iScale;
    int iXinc;
    int iYinc;
    private static final Color[] CMAP = new Color[]{new Color(0, 255, 0), new Color(0, 230, 0), new Color(0, 205, 0), new Color(0, 180, 0), new Color(0, 155, 0), new Color(0, 130, 0), new Color(0, 105, 0), new Color(0, 80, 0), new Color(0, 55, 0), new Color(0, 30, 0), new Color(30, 0, 0), new Color(55, 0, 0), new Color(85, 0, 0), new Color(105, 0, 0), new Color(130, 0, 0), new Color(155, 0, 0), new Color(180, 0, 0), new Color(205, 0, 0), new Color(230, 0, 0), new Color(255, 0, 0)};

    public HeatMap(int[][] data, String[] labels, int min, int max) {
        this.iNumCells = data.length;
        this.iNumTimes = data[0].length;
        this.iR = data;
        this.iLabels = labels;
        this.iMin = min;
        this.iMax = max;
        this.iScale = (double)CMAP.length / (double)(max - min);
        this.iXinc = 10;
        this.iYinc = 10;
        this.setSize(this.iNumTimes * this.iXinc + 100, this.iNumCells * this.iYinc);
    }

    public void setMinMax(int min, int max) {
        this.iMin = min;
        this.iScale = (double)CMAP.length / (double)(max - min);
        this.invalidate();
    }

    public void setSpotSize(int width, int height) {
        this.iXinc = width;
        this.iYinc = height;
        this.invalidate();
    }

    public int getMin() {
        return this.iMin;
    }

    public int getMax() {
        return this.iMax;
    }

    public int getXinc() {
        return this.iXinc;
    }

    public int getYinc() {
        return this.iYinc;
    }

    public HeatMap() {
        this.iNumTimes = 100;
        this.iNumCells = 10;
        this.iNumColors = 20;
        this.iMin = 25000;
        this.iScale = CMAP.length / (50000 - this.iMin);
        this.iR = this.getDataVector();
        this.setSize(this.iNumTimes * 10 + 100, this.iNumCells * 10);
    }

    private int[][] getDataVector() {
        int[][] r = new int[this.iNumCells][this.iNumTimes];
        int i = 0;
        while (i < this.iNumCells) {
            int j = 0;
            while (j < this.iNumTimes) {
                r[i][j] = 25000 + (int)(25000.0 * Math.random());
                ++j;
            }
            ++i;
        }
        return r;
    }

    private int getDiscrete(int r) {
        int k = 0;
        k = (int)((double)(r - this.iMin) * this.iScale);
        return k;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        int yl = 0;
        int j = 0;
        while (j < this.iNumCells) {
            int xl = 0;
            int i = 0;
            while (i < this.iNumTimes) {
                int discrete = this.getDiscrete(this.iR[j][i]);
                g.setColor(this.getTheColor(discrete));
                g.fillRect(xl, yl, this.iXinc, this.iYinc);
                xl += this.iXinc;
                ++i;
            }
            g.setColor(Color.black);
            g.drawString(this.iLabels[j], xl + 10, yl + this.iYinc);
            yl += this.iYinc;
            ++j;
        }
    }

    private Color getTheColor(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= CMAP.length) {
            index = CMAP.length - 1;
        }
        return CMAP[index];
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("heat map main");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        HeatMap heatmap = new HeatMap();
        f.getContentPane().add("Center", heatmap);
        f.pack();
        f.setSize(new Dimension(550, 200));
        f.setVisible(true);
    }
}

