/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.utils;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class Log
extends JPanel
implements ActionListener {
    public JTextArea iText;
    public JScrollPane iPane;
    public String iTitle;
    protected JFrame iFrame;
    private JFileChooser iFC;
    protected JToolBar iToolBar;
    protected JMenuBar iMenuBar;
    private static final String NL = "\n";
    private static final String SP = " ";
    private static final String SAVEAS = "Save as";

    public Log(String title) {
        this.iTitle = title;
        this.setLayout(new BoxLayout(this, 1));
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        JButton jb1 = new JButton(SAVEAS);
        jb1.addActionListener(this);
        this.iToolBar.add(jb1);
        this.add(this.iToolBar);
        this.iText = new JTextArea(4, 50);
        this.iText.setMargin(new Insets(5, 5, 5, 5));
        this.iText.setEditable(false);
        this.iText.setFont(new Font("Monospaced", 0, 12));
        this.iPane = new JScrollPane(this.iText);
        this.iPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.add(this.iPane);
        this.iFrame = new JFrame(this.iTitle);
        this.iFrame.setJMenuBar(this.createMenuBar());
        this.iFC = new JFileChooser(".");
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    protected void addComboBox(JComboBox jcb) {
        jcb.addActionListener(this);
        this.iToolBar.add(jcb);
    }

    public void append(String s) {
        this.iText.append(String.valueOf(s) + NL);
        this.iText.setCaretPosition(this.iText.getDocument().getLength());
    }

    public void appendx(String s) {
        this.iText.append(s);
    }

    public String getText() {
        return this.iText.getText();
    }

    public void read(File file) {
        try {
            this.iText.read(new FileReader(file), null);
        }
        catch (IOException ioe) {
            this.append("read unsuccessful for file: " + file.toString());
            this.append(ioe.toString());
        }
    }

    public String getTime() {
        return SP + new GregorianCalendar().getTime().toString();
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public void hideMe() {
        this.iFrame.setVisible(false);
    }

    public JFrame getFrame() {
        return this.iFrame;
    }

    protected JMenuBar createMenuBar() {
        this.iMenuBar = new JMenuBar();
        return this.iMenuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String s = e.getActionCommand();
        if (s.equals(SAVEAS) && (returnVal = this.iFC.showSaveDialog(this)) == 0) {
            String dir = this.iFC.getCurrentDirectory().toString();
            String name = this.iFC.getName(this.iFC.getSelectedFile());
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(this.iFC.getSelectedFile()));
                ps.print(this.iText.getText());
                ps.flush();
                ps.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void setLogFont(Font font) {
        this.iText.setFont(font);
        this.iText.setColumns(70);
    }

    public static void main(String[] args) {
    }
}

