/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.volumeview;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import ij.process.StackProcessor;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import ij3d.gui.LUTDialog;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4f;
import org.rhwlab.volumeview.AceUniverse;
import org.rhwlab.volumeview.SubStackMaker;

public class AceExecuter
extends Executer {
    private AceUniverse univ;

    public AceExecuter(AceUniverse univ) {
        super((Image3DUniverse)univ);
        this.univ = univ;
    }

    public void setCalibration(int pixelDepth) {
        Calibration cal = this.univ.getImage().getCalibration();
        cal.pixelDepth = pixelDepth;
        this.univ.getImage().setCalibration(cal);
    }

    public void convertToGray8() {
        new StackConverter(this.univ.getImage()).convertToGray8();
    }

    public void updateTransferFunction() {
        if (AceUniverse.getSettings().containsKey("RedLUT") && AceUniverse.getSettings().containsKey("BlueLUT") && AceUniverse.getSettings().containsKey("GreenLUT") && AceUniverse.getSettings().containsKey("AlphaLUT")) {
            int[] r = (int[])AceUniverse.getSettings().get("RedLUT");
            int[] g = (int[])AceUniverse.getSettings().get("GreenLUT");
            int[] b = (int[])AceUniverse.getSettings().get("BlueLUT");
            int[] a = (int[])AceUniverse.getSettings().get("AlphaLUT");
            this.univ.getContent().setLUT(r, g, b, a);
        }
    }

    public void updateTransparency() {
        if (AceUniverse.getSettings().containsKey("Transparency")) {
            Float f = (Float)AceUniverse.getSettings().get("Transparency");
            this.univ.getContent().setTransparency(f.floatValue());
        }
    }

    public void updateThreshold() {
        if (AceUniverse.getSettings().containsKey("threshold")) {
            Integer i = (Integer)AceUniverse.getSettings().get("threshold");
            this.univ.getContent().setThreshold(i.intValue());
        }
    }

    public void updateDisplayAs() {
        if (AceUniverse.getSettings().containsKey("DisplayAs")) {
            Integer type = (Integer)AceUniverse.getSettings().get("DisplayAs");
            this.univ.getContent().displayAs(type.intValue());
        }
    }

    public void updateWindowLevel() {
        if (AceUniverse.getSettings().containsKey("RangeMin") && AceUniverse.getSettings().containsKey("RangeMax")) {
            Double min = (Double)AceUniverse.getSettings().get("RangeMin");
            Double max = (Double)AceUniverse.getSettings().get("RangeMax");
            this.univ.getImage().setDisplayRange(min.doubleValue(), max.doubleValue());
        }
    }

    public void updateCropZ() {
        if (AceUniverse.getSettings().containsKey("stackFirst") && AceUniverse.getSettings().containsKey("stackLast")) {
            Integer first = (Integer)AceUniverse.getSettings().get("stackFirst");
            Integer last = (Integer)AceUniverse.getSettings().get("stackLast");
            int f = first;
            int l = last;
            String input = String.valueOf(Integer.toString(f)) + "-" + Integer.toString(l);
            System.out.println(input);
            SubStackMaker stackMaker = new SubStackMaker();
            ImagePlus imp = this.univ.getImage();
            this.univ.setImage(stackMaker.makeSubstack(imp, input));
            imp = null;
        }
    }

    public void reverseStack() {
        ImageStack stack = this.univ.getImage().getStack();
        int i = 1;
        while (i <= stack.getSize()) {
            ImageProcessor ip = stack.getProcessor(i);
            ip.flipHorizontal();
            stack.setProcessor(ip, i);
            ++i;
        }
    }

    public void updateZoom() {
        String zoomT;
        if (AceUniverse.getSettings().containsKey("Zoom") && (zoomT = (String)AceUniverse.getSettings().get("Zoom")) != null) {
            this.univ.getZoomTG().setTransform(AceExecuter.t(zoomT));
            this.univ.getViewPlatformTransformer().updateFrontBackClip();
        }
    }

    private static final Transform3D t(String s) {
        String[] sp = s.split(" ");
        float[] f = new float[16];
        int i = 0;
        while (i < sp.length) {
            f[i] = AceExecuter.f(sp[i]);
            ++i;
        }
        return new Transform3D(f);
    }

    private static final float f(String s) {
        return Float.parseFloat(s);
    }

    public void updateTransform() {
        if (AceUniverse.getSettings().containsKey("TransformMatrix")) {
            Matrix4f matrix = new Matrix4f((float[])AceUniverse.getSettings().get("TransformMatrix"));
            this.univ.getContent().setTransform(new Transform3D(matrix));
        }
    }

    public void setROI() {
        if (AceUniverse.getSettings().containsKey("ROI")) {
            Roi roi = (Roi)AceUniverse.getSettings().get("ROI");
            ImagePlus imp = this.univ.getImage();
            ImageStack stack = imp.getStack();
            Rectangle rect = roi.getBoundingRect();
            int left = rect.x;
            int top = rect.y;
            int width = rect.width;
            int height = rect.height;
            StackProcessor sp = new StackProcessor(stack);
            this.univ.getImage().setStack(sp.crop(left, top, width, height));
        }
    }

    public void displayAs(Content c, int type) {
        if (!this.checkSel(c)) {
            return;
        }
        c.displayAs(type);
        Integer integer = new Integer(type);
        AceUniverse.getSettings().put("DisplayAs", integer);
    }

    private final boolean checkSel(Content c) {
        if (c == null) {
            IJ.error((String)"Selection required");
            return false;
        }
        return true;
    }

    public void changeThreshold(final Content c) {
        IJ.getInstance().setVisible(true);
        if (!this.checkSel(c)) {
            return;
        }
        if (c.getImage() == null) {
            IJ.error((String)"The selected object contains no image data,\ntherefore the threshold can't be changed");
            return;
        }
        final ContentInstant ci = c.getCurrent();
        final SliderAdjuster thresh_adjuster = new SliderAdjuster(this){

            @Override
            public final synchronized void setValue(ContentInstant ci, int v) {
                ci.setThreshold(v);
                AceUniverse.getSettings().put("threshold", new Integer(v));
                this.univ.fireContentChanged(c);
            }
        };
        final int oldTr = ci.getThreshold();
        if (c.getType() == 2) {
            GenericDialog gd = new GenericDialog("Adjust threshold ...", (Frame)this.univ.getWindow());
            int old = ci.getThreshold();
            gd.addNumericField("Threshold", (double)old, 0);
            gd.addCheckbox("Apply to all timepoints", true);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int th = (int)gd.getNextNumber();
            th = Math.max(0, th);
            th = Math.min(th, 255);
            if (gd.getNextBoolean()) {
                c.setThreshold(th);
                AceUniverse.getSettings().put("threshold", new Integer(th));
            } else {
                ci.setThreshold(th);
                AceUniverse.getSettings().put("threshold", new Integer(th));
            }
            this.univ.fireContentChanged(c);
            AceExecuter.record((String)"setThreshold", (String[])new String[]{Integer.toString(th)});
            return;
        }
        final GenericDialog gd = new GenericDialog("Adjust threshold...");
        gd.addSlider("Threshold", 0.0, 255.0, (double)oldTr);
        ((Scrollbar)gd.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!thresh_adjuster.go) {
                    thresh_adjuster.start();
                }
                thresh_adjuster.exec(e.getValue(), ci, AceExecuter.this.univ);
            }
        });
        gd.addCheckbox("Apply to all timepoints", true);
        final Checkbox aBox = (Checkbox)gd.getCheckboxes().get(0);
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                IJ.getInstance().setVisible(false);
                try {
                    if (gd.wasCanceled()) {
                        ci.setThreshold(oldTr);
                        AceUniverse.getSettings().put("threshold", new Integer(oldTr));
                        AceExecuter.this.univ.fireContentChanged(c);
                        return;
                    }
                    if (aBox.getState()) {
                        c.setThreshold(ci.getThreshold());
                        AceUniverse.getSettings().put("threshold", new Integer(ci.getThreshold()));
                    }
                    AceExecuter.record((String)"setThreshold", (String[])new String[]{Integer.toString(c.getThreshold())});
                }
                finally {
                    if (thresh_adjuster != null) {
                        thresh_adjuster.quit();
                    }
                }
            }
        });
        gd.showDialog();
        IJ.getInstance().setLocation(5000, 5000);
    }

    public void adjustLUTs(final Content c) {
        IJ.getInstance().setVisible(true);
        if (!this.checkSel(c)) {
            return;
        }
        final int[] r = new int[256];
        c.getRedLUT(r);
        final int[] g = new int[256];
        c.getGreenLUT(g);
        final int[] b = new int[256];
        c.getBlueLUT(b);
        final int[] a = new int[256];
        c.getAlphaLUT(a);
        LUTDialog ld = new LUTDialog(r, g, b, a);
        ld.addCtrlHint();
        ld.addListener(new LUTDialog.Listener(){

            public void applied() {
                c.setLUT(r, g, b, a);
                AceUniverse.getSettings().put("RedLUT", r);
                AceUniverse.getSettings().put("GreenLUT", g);
                AceUniverse.getSettings().put("BlueLUT", b);
                AceUniverse.getSettings().put("AlphaLUT", a);
                AceExecuter.this.univ.fireContentChanged(c);
            }
        });
        ld.addWindowListener((WindowListener)new FrameListener());
        ld.showDialog();
        IJ.getInstance().setLocation(5000, 5000);
    }

    public void changeTransparency(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final ContentInstant ci = c.getCurrent();
        final SliderAdjuster transp_adjuster = new SliderAdjuster(this){

            @Override
            public final synchronized void setValue(ContentInstant ci, int v) {
                ci.setTransparency((float)v / 100.0f);
                Float f = new Float((float)v / 100.0f);
                AceUniverse.getSettings().put("Transparency", f);
                this.univ.fireContentChanged(c);
            }
        };
        final GenericDialog gd = new GenericDialog("Adjust transparency ...", (Frame)this.univ.getWindow());
        final int oldTr = (int)(ci.getTransparency() * 100.0f);
        gd.addSlider("Transparency", 0.0, 100.0, (double)oldTr);
        gd.addCheckbox("Apply to all timepoints", true);
        ((Scrollbar)gd.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!transp_adjuster.go) {
                    transp_adjuster.start();
                }
                transp_adjuster.exec(e.getValue(), ci, AceExecuter.this.univ);
            }
        });
        ((TextField)gd.getNumericFields().get(0)).addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                if (!transp_adjuster.go) {
                    transp_adjuster.start();
                }
                TextField input = (TextField)e.getSource();
                String text = input.getText();
                try {
                    int value = Integer.parseInt(text);
                    transp_adjuster.exec(value, ci, AceExecuter.this.univ);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Checkbox aBox = (Checkbox)gd.getCheckboxes().get(0);
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (transp_adjuster != null) {
                    transp_adjuster.quit();
                }
                if (gd.wasCanceled()) {
                    float newTr = (float)oldTr / 100.0f;
                    ci.setTransparency(newTr);
                    Float f = new Float(newTr);
                    AceUniverse.getSettings().put("Transparency", f);
                    AceExecuter.this.univ.fireContentChanged(c);
                    return;
                }
                if (aBox.getState()) {
                    c.setTransparency(ci.getTransparency());
                    Float f = new Float(ci.getTransparency());
                    AceUniverse.getSettings().put("Transparency", f);
                }
                AceExecuter.record((String)"setTransparency", (String[])new String[]{Float.toString((float)((Scrollbar)gd.getSliders().get(0)).getValue() / 100.0f)});
            }
        });
        gd.showDialog();
    }

    class FrameListener
    extends WindowAdapter {
        FrameListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            IJ.getInstance().setVisible(false);
        }
    }

    private abstract class SliderAdjuster
    extends Thread {
        boolean go;
        int newV;
        ContentInstant content;
        Image3DUniverse univ;
        final Object lock;

        SliderAdjuster() {
            super("VIB-SliderAdjuster");
            this.go = false;
            this.lock = new Object();
            this.setPriority(5);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exec(int newV, ContentInstant content, Image3DUniverse univ) {
            Object object = this.lock;
            synchronized (object) {
                this.newV = newV;
                this.content = content;
                this.univ = univ;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.go = false;
            SliderAdjuster sliderAdjuster = this;
            synchronized (sliderAdjuster) {
                this.notify();
            }
        }

        protected abstract void setValue(ContentInstant var1, int var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.go = true;
            while (this.go) {
                try {
                    ContentInstant c;
                    if (this.content == null) {
                        SliderAdjuster sliderAdjuster = this;
                        synchronized (sliderAdjuster) {
                            this.wait();
                        }
                    }
                    if (!this.go) {
                        return;
                    }
                    int transp = 0;
                    Object object = this.lock;
                    synchronized (object) {
                        c = this.content;
                        transp = this.newV;
                        Image3DUniverse u = this.univ;
                    }
                    if (c != null) {
                        this.setValue(c, transp);
                    }
                    object = this.lock;
                    synchronized (object) {
                        if (c == this.content) {
                            this.content = null;
                            this.univ = null;
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

