/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.volumeview;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.process.ImageProcessor;

public class SubStackMaker {
    private static boolean delete = false;

    public ImagePlus makeSubstack(ImagePlus imp, String userInput) {
        String stackTitle = "Substack (" + userInput + ")";
        if (stackTitle.length() > 25) {
            int idxA = stackTitle.indexOf(",", 18);
            int idxB = stackTitle.lastIndexOf(",");
            if (idxA >= 1 && idxB >= 1) {
                String strA = stackTitle.substring(0, idxA);
                String strB = stackTitle.substring(idxB + 1);
                stackTitle = String.valueOf(strA) + ", ... " + strB;
            }
        }
        ImagePlus imp2 = null;
        try {
            int idx1 = userInput.indexOf("-");
            if (idx1 >= 1) {
                String rngStart = userInput.substring(0, idx1);
                String rngEnd = userInput.substring(idx1 + 1);
                Integer obj = new Integer(rngStart);
                int first = obj;
                int inc = 1;
                int idx2 = rngEnd.indexOf("-");
                if (idx2 >= 1) {
                    String rngEndAndInc = rngEnd;
                    rngEnd = rngEndAndInc.substring(0, idx2);
                    String rngInc = rngEndAndInc.substring(idx2 + 1);
                    obj = new Integer(rngInc);
                    inc = obj;
                }
                obj = new Integer(rngEnd);
                int last = obj;
                imp2 = this.stackRange(imp, first, last, inc, stackTitle);
            } else {
                int count = 1;
                int j = 0;
                while (j < userInput.length()) {
                    char ch = Character.toLowerCase(userInput.charAt(j));
                    if (ch == ',') {
                        ++count;
                    }
                    ++j;
                }
                int[] numList = new int[count];
                int i = 0;
                while (i < count) {
                    Integer obj;
                    String num;
                    int idx2 = userInput.indexOf(",");
                    if (idx2 > 0) {
                        num = userInput.substring(0, idx2);
                        obj = new Integer(num);
                        numList[i] = obj;
                        userInput = userInput.substring(idx2 + 1);
                    } else {
                        num = userInput;
                        obj = new Integer(num);
                        numList[i] = obj;
                    }
                    ++i;
                }
                imp2 = this.stackList(imp, count, numList, stackTitle);
            }
        }
        catch (Exception e) {
            IJ.error((String)"Substack Maker", (String)("Invalid input string:        \n \n  \"" + userInput + "\""));
        }
        return imp2;
    }

    ImagePlus stackList(ImagePlus imp, int count, int[] numList, String stackTitle) throws Exception {
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        Roi roi = imp.getRoi();
        int i = 0;
        int j = 0;
        while (i < count) {
            int currSlice = numList[i] - j;
            ImageProcessor ip2 = stack.getProcessor(currSlice);
            ip2.setRoi(roi);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
            }
            stack2.addSlice(stack.getSliceLabel(currSlice), ip2);
            if (delete) {
                stack.deleteSlice(currSlice);
                ++j;
            }
            ++i;
        }
        if (delete) {
            imp.setStack(stack);
            ImageWindow win = imp.getWindow();
            StackWindow swin = (StackWindow)win;
            swin.updateSliceSelector();
        }
        ImagePlus impSubstack = imp.createImagePlus();
        impSubstack.setStack(stackTitle, stack2);
        return impSubstack;
    }

    ImagePlus stackRange(ImagePlus imp, int first, int last, int inc, String title) throws Exception {
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        Roi roi = imp.getRoi();
        int i = first;
        int j = 0;
        while (i <= last) {
            int currSlice = i - j;
            ImageProcessor ip2 = stack.getProcessor(currSlice);
            ip2.setRoi(roi);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
            }
            stack2.addSlice(stack.getSliceLabel(currSlice), ip2);
            if (delete) {
                stack.deleteSlice(currSlice);
                ++j;
            }
            i += inc;
        }
        if (delete) {
            imp.setStack(stack);
            ImageWindow win = imp.getWindow();
            StackWindow swin = (StackWindow)win;
            swin.updateSliceSelector();
        }
        ImagePlus substack = imp.createImagePlus();
        substack.setStack(title, stack2);
        substack.setCalibration(imp.getCalibration());
        return substack;
    }
}

