/*
 * Decompiled with CFR 0.152.
 */
package wormguides;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import wormguides.model.TableLineageData;

/*
 * Exception performing whole class analysis ignored.
 */
public class AceTreeLoader {
    private static ArrayList<String> allCellNames = new ArrayList();
    private static final String ENTRY_PREFIX = "wormguides/model/nuclei_files/";
    private static final int TOKEN_ARRAY_SIZE = 21;
    private static final int VALID = 1;
    private static final int XCOR = 5;
    private static final int YCOR = 6;
    private static final int ZCOR = 7;
    private static final int DIAMETER = 8;
    private static final int IDENTITY = 9;

    public static TableLineageData loadNucFiles(String jarPath) {
        TableLineageData tld = new TableLineageData(allCellNames);
        try {
            JarFile jarFile = new JarFile(new File(jarPath));
            Enumeration<JarEntry> entries = jarFile.entries();
            int time = 0;
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("wormguides/model/nuclei_files/")) continue;
                InputStream input = jarFile.getInputStream(entry);
                AceTreeLoader.process((TableLineageData)tld, (int)time++, (InputStream)input);
            }
            jarFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return tld;
    }

    private static void process(TableLineageData tld, int time, InputStream input) throws IOException {
        String line;
        tld.addFrame();
        InputStreamReader isr = new InputStreamReader(input);
        BufferedReader reader = new BufferedReader(isr);
        while ((line = reader.readLine()) != null) {
            String[] tokens = new String[21];
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            int k = 0;
            while (tokenizer.hasMoreTokens()) {
                tokens[k++] = tokenizer.nextToken().trim();
            }
            int valid = Integer.parseInt(tokens[1]);
            if (valid != 1) continue;
            AceTreeLoader.makeNucleus((TableLineageData)tld, (int)time, (String[])tokens);
        }
        reader.close();
    }

    private static void makeNucleus(TableLineageData tld, int time, String[] tokens) {
        try {
            String name = tokens[9];
            int x = Integer.parseInt(tokens[5]);
            int y = Integer.parseInt(tokens[6]);
            int z = (int)Math.round(Double.parseDouble(tokens[7]));
            int diameter = Integer.parseInt(tokens[8]);
            tld.addNucleus(time, name, x, y, z, diameter);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Incorrect format in nucleus file for time " + time + ".");
        }
    }

    public static boolean isLineageName(String name) {
        return allCellNames.contains(name);
    }
}

