/*
 * Decompiled with CFR 0.152.
 */
package wormguides;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import wormguides.AceTreeLoader;
import wormguides.ImageLoader;
import wormguides.Layers;
import wormguides.Search;
import wormguides.SearchType;
import wormguides.URLLoader;
import wormguides.model.ColorRule;
import wormguides.model.LineageData;
import wormguides.model.LineageTree;
import wormguides.model.PartsList;
import wormguides.model.TableLineageData;
import wormguides.view.AboutPane;
import wormguides.view.TreePane;
import wormguides.view.URLLoadWarningDialog;
import wormguides.view.URLLoadWindow;
import wormguides.view.URLWindow;
import wormguides.view.Window3DSubScene;

public class RootLayoutController
implements Initializable {
    private Stage aboutStage;
    private Stage treeStage;
    private Stage urlStage;
    private Stage urlLoadStage;
    private URLWindow urlWindow;
    private URLLoadWindow urlLoadWindow;
    private URLLoadWarningDialog warning;
    private Window3DSubScene window3D;
    private SubScene subscene;
    private DoubleProperty subsceneWidth;
    private DoubleProperty subsceneHeight;
    @FXML
    private BorderPane rootBorderPane;
    @FXML
    private BorderPane displayPanel;
    @FXML
    private AnchorPane modelAnchorPane;
    @FXML
    private ScrollPane infoPane;
    @FXML
    private Button backwardButton;
    @FXML
    private Button forwardButton;
    @FXML
    private Button playButton;
    @FXML
    private Label timeLabel;
    @FXML
    private Label totalNucleiLabel;
    @FXML
    private Slider timeSlider;
    @FXML
    private Button zoomInButton;
    @FXML
    private Button zoomOutButton;
    private Search search;
    @FXML
    private TextField searchField;
    private BooleanProperty clearSearchField;
    @FXML
    private ListView<String> searchResultsListView;
    @FXML
    private RadioButton sysRadioBtn;
    @FXML
    private RadioButton funRadioBtn;
    @FXML
    private RadioButton desRadioBtn;
    @FXML
    private RadioButton genRadioBtn;
    private ToggleGroup typeToggleGroup;
    @FXML
    private CheckBox cellTick;
    @FXML
    private CheckBox ancestorTick;
    @FXML
    private CheckBox descendantTick;
    @FXML
    private Label descendantLabel;
    @FXML
    private AnchorPane colorPickerPane;
    @FXML
    private ColorPicker colorPicker;
    private TreeItem<String> lineageTreeRoot;
    private StringProperty selectedName;
    private Layers layers;
    @FXML
    private ListView<ColorRule> colorRulesListView;
    @FXML
    private Button addSearchBtn;
    @FXML
    private Slider opacitySlider;
    @FXML
    private Text cellName;
    @FXML
    private Text cellDescription;
    private URLLoader urlLoader;
    private ImageView playIcon;
    private ImageView pauseIcon;
    private IntegerProperty time;
    private IntegerProperty totalNuclei;
    private BooleanProperty playingMovie;
    private static final String JAR_NAME = "WormGUIDES.jar";

    @FXML
    public void menuCloseAction() {
        System.out.println("exiting...");
        System.exit(0);
    }

    @FXML
    public void menuAboutAction() {
        if (this.aboutStage == null) {
            this.aboutStage = new Stage();
            this.aboutStage.setScene(new Scene((Parent)new AboutPane()));
            this.aboutStage.setTitle("About WormGUIDES");
            this.aboutStage.initModality(Modality.NONE);
            this.aboutStage.setHeight(400.0);
            this.aboutStage.setWidth(300.0);
            this.aboutStage.setResizable(false);
        }
        this.aboutStage.show();
    }

    @FXML
    public void viewTreeAction() {
        if (this.treeStage == null) {
            this.treeStage = new Stage();
            this.treeStage.setScene(new Scene((Parent)new TreePane(this.lineageTreeRoot)));
            this.treeStage.setTitle("LineageTree");
            this.treeStage.initModality(Modality.NONE);
        }
        this.treeStage.show();
    }

    @FXML
    public void generateURLAction() {
        if (this.urlStage == null) {
            this.urlStage = new Stage();
            this.urlWindow = new URLWindow();
            this.urlWindow.setScene(this.window3D);
            this.urlWindow.getCloseButton().setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.urlStage.setScene(new Scene((Parent)this.urlWindow));
            this.urlStage.setTitle("URLs");
            this.urlStage.setResizable(false);
            this.urlStage.initModality(Modality.NONE);
        }
        this.urlWindow.resetURLs();
        this.urlStage.show();
    }

    @FXML
    public void loadURLAction() {
        if (this.urlLoadStage == null) {
            this.urlLoadStage = new Stage();
            this.urlLoadWindow = new URLLoadWindow();
            this.urlLoadWindow.getLoadButton().setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.urlLoadWindow.getCancelButton().setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.urlLoadStage.setScene(new Scene((Parent)this.urlLoadWindow));
            this.urlLoadStage.setTitle("Load URL");
            this.urlLoadStage.setResizable(false);
            this.urlLoadStage.initModality(Modality.NONE);
        }
        this.urlLoadWindow.clearField();
        this.urlLoadStage.show();
    }

    public void init3DWindow(LineageData data) {
        this.window3D = new Window3DSubScene(this.modelAnchorPane.prefWidth(-1.0), this.modelAnchorPane.prefHeight(-1.0), data);
        this.subscene = this.window3D.getSubScene();
        this.modelAnchorPane.getChildren().add((Object)this.subscene);
    }

    private void getPropertiesFrom3DWindow() {
        this.time = this.window3D.getTimeProperty();
        this.window3D.getZoomProperty();
        this.totalNuclei = this.window3D.getTotalNucleiProperty();
        this.playingMovie = this.window3D.getPlayingMovieProperty();
        this.selectedName = this.window3D.getSelectedName();
    }

    private void addListeners() {
        this.time.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.timeSlider.valueProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.backwardButton.setOnAction(this.window3D.getBackwardButtonListener());
        this.forwardButton.setOnAction(this.window3D.getForwardButtonListener());
        this.zoomOutButton.setOnAction(this.window3D.getZoomOutButtonListener());
        this.zoomInButton.setOnAction(this.window3D.getZoomInButtonListener());
        this.searchField.textProperty().addListener(this.window3D.getSearchFieldListener());
        this.searchResultsListView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchResultsListView.selectionModelProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectedName.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.opacitySlider.valueProperty().addListener(this.window3D.getOthersOpacityListener());
        this.window3D.addListenerToOpacitySlider(this.opacitySlider);
    }

    private void setSelectedInfo(String name) {
        String functionalName;
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.indexOf("(") != -1) {
            name = name.substring(0, name.indexOf(" "));
        }
        if ((functionalName = PartsList.getFunctionalNameByLineageName((String)name)) == null) {
            this.cellName.setText(name);
            this.cellDescription.setText("");
        } else {
            this.cellName.setText(String.valueOf(name) + " (" + functionalName + ")");
            this.cellDescription.setText(PartsList.getDescriptionByFunctionalName((String)functionalName));
        }
    }

    private void sizeSubscene() {
        this.subsceneWidth = new SimpleDoubleProperty();
        this.subsceneWidth.bind((ObservableValue)this.modelAnchorPane.widthProperty());
        this.subsceneHeight = new SimpleDoubleProperty();
        this.subsceneHeight.bind((ObservableValue)this.modelAnchorPane.heightProperty().subtract(33));
        AnchorPane.setTopAnchor((Node)this.subscene, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.subscene, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.subscene, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.subscene, (Double)33.0);
        this.subscene.widthProperty().bind((ObservableValue)this.subsceneWidth);
        this.subscene.heightProperty().bind((ObservableValue)this.subsceneHeight);
        this.subscene.setManaged(false);
    }

    private void sizeInfoPane() {
        this.infoPane.prefHeightProperty().bind((ObservableValue)this.displayPanel.heightProperty().divide(7));
        this.cellName.wrappingWidthProperty().bind((ObservableValue)this.infoPane.widthProperty().subtract(15));
        this.cellDescription.wrappingWidthProperty().bind((ObservableValue)this.infoPane.widthProperty().subtract(15));
    }

    private void setLabels() {
        this.time.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.timeLabel.setText("Time " + this.makePaddedTime(this.time.get()));
        this.timeLabel.toFront();
        this.totalNuclei.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.totalNucleiLabel.setText(String.valueOf(this.totalNuclei.get()) + " Nuclei");
        this.totalNucleiLabel.toFront();
    }

    private String makePaddedTime(int time) {
        if (time < 10) {
            return "00" + time;
        }
        if (time < 100) {
            return "0" + time;
        }
        return "" + time;
    }

    public void setIcons() {
        this.backwardButton.setGraphic((Node)ImageLoader.getBackwardIcon());
        this.forwardButton.setGraphic((Node)ImageLoader.getForwardIcon());
        this.zoomInButton.setGraphic((Node)ImageLoader.getPlusIcon());
        this.zoomOutButton.setGraphic((Node)ImageLoader.getMinusIcon());
        this.playIcon = ImageLoader.getPlayIcon();
        this.pauseIcon = ImageLoader.getPauseIcon();
        this.playButton.setGraphic((Node)this.playIcon);
        this.playButton.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setSlidersProperties() {
        this.timeSlider.setMin(1.0);
        this.timeSlider.setMax((double)this.window3D.getEndTime());
        this.timeSlider.setValue((double)this.window3D.getStartTime());
        this.opacitySlider.setMin(0.0);
        this.opacitySlider.setMax(100.0);
        this.opacitySlider.setValue(100.0);
    }

    private void initSearch() {
        this.search = new Search();
        this.typeToggleGroup.selectedToggleProperty().addListener(this.search.getTypeToggleListener());
        this.cellTick.selectedProperty().addListener(this.search.getCellTickListner());
        this.ancestorTick.selectedProperty().addListener(this.search.getAncestorTickListner());
        this.descendantTick.selectedProperty().addListener(this.search.getDescendantTickListner());
        this.colorPicker.setOnAction(this.search.getColorPickerListener());
        this.addSearchBtn.setOnAction(this.search.getAddButtonListener());
        this.clearSearchField = new SimpleBooleanProperty(false);
        this.search.setClearSearchFieldProperty(this.clearSearchField);
        this.clearSearchField.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchField.textProperty().addListener(this.search.getTextFieldListener());
    }

    private void initLayers() {
        this.layers = new Layers(this.colorRulesListView);
    }

    private void initPartsList() {
        new PartsList();
    }

    private void initLineageTree(ArrayList<String> allCellNames) {
        if (allCellNames != null) {
            new LineageTree(allCellNames.toArray(new String[allCellNames.size()]));
            this.lineageTreeRoot = LineageTree.getRoot();
        } else {
            System.out.println("null cell names passed to lineage tree init");
        }
    }

    private void initToggleGroup() {
        this.typeToggleGroup = new ToggleGroup();
        this.sysRadioBtn.setToggleGroup(this.typeToggleGroup);
        this.sysRadioBtn.setUserData((Object)SearchType.SYSTEMATIC);
        this.funRadioBtn.setToggleGroup(this.typeToggleGroup);
        this.funRadioBtn.setUserData((Object)SearchType.FUNCTIONAL);
        this.desRadioBtn.setToggleGroup(this.typeToggleGroup);
        this.desRadioBtn.setUserData((Object)SearchType.DESCRIPTION);
        this.genRadioBtn.setToggleGroup(this.typeToggleGroup);
        this.genRadioBtn.setUserData((Object)SearchType.GENE);
        this.typeToggleGroup.selectedToggleProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sysRadioBtn.setSelected(true);
    }

    private void assertFXMLNodes() {
        assert (this.rootBorderPane != null);
        assert (this.modelAnchorPane != null);
        assert (this.displayPanel != null);
        assert (this.infoPane != null);
        assert (this.timeSlider != null);
        assert (this.backwardButton != null);
        assert (this.forwardButton != null);
        assert (this.playButton != null);
        assert (this.timeLabel != null);
        assert (this.totalNucleiLabel != null);
        assert (this.zoomInButton != null);
        assert (this.zoomOutButton != null);
        assert (this.searchField != null);
        assert (this.searchResultsListView != null);
        assert (this.sysRadioBtn != null);
        assert (this.desRadioBtn != null);
        assert (this.genRadioBtn != null);
        assert (this.cellTick != null);
        assert (this.ancestorTick != null);
        assert (this.descendantTick != null);
        assert (this.descendantLabel != null);
        assert (this.colorPickerPane != null);
        assert (this.colorPicker != null);
        assert (this.colorRulesListView != null);
        assert (this.addSearchBtn != null);
        assert (this.cellName != null);
        assert (this.cellDescription != null);
        assert (this.opacitySlider != null);
    }

    public void initialize(URL url, ResourceBundle bundle) {
        if (bundle == null) {
            System.out.println("null bundle");
            TableLineageData data = AceTreeLoader.loadNucFiles((String)JAR_NAME);
            this.initializeWithLineageData((LineageData)data);
        } else {
            System.out.println("initializing with NucleiMgrAdapter...");
            LineageData data = (LineageData)bundle.getObject("lineageData");
            this.initializeWithLineageData(data);
        }
    }

    public void initializeWithLineageData(LineageData data) {
        for (String name : data.getAllCellNames()) {
            System.out.println("blah");
            System.out.println(name);
        }
        this.initPartsList();
        this.initLineageTree(data.getAllCellNames());
        this.assertFXMLNodes();
        this.initToggleGroup();
        this.initLayers();
        this.init3DWindow(data);
        this.getPropertiesFrom3DWindow();
        this.setSlidersProperties();
        this.initSearch();
        Search.setActiveLineageNames((ArrayList)data.getAllCellNames());
        this.search.setRulesList(this.layers.getRulesList());
        this.window3D.setRulesList(this.layers.getRulesList());
        this.window3D.setSearchResultsList(this.search.getSearchResultsList());
        this.searchResultsListView.setItems(this.search.getSearchResultsList());
        this.window3D.setResultsUpdateService(this.search.getResultsUpdateService());
        this.window3D.setGeneResultsUpdated(this.search.getGeneResultsUpdated());
        this.search.addDefaultRules();
        this.addListeners();
        this.setIcons();
        this.setLabels();
        this.sizeSubscene();
        this.sizeInfoPane();
    }

    static /* synthetic */ Stage access$0(RootLayoutController rootLayoutController) {
        return rootLayoutController.urlStage;
    }

    static /* synthetic */ URLLoadWarningDialog access$1(RootLayoutController rootLayoutController) {
        return rootLayoutController.warning;
    }

    static /* synthetic */ void access$2(RootLayoutController rootLayoutController, URLLoadWarningDialog uRLLoadWarningDialog) {
        rootLayoutController.warning = uRLLoadWarningDialog;
    }

    static /* synthetic */ Stage access$3(RootLayoutController rootLayoutController) {
        return rootLayoutController.urlLoadStage;
    }

    static /* synthetic */ URLLoader access$4(RootLayoutController rootLayoutController) {
        return rootLayoutController.urlLoader;
    }

    static /* synthetic */ Window3DSubScene access$5(RootLayoutController rootLayoutController) {
        return rootLayoutController.window3D;
    }

    static /* synthetic */ void access$6(RootLayoutController rootLayoutController, URLLoader uRLLoader) {
        rootLayoutController.urlLoader = uRLLoader;
    }

    static /* synthetic */ URLLoadWindow access$7(RootLayoutController rootLayoutController) {
        return rootLayoutController.urlLoadWindow;
    }

    static /* synthetic */ Slider access$8(RootLayoutController rootLayoutController) {
        return rootLayoutController.timeSlider;
    }

    static /* synthetic */ IntegerProperty access$9(RootLayoutController rootLayoutController) {
        return rootLayoutController.time;
    }

    static /* synthetic */ Button access$10(RootLayoutController rootLayoutController) {
        return rootLayoutController.playButton;
    }

    static /* synthetic */ ImageView access$11(RootLayoutController rootLayoutController) {
        return rootLayoutController.playIcon;
    }

    static /* synthetic */ BooleanProperty access$12(RootLayoutController rootLayoutController) {
        return rootLayoutController.playingMovie;
    }

    static /* synthetic */ void access$13(RootLayoutController rootLayoutController, String string) {
        rootLayoutController.setSelectedInfo(string);
    }

    static /* synthetic */ StringProperty access$14(RootLayoutController rootLayoutController) {
        return rootLayoutController.selectedName;
    }

    static /* synthetic */ Label access$15(RootLayoutController rootLayoutController) {
        return rootLayoutController.timeLabel;
    }

    static /* synthetic */ String access$16(RootLayoutController rootLayoutController, int n) {
        return rootLayoutController.makePaddedTime(n);
    }

    static /* synthetic */ Label access$17(RootLayoutController rootLayoutController) {
        return rootLayoutController.totalNucleiLabel;
    }

    static /* synthetic */ ImageView access$18(RootLayoutController rootLayoutController) {
        return rootLayoutController.pauseIcon;
    }

    static /* synthetic */ TextField access$19(RootLayoutController rootLayoutController) {
        return rootLayoutController.searchField;
    }

    static /* synthetic */ BooleanProperty access$20(RootLayoutController rootLayoutController) {
        return rootLayoutController.clearSearchField;
    }

    static /* synthetic */ CheckBox access$21(RootLayoutController rootLayoutController) {
        return rootLayoutController.descendantTick;
    }

    static /* synthetic */ Label access$22(RootLayoutController rootLayoutController) {
        return rootLayoutController.descendantLabel;
    }
}

