/*
 * Decompiled with CFR 0.152.
 */
package wormguides;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import wormguides.Search;
import wormguides.SearchOption;
import wormguides.SearchType;
import wormguides.model.ColorRule;
import wormguides.view.Window3DSubScene;

public class URLLoader {
    private Window3DSubScene window3D;
    private ObservableList<ColorRule> rulesList;

    public URLLoader(Window3DSubScene window3D) {
        this.window3D = window3D;
        this.rulesList = window3D.getObservableRulesList();
    }

    public void parseURL(String url) {
        if (this.window3D == null) {
            return;
        }
        if (!url.contains("testurlscript?/")) {
            return;
        }
        String[] args = url.split("/");
        ArrayList<String> ruleArgs = new ArrayList<String>();
        ArrayList<String> viewArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("set")) {
                ++i;
                while (!args[i].equals("view")) {
                    ruleArgs.add(args[i].trim());
                    ++i;
                }
                ++i;
                while (!(args[i].equals("iOS") || args[i].equals("Android") || args[i].equals("browser"))) {
                    viewArgs.add(args[i]);
                    ++i;
                }
                continue;
            }
            ++i;
        }
        this.parseRules(ruleArgs);
        this.parseViewArgs(viewArgs);
    }

    private void parseRules(ArrayList<String> rules) {
        this.rulesList.clear();
        for (String rule : rules) {
            ArrayList<String> types = new ArrayList<String>();
            StringBuilder sb = new StringBuilder(rule);
            try {
                int i;
                int i2;
                if (sb.indexOf("-s") > -1) {
                    types.add("-s");
                    i2 = sb.indexOf("-s");
                    sb.replace(i2, i2 + 2, "");
                }
                if (sb.indexOf("-n") > -1) {
                    types.add("-n");
                    i2 = sb.indexOf("-n");
                    sb.replace(i2, i2 + 2, "");
                }
                if (sb.indexOf("-d") > -1) {
                    types.add("-d");
                    i2 = sb.indexOf("-d");
                    sb.replace(i2, i2 + 2, "");
                }
                if (sb.indexOf("-g") > -1) {
                    types.add("-g");
                    i2 = sb.indexOf("-g");
                    sb.replace(i2, i2 + 2, "");
                }
                String colorString = sb.substring(sb.indexOf("+") + 6, sb.length());
                ArrayList<SearchOption> options = new ArrayList<SearchOption>();
                if (sb.indexOf("%3C") > -1) {
                    options.add(SearchOption.ANCESTOR);
                    i = sb.indexOf("%3C");
                    sb.replace(i, i + 3, "");
                }
                if (sb.indexOf("$") > -1) {
                    options.add(SearchOption.CELL);
                    i = sb.indexOf("$");
                    sb.replace(i, i + 1, "");
                }
                if (rule.contains("%3E")) {
                    options.add(SearchOption.DESCENDANT);
                    i = sb.indexOf("%3E");
                    sb.replace(i, i + 3, "");
                }
                String name = sb.substring(0, sb.indexOf("+"));
                if (types.contains("-s")) {
                    Search.addColorRule((SearchType)SearchType.SYSTEMATIC, (String)name, (Color)Color.web((String)colorString), options);
                }
                if (types.contains("-n")) {
                    Search.addColorRule((SearchType)SearchType.FUNCTIONAL, (String)name, (Color)Color.web((String)colorString), options);
                }
                if (types.contains("-d")) {
                    Search.addColorRule((SearchType)SearchType.DESCRIPTION, (String)name, (Color)Color.web((String)colorString), options);
                }
                if (!types.contains("-g")) continue;
                Search.addColorRule((SearchType)SearchType.GENE, (String)name, (Color)Color.web((String)colorString), options);
            }
            catch (StringIndexOutOfBoundsException e) {
                System.out.println("invalid color rule format");
                e.printStackTrace();
            }
        }
    }

    private void parseViewArgs(ArrayList<String> viewArgs) {
        block36: for (String arg : viewArgs) {
            String[] tokens = arg.split("=");
            if (tokens.length == 0) continue;
            switch (tokens[0]) {
                case "time": {
                    try {
                        this.window3D.setTime(Integer.parseInt(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing time variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "rX": {
                    try {
                        this.window3D.setRotationX(Double.parseDouble(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing rotation variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "rY": {
                    try {
                        this.window3D.setRotationY(Double.parseDouble(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing rotation variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "rZ": {
                    try {
                        this.window3D.setRotationZ(Double.parseDouble(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing rotation variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "tX": {
                    try {
                        this.window3D.setTranslationX(Double.parseDouble(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing translation variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "tY": {
                    try {
                        this.window3D.setTranslationY(Double.parseDouble(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing translation variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "scale": {
                    try {
                        this.window3D.setScale(Double.parseDouble(tokens[1]));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing scale variable");
                        nfe.printStackTrace();
                    }
                    continue block36;
                }
                case "dim": {
                    try {
                        this.window3D.setOthersVisibility(Double.parseDouble(tokens[1]));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("error in parsing dim variable");
                        nfe.printStackTrace();
                    }
                }
            }
        }
    }
}

