/*
 * Decompiled with CFR 0.152.
 */
package wormguides.model;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import wormguides.ImageLoader;
import wormguides.SearchOption;
import wormguides.SearchType;
import wormguides.model.LineageTree;
import wormguides.model.RuleInfoPacket;
import wormguides.view.AppFont;

public class ColorRule {
    private Stage editStage;
    private String searchedText;
    private String searchedTextLowerCase;
    private ArrayList<SearchOption> options;
    private SearchType type;
    private BooleanProperty ruleChanged;
    private boolean visible;
    private Color color;
    private ImageView eyeIcon;
    private ImageView eyeInvertIcon;
    private ArrayList<String> cells;
    private boolean cellsSet;
    private HBox hbox = new HBox();
    private Label label = new Label();
    private Region region = new Region();
    private Button colorBtn = new Button();
    private Button editBtn = new Button();
    private Button visibleBtn = new Button();
    private Button deleteBtn = new Button();
    private Tooltip toolTip = new Tooltip();
    private RuleInfoPacket infoPacket;
    private static final int UI_SIDE_LENGTH = 22;

    public ColorRule(String searched, Color color) {
        this(searched, color, new SearchOption[]{SearchOption.CELL, SearchOption.DESCENDANT});
    }

    public ColorRule(String searched, Color color, SearchOption ... options) {
        this(searched, color, new ArrayList<SearchOption>(Arrays.asList(options)), SearchType.SYSTEMATIC);
    }

    public ColorRule(String searched, Color color, ArrayList<SearchOption> options, SearchType type) {
        this.setSearchedText(searched);
        this.setColor(color);
        this.cells = new ArrayList();
        this.cellsSet = false;
        this.setOptions(options);
        SimpleDoubleProperty sideLength = new SimpleDoubleProperty(22.0);
        this.hbox.setSpacing(2.0);
        this.label.setFont(AppFont.getFont());
        this.label.prefHeightProperty().bind((ObservableValue)sideLength);
        this.label.setMaxWidth(150.0);
        this.label.textOverrunProperty().set((Object)OverrunStyle.ELLIPSIS);
        this.resetLabel();
        this.colorBtn.prefHeightProperty().bind((ObservableValue)sideLength);
        this.colorBtn.prefWidthProperty().bind((ObservableValue)sideLength);
        this.colorBtn.maxHeightProperty().bind((ObservableValue)sideLength);
        this.colorBtn.maxWidthProperty().bind((ObservableValue)sideLength);
        this.colorBtn.minHeightProperty().bind((ObservableValue)sideLength);
        this.colorBtn.minWidthProperty().bind((ObservableValue)sideLength);
        this.colorBtn.setGraphicTextGap(0.0);
        this.setColorButton(color);
        this.editBtn.prefHeightProperty().bind((ObservableValue)sideLength);
        this.editBtn.prefWidthProperty().bind((ObservableValue)sideLength);
        this.editBtn.maxHeightProperty().bind((ObservableValue)sideLength);
        this.editBtn.maxWidthProperty().bind((ObservableValue)sideLength);
        this.editBtn.minHeightProperty().bind((ObservableValue)sideLength);
        this.editBtn.minWidthProperty().bind((ObservableValue)sideLength);
        this.editBtn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.editBtn.setGraphic((Node)ImageLoader.getEditIcon());
        this.editBtn.setGraphicTextGap(0.0);
        this.editBtn.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eyeIcon = ImageLoader.getEyeIcon();
        this.eyeInvertIcon = ImageLoader.getEyeInvertIcon();
        this.visibleBtn.prefHeightProperty().bind((ObservableValue)sideLength);
        this.visibleBtn.prefWidthProperty().bind((ObservableValue)sideLength);
        this.visibleBtn.maxHeightProperty().bind((ObservableValue)sideLength);
        this.visibleBtn.maxWidthProperty().bind((ObservableValue)sideLength);
        this.visibleBtn.minHeightProperty().bind((ObservableValue)sideLength);
        this.visibleBtn.minWidthProperty().bind((ObservableValue)sideLength);
        this.visibleBtn.setPadding(Insets.EMPTY);
        this.visibleBtn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.visibleBtn.setGraphic((Node)this.eyeIcon);
        this.visibleBtn.setGraphicTextGap(0.0);
        this.visibleBtn.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteBtn.prefHeightProperty().bind((ObservableValue)sideLength);
        this.deleteBtn.prefWidthProperty().bind((ObservableValue)sideLength);
        this.deleteBtn.maxHeightProperty().bind((ObservableValue)sideLength);
        this.deleteBtn.maxWidthProperty().bind((ObservableValue)sideLength);
        this.deleteBtn.minHeightProperty().bind((ObservableValue)sideLength);
        this.deleteBtn.minWidthProperty().bind((ObservableValue)sideLength);
        this.deleteBtn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.deleteBtn.setGraphic((Node)ImageLoader.getCloseIcon());
        this.toolTip.setText(this.toStringFull());
        this.label.setTooltip(this.toolTip);
        HBox.setHgrow((Node)this.region, (Priority)Priority.ALWAYS);
        this.hbox.getChildren().addAll((Object[])new Node[]{this.label, this.region, this.colorBtn, this.editBtn, this.visibleBtn, this.deleteBtn});
        this.infoPacket = new RuleInfoPacket(this.searchedText, this.color, options);
        this.ruleChanged = new SimpleBooleanProperty(false);
        this.ruleChanged.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.type = type;
        this.visible = true;
    }

    public void setCells(ArrayList<String> list) {
        this.cells = list;
        this.cellsSet = true;
    }

    public boolean areCellsSet() {
        return this.cellsSet;
    }

    public ArrayList<String> getCells() {
        return this.cells;
    }

    private void setColorButton(Color color) {
        Rectangle rect = new Rectangle(22.0, 22.0, (Paint)color);
        rect.setStroke((Paint)Color.LIGHTGREY);
        this.colorBtn.setGraphic((Node)rect);
    }

    private void resetLabel() {
        this.label.setText(this.toStringFull());
    }

    public void setSearchedText(String name) {
        this.searchedText = name;
        this.searchedTextLowerCase = name.toLowerCase();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setOptions(SearchOption ... options) {
        this.setOptions(new ArrayList<SearchOption>(Arrays.asList(options)));
    }

    public void setOptions(ArrayList<SearchOption> options) {
        this.options = new ArrayList();
        for (SearchOption option : options) {
            if (option == null) continue;
            this.options.add(option);
        }
    }

    public String getSearchedText() {
        return this.searchedText;
    }

    public SearchType getSearchType() {
        return this.type;
    }

    public String getSearchedTextLowerCase() {
        return this.searchedTextLowerCase;
    }

    public Color getColor() {
        return this.color;
    }

    public HBox getHBox() {
        return this.hbox;
    }

    public Button getDeleteButton() {
        return this.deleteBtn;
    }

    public boolean isCellSelected() {
        return this.options.contains(SearchOption.CELL);
    }

    public boolean isAncestorSelected() {
        return this.options.contains(SearchOption.ANCESTOR);
    }

    public boolean isDescendantSelected() {
        return this.options.contains(SearchOption.DESCENDANT);
    }

    public SearchOption[] getOptions() {
        return this.options.toArray(new SearchOption[this.options.size()]);
    }

    public BooleanProperty getRuleChangedProperty() {
        return this.ruleChanged;
    }

    public String toString() {
        return this.searchedText;
    }

    public boolean equals(ColorRule other) {
        return this.searchedText.equals(other.getSearchedText());
    }

    public String toStringFull() {
        String out = String.valueOf(this.searchedText) + " ";
        int i = 0;
        while (i < this.options.size()) {
            out = String.valueOf(out) + ((SearchOption)this.options.get(i)).getDescription();
            if (i != this.options.size() - 1) {
                out = String.valueOf(out) + ", ";
            }
            ++i;
        }
        return out;
    }

    public boolean appliesTo(String name) {
        if (!this.visible) {
            return false;
        }
        if (this.cells != null) {
            if (this.options.contains(SearchOption.CELL) && this.cells.contains(name)) {
                return true;
            }
            for (String cell : this.cells) {
                if (this.options.contains(SearchOption.ANCESTOR) && LineageTree.isAncestor((String)name, (String)cell)) {
                    return true;
                }
                if (!this.options.contains(SearchOption.DESCENDANT) || !LineageTree.isDescendant((String)name, (String)cell)) continue;
                return true;
            }
        }
        return false;
    }

    private EventHandler<ActionEvent> getSubmitHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Stage access$0(ColorRule colorRule) {
        return colorRule.editStage;
    }

    static /* synthetic */ void access$1(ColorRule colorRule, Stage stage) {
        colorRule.editStage = stage;
    }

    static /* synthetic */ RuleInfoPacket access$2(ColorRule colorRule) {
        return colorRule.infoPacket;
    }

    static /* synthetic */ EventHandler access$3(ColorRule colorRule) {
        return colorRule.getSubmitHandler();
    }

    static /* synthetic */ BooleanProperty access$4(ColorRule colorRule) {
        return colorRule.ruleChanged;
    }

    static /* synthetic */ boolean access$5(ColorRule colorRule) {
        return colorRule.visible;
    }

    static /* synthetic */ Button access$6(ColorRule colorRule) {
        return colorRule.visibleBtn;
    }

    static /* synthetic */ ImageView access$7(ColorRule colorRule) {
        return colorRule.eyeInvertIcon;
    }

    static /* synthetic */ ImageView access$8(ColorRule colorRule) {
        return colorRule.eyeIcon;
    }

    static /* synthetic */ void access$9(ColorRule colorRule, boolean bl) {
        colorRule.visible = bl;
    }

    static /* synthetic */ void access$10(ColorRule colorRule, Color color) {
        colorRule.setColorButton(color);
    }

    static /* synthetic */ void access$11(ColorRule colorRule) {
        colorRule.resetLabel();
    }

    static /* synthetic */ Tooltip access$12(ColorRule colorRule) {
        return colorRule.toolTip;
    }
}

