/*
 * Decompiled with CFR 0.152.
 */
package wormguides.model;

import java.util.ArrayList;
import javafx.scene.paint.Color;
import wormguides.SearchOption;

public class RuleInfoPacket {
    private final String name;
    private Color color;
    private ArrayList<SearchOption> options;

    public RuleInfoPacket() {
        this("", Color.WHITE, null);
    }

    public RuleInfoPacket(String name, Color color, ArrayList<SearchOption> options) {
        this.name = name;
        this.color = color;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public ArrayList<SearchOption> getOptions() {
        return this.options;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setOptions(ArrayList<SearchOption> options) {
        this.options = options;
    }

    public void setCellSelected(boolean selected) {
        if (selected) {
            if (!this.options.contains(SearchOption.CELL)) {
                this.options.add(SearchOption.CELL);
            }
        } else {
            this.options.remove(SearchOption.CELL);
        }
    }

    public void setDescendantSelected(boolean selected) {
        if (selected) {
            if (!this.options.contains(SearchOption.DESCENDANT)) {
                this.options.add(SearchOption.DESCENDANT);
            }
        } else {
            this.options.remove(SearchOption.DESCENDANT);
        }
    }

    public void setAncestorSelected(boolean selected) {
        if (selected) {
            if (!this.options.contains(SearchOption.ANCESTOR)) {
                this.options.add(SearchOption.ANCESTOR);
            }
        } else {
            this.options.remove(SearchOption.ANCESTOR);
        }
    }

    public boolean isCellSelected() {
        return this.options.contains(SearchOption.CELL);
    }

    public boolean isDescendantSelected() {
        return this.options.contains(SearchOption.DESCENDANT);
    }

    public boolean isAncestorSelected() {
        return this.options.contains(SearchOption.ANCESTOR);
    }

    public String toString() {
        String out = "packet info: ";
        out = String.valueOf(out) + this.getName() + " " + this.getColor() + " ";
        for (SearchOption option : this.getOptions()) {
            out = String.valueOf(out) + option + " ";
        }
        return out;
    }
}

