/*
 * Decompiled with CFR 0.152.
 */
package wormguides.view;

import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import wormguides.model.RuleInfoPacket;
import wormguides.view.AppFont;

public class ColorRuleEditPane
extends AnchorPane {
    private RuleInfoPacket infoPacket;

    public ColorRuleEditPane() {
        this(new RuleInfoPacket(), null);
    }

    public ColorRuleEditPane(RuleInfoPacket packet, EventHandler<ActionEvent> handler) {
        this.infoPacket = packet;
        this.setPrefHeight(300.0);
        this.setPrefWidth(240.0);
        VBox vbox = new VBox();
        vbox.setSpacing(3.0);
        AnchorPane.setTopAnchor((Node)vbox, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)vbox, (Double)10.0);
        AnchorPane.setRightAnchor((Node)vbox, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)vbox, (Double)10.0);
        Label optionsLabel = new Label("Search Options for " + packet.getName());
        Region separator = new Region();
        separator.setPrefHeight(10.0);
        Label ancestryLabel = new Label("Cell Ancestry");
        Label cellLabel = new Label("Cell");
        CheckBox cellTick = new CheckBox();
        cellTick.setSelected(this.infoPacket.isCellSelected());
        cellTick.selectedProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HBox cellRow = this.makeEditRow(cellLabel, cellTick);
        Label ancLabel = new Label("Ancestor");
        CheckBox ancTick = new CheckBox();
        ancTick.setSelected(this.infoPacket.isAncestorSelected());
        ancTick.selectedProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HBox ancRow = this.makeEditRow(ancLabel, ancTick);
        Label desLabel = new Label("Descendant");
        CheckBox desTick = new CheckBox();
        desTick.setSelected(this.infoPacket.isDescendantSelected());
        desTick.selectedProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HBox desRow = this.makeEditRow(desLabel, desTick);
        if (packet.getName().contains("functional") || packet.getName().contains("description")) {
            desLabel.disableProperty().set(true);
            desTick.disableProperty().set(true);
        }
        Region separator1 = new Region();
        separator1.setPrefHeight(10.0);
        Label colorLabel = new Label("Color");
        AnchorPane pickerPane = new AnchorPane();
        VBox.setVgrow((Node)pickerPane, (Priority)Priority.ALWAYS);
        ColorPicker picker = new ColorPicker(this.infoPacket.getColor());
        AnchorPane.setTopAnchor((Node)picker, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)picker, (Double)0.0);
        AnchorPane.setRightAnchor((Node)picker, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)picker, (Double)0.0);
        picker.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        pickerPane.getChildren().add((Object)picker);
        HBox buttonBox = new HBox();
        buttonBox.setPrefHeight(30.0);
        Button submit = new Button("Submit");
        submit.setDefaultButton(true);
        submit.setFont(AppFont.getFont());
        submit.setPrefWidth(100.0);
        submit.setAlignment(Pos.CENTER);
        submit.setOnAction(handler);
        buttonBox.getChildren().add((Object)submit);
        buttonBox.setAlignment(Pos.CENTER);
        Region separator2 = new Region();
        separator2.setPrefHeight(10.0);
        Region separator3 = new Region();
        separator3.setPrefHeight(5.0);
        vbox.getChildren().addAll((Object[])new Node[]{optionsLabel, separator, ancestryLabel, cellRow, ancRow, desRow, separator1, colorLabel, pickerPane, separator2, buttonBox, separator3});
        for (Node node : vbox.getChildren()) {
            node.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
            if (!(node instanceof Label)) continue;
            ((Label)node).setFont(AppFont.getFont());
        }
        this.getChildren().add((Object)vbox);
    }

    private HBox makeEditRow(Label label, CheckBox box) {
        HBox row = new HBox();
        row.setPrefHeight(22.0);
        HBox inner = new HBox();
        inner.setPrefWidth(160.0);
        inner.setFillHeight(true);
        Region indent = new Region();
        indent.setPrefWidth(40.0);
        label.setFont(AppFont.getFont());
        Region separator = new Region();
        HBox.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
        box.setPrefHeight(22.0);
        inner.getChildren().addAll((Object[])new Node[]{indent, label, separator, box});
        row.getChildren().add((Object)inner);
        return row;
    }

    static /* synthetic */ RuleInfoPacket access$0(ColorRuleEditPane colorRuleEditPane) {
        return colorRuleEditPane.infoPacket;
    }
}

