/*
 * Decompiled with CFR 0.152.
 */
package wormguides.view;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import wormguides.ImageLoader;
import wormguides.URLGenerator;
import wormguides.view.AppFont;
import wormguides.view.Window3DSubScene;

public class URLWindow
extends AnchorPane {
    Window3DSubScene scene;
    private Label iOSLabel;
    private Label androidLabel;
    private Label webLabel;
    private TextField iOSField;
    private TextField androidField;
    private TextField webField;
    private String iOSURL;
    private String androidURL;
    private String webURL;
    private Button resetBtn;
    private Button closeBtn;
    private Clipboard cb;

    public URLWindow() {
        this.setPrefWidth(430.0);
        this.cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Tooltip tooltip = new Tooltip("copy");
        VBox vBox = new VBox();
        vBox.setSpacing(5.0);
        AnchorPane.setTopAnchor((Node)vBox, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)vBox, (Double)15.0);
        AnchorPane.setRightAnchor((Node)vBox, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)vBox, (Double)10.0);
        this.getChildren().add((Object)vBox);
        this.iOSLabel = new Label("iOS:");
        this.iOSLabel.setFont(AppFont.getFont());
        this.iOSLabel.setPrefHeight(22.0);
        this.androidLabel = new Label("Android:");
        this.androidLabel.setFont(AppFont.getFont());
        this.androidLabel.setPrefHeight(22.0);
        this.webLabel = new Label("Web browser:");
        this.webLabel.setFont(AppFont.getFont());
        this.webLabel.setPrefHeight(22.0);
        HBox iOSHBox = new HBox(10.0);
        this.iOSField = new TextField();
        this.iOSField.setFont(AppFont.getFont());
        this.iOSField.setEditable(false);
        this.iOSField.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        HBox.setHgrow((Node)this.iOSField, (Priority)Priority.ALWAYS);
        Button iOSCopyBtn = new Button();
        iOSCopyBtn.setTooltip(tooltip);
        iOSCopyBtn.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        iOSCopyBtn.maxWidthProperty().bind((ObservableValue)iOSCopyBtn.heightProperty());
        iOSCopyBtn.prefWidthProperty().bind((ObservableValue)iOSCopyBtn.heightProperty());
        iOSCopyBtn.minWidthProperty().bind((ObservableValue)iOSCopyBtn.heightProperty());
        iOSCopyBtn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        iOSCopyBtn.setGraphic((Node)ImageLoader.getCopyIcon());
        iOSCopyBtn.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        iOSHBox.getChildren().addAll((Object[])new Node[]{this.iOSField, iOSCopyBtn});
        HBox androidHBox = new HBox(10.0);
        this.androidField = new TextField();
        this.androidField.setFont(AppFont.getFont());
        this.androidField.setEditable(false);
        this.androidField.setPrefHeight(22.0);
        this.androidField.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        HBox.setHgrow((Node)this.androidField, (Priority)Priority.ALWAYS);
        Button androidCopyBtn = new Button();
        androidCopyBtn.setTooltip(tooltip);
        androidCopyBtn.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        androidCopyBtn.maxWidthProperty().bind((ObservableValue)iOSCopyBtn.heightProperty());
        androidCopyBtn.prefWidthProperty().bind((ObservableValue)iOSCopyBtn.heightProperty());
        androidCopyBtn.minWidthProperty().bind((ObservableValue)iOSCopyBtn.heightProperty());
        androidCopyBtn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        androidCopyBtn.setGraphic((Node)ImageLoader.getCopyIcon());
        androidCopyBtn.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        androidHBox.getChildren().addAll((Object[])new Node[]{this.androidField, androidCopyBtn});
        HBox webHBox = new HBox(10.0);
        this.webField = new TextField();
        this.webField.setFont(AppFont.getFont());
        this.webField.setEditable(false);
        this.webField.setPrefHeight(22.0);
        this.webField.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        HBox.setHgrow((Node)this.webField, (Priority)Priority.ALWAYS);
        Button webCopyBtn = new Button();
        webCopyBtn.setTooltip(tooltip);
        webCopyBtn.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        webCopyBtn.maxWidthProperty().bind((ObservableValue)webCopyBtn.heightProperty());
        webCopyBtn.prefWidthProperty().bind((ObservableValue)webCopyBtn.heightProperty());
        webCopyBtn.minWidthProperty().bind((ObservableValue)webCopyBtn.heightProperty());
        webCopyBtn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        webCopyBtn.setGraphic((Node)ImageLoader.getCopyIcon());
        webCopyBtn.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        webHBox.getChildren().addAll((Object[])new Node[]{this.webField, webCopyBtn});
        this.resetBtn = new Button("Regenerate");
        this.resetBtn.setPrefWidth(100.0);
        this.resetBtn.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        this.resetBtn.setFont(AppFont.getFont());
        this.resetBtn.setOnAction((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.closeBtn = new Button("Close");
        this.closeBtn.setPrefWidth(100.0);
        this.closeBtn.setStyle("-fx-focus-color: -fx-outer-border; -fx-faint-focus-color: transparent;");
        this.closeBtn.setFont(AppFont.getFont());
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().addAll((Object[])new Node[]{this.resetBtn, this.closeBtn});
        Region r = new Region();
        r.setPrefHeight(10.0);
        vBox.getChildren().addAll((Object[])new Node[]{this.iOSLabel, iOSHBox, this.androidLabel, androidHBox, this.webLabel, webHBox, r, hBox});
    }

    public void setScene(Window3DSubScene window3D) {
        this.scene = window3D;
    }

    public void resetURLs() {
        if (this.scene != null) {
            ArrayList list = this.scene.getRulesList();
            this.iOSURL = URLGenerator.generateIOSURL((ArrayList)list, (int)this.scene.getTime(), (double)this.scene.getRotationX(), (double)this.scene.getRotationY(), (double)this.scene.getRotationZ(), (double)this.scene.getTranslationX(), (double)this.scene.getTranslationY(), (double)this.scene.getScale(), (double)this.scene.getOthersVisibility());
            this.androidURL = URLGenerator.generateAndroidURL((ArrayList)list, (int)this.scene.getTime(), (double)this.scene.getRotationX(), (double)this.scene.getRotationY(), (double)this.scene.getRotationZ(), (double)this.scene.getTranslationX(), (double)this.scene.getTranslationY(), (double)this.scene.getScale(), (double)this.scene.getOthersVisibility());
            this.webURL = URLGenerator.generateWebURL((ArrayList)list, (int)this.scene.getTime(), (double)this.scene.getRotationX(), (double)this.scene.getRotationY(), (double)this.scene.getRotationZ(), (double)this.scene.getTranslationX(), (double)this.scene.getTranslationY(), (double)this.scene.getScale(), (double)this.scene.getOthersVisibility());
            this.iOSField.setText(this.iOSURL);
            this.androidField.setText(this.androidURL);
            this.webField.setText(this.webURL);
        }
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    static /* synthetic */ TextField access$0(URLWindow uRLWindow) {
        return uRLWindow.iOSField;
    }

    static /* synthetic */ Clipboard access$1(URLWindow uRLWindow) {
        return uRLWindow.cb;
    }

    static /* synthetic */ TextField access$2(URLWindow uRLWindow) {
        return uRLWindow.androidField;
    }

    static /* synthetic */ TextField access$3(URLWindow uRLWindow) {
        return uRLWindow.webField;
    }
}

