/*
 * Decompiled with CFR 0.152.
 */
package wormguides.view;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.Slider;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import wormguides.ColorComparator;
import wormguides.Xform;
import wormguides.model.ColorHash;
import wormguides.model.ColorRule;
import wormguides.model.LineageData;
import wormguides.view.Window3DSubScene;

public class Window3DSubScene {
    private LineageData data;
    private SubScene subscene;
    private Group root = new Group();
    private PerspectiveCamera camera;
    private Xform cameraXform;
    private double mousePosX;
    private double mousePosY;
    private double mouseOldX;
    private double mouseOldY;
    private double mouseDeltaX;
    private double mouseDeltaY;
    private int newOriginX;
    private int newOriginY;
    private int newOriginZ;
    private IntegerProperty time;
    private IntegerProperty totalNuclei;
    private int endTime;
    private Sphere[] cells;
    private String[] names;
    private boolean[] searched;
    private Integer[][] positions;
    private Integer[] diameters;
    private DoubleProperty zoom;
    private double zScale;
    private BooleanProperty playingMovie;
    private PlayService playService;
    private RenderService renderService;
    private IntegerProperty selectedIndex;
    private StringProperty selectedName;
    private boolean inSearch;
    private ObservableList<String> searchResultsList;
    private ArrayList<String> localSearchResults;
    private ColorHash colorHash;
    private ObservableList<ColorRule> rulesList;
    private Service<Void> searchResultsUpdateService;
    private BooleanProperty geneResultsUpdated;
    private DoubleProperty othersOpacity;
    private HashMap<Double, Material> opacityMaterialHash;
    private ArrayList<String> otherCells;
    private final Rotate rotateX;
    private final Rotate rotateY;
    private static final String CS = ", ";
    private static final String FILL_COLOR_HEX = "#272727";
    private static final long WAIT_TIME_MILLI = 550L;
    private static final double CAMERA_INITIAL_DISTANCE = -800.0;
    private static final double CAMERA_NEAR_CLIP = 0.01;
    private static final double CAMERA_FAR_CLIP = 10000.0;
    private static final int START_TIME = 1;
    private static final int X_COR_INDEX = 0;
    private static final int Y_COR_INDEX = 1;
    private static final int Z_COR_INDEX = 2;
    private static final double Z_SCALE = 5.0;
    private static final double X_SCALE = 1.0;
    private static final double Y_SCALE = 1.0;
    private static final double SIZE_SCALE = 0.9;

    public Window3DSubScene(double width, double height, LineageData data) {
        this.data = data;
        this.time = new SimpleIntegerProperty(1);
        this.time.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.zoom = new SimpleDoubleProperty(1.0);
        this.zScale = 5.0;
        this.cells = new Sphere[1];
        this.names = new String[1];
        this.positions = new Integer[1][3];
        this.diameters = new Integer[1];
        this.searched = new boolean[1];
        this.selectedIndex = new SimpleIntegerProperty();
        this.selectedIndex.set(-1);
        this.selectedName = new SimpleStringProperty();
        this.selectedName.set((Object)"");
        this.selectedName.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.inSearch = false;
        this.totalNuclei = new SimpleIntegerProperty();
        this.totalNuclei.set(0);
        this.endTime = data.getTotalTimePoints();
        this.createSubScene(Double.valueOf(width), Double.valueOf(height));
        this.mousePosX = 0.0;
        this.mousePosY = 0.0;
        this.mouseOldX = 0.0;
        this.mouseOldY = 0.0;
        this.mouseDeltaX = 0.0;
        this.mouseDeltaY = 0.0;
        this.playService = new PlayService(this, null);
        this.playingMovie = new SimpleBooleanProperty();
        this.playingMovie.set(false);
        this.playingMovie.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.renderService = new RenderService(this, null);
        this.zoom.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.localSearchResults = new ArrayList();
        this.searchResultsUpdateService = null;
        this.geneResultsUpdated = new SimpleBooleanProperty();
        this.othersOpacity = new SimpleDoubleProperty(1.0);
        this.opacityMaterialHash = new HashMap();
        this.opacityMaterialHash.put(this.othersOpacity.get(), new PhongMaterial(Color.WHITE));
        this.otherCells = new ArrayList();
        this.rotateX = new Rotate(0.0, 0.0, (double)this.newOriginY, (double)this.newOriginZ, Rotate.X_AXIS);
        this.rotateY = new Rotate(0.0, (double)this.newOriginX, 0.0, (double)this.newOriginZ, Rotate.Y_AXIS);
    }

    public IntegerProperty getTimeProperty() {
        return this.time;
    }

    public DoubleProperty getZoomProperty() {
        return this.zoom;
    }

    public IntegerProperty getSelectedIndex() {
        return this.selectedIndex;
    }

    public StringProperty getSelectedName() {
        return this.selectedName;
    }

    public IntegerProperty getTotalNucleiProperty() {
        return this.totalNuclei;
    }

    public BooleanProperty getPlayingMovieProperty() {
        return this.playingMovie;
    }

    private SubScene createSubScene(Double width, Double height) {
        this.subscene = new SubScene((Parent)this.root, width.doubleValue(), height.doubleValue(), true, SceneAntialiasing.DISABLED);
        this.subscene.setFill((Paint)Color.web((String)FILL_COLOR_HEX));
        this.subscene.setCursor(Cursor.HAND);
        this.subscene.setOnMouseDragged((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.subscene.setOnMouseReleased((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.subscene.setOnMouseClicked((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.subscene.setOnMousePressed((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.buildCamera();
        return this.subscene;
    }

    private void rotateAllCells(double x, double y) {
        this.rotateX.setAngle(this.rotateX.getAngle() + y);
        this.rotateY.setAngle(this.rotateY.getAngle() - x);
    }

    private int getIndexByName(String name) {
        int i = 0;
        while (i < this.names.length) {
            if (this.names[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getPickedSphereIndex(Sphere picked) {
        int i = 0;
        while (i < this.names.length) {
            if (this.cells[i].equals(picked)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void buildScene(int time) {
        System.out.println("building scene");
        this.names = this.data.getNames(--time);
        this.positions = this.data.getPositions(time);
        this.diameters = this.data.getDiameters(time);
        this.totalNuclei.set(this.names.length);
        this.cells = new Sphere[this.names.length];
        if (this.localSearchResults.isEmpty()) {
            this.searched = new boolean[this.names.length];
        } else {
            this.consultSearchResultsList();
        }
        this.renderService.restart();
    }

    private void updateLocalSearchResults() {
        if (this.searchResultsList == null) {
            return;
        }
        this.localSearchResults.clear();
        for (String name : this.searchResultsList) {
            if (name.indexOf("(") != -1) {
                this.localSearchResults.add(name.substring(0, name.indexOf(" ")));
                continue;
            }
            this.localSearchResults.add(name);
        }
        this.buildScene(this.time.get());
    }

    private void refreshScene() {
        this.root.getChildren().clear();
        this.root.getChildren().add((Object)this.cameraXform);
    }

    private void addCellsToScene() {
        ArrayList<Sphere> renderFirst = new ArrayList<Sphere>();
        ArrayList<Sphere> renderSecond = new ArrayList<Sphere>();
        int i = 0;
        while (i < this.names.length) {
            double radius = 0.9 * (double)this.diameters[i].intValue() / 2.0;
            Sphere sphere = new Sphere(radius);
            PhongMaterial material = new PhongMaterial();
            if (this.inSearch) {
                if (this.searched[i]) {
                    renderFirst.add(sphere);
                    material = this.colorHash.getHighlightMaterial();
                } else {
                    renderSecond.add(sphere);
                    material = this.colorHash.getTranslucentMaterial();
                }
            } else {
                TreeSet<Color> colors = new TreeSet<Color>((Comparator<Color>)new ColorComparator());
                for (ColorRule rule : this.rulesList) {
                    if (!rule.appliesTo(this.names[i])) continue;
                    colors.add(rule.getColor());
                }
                material = this.colorHash.getMaterial(colors);
                if (colors.isEmpty()) {
                    renderSecond.add(sphere);
                    material = (Material)this.opacityMaterialHash.get(this.othersOpacity.get());
                    this.othersOpacity.set(1.0);
                } else {
                    renderFirst.add(sphere);
                }
            }
            sphere.setMaterial((Material)material);
            double x = this.positions[i][0].intValue();
            double y = this.positions[i][1].intValue();
            double z = (double)this.positions[i][2].intValue() * this.zScale;
            sphere.getTransforms().addAll((Object[])new Transform[]{this.rotateX, this.rotateY});
            this.translateSphere((Node)sphere, x, y, z);
            this.cells[i] = sphere;
            ++i;
        }
        this.refreshScene();
        this.root.getChildren().addAll(renderFirst);
        this.root.getChildren().addAll(renderSecond);
    }

    private void translateSphere(Node sphere, double x, double y, double z) {
        Translate t = new Translate(x, y, z);
        sphere.getTransforms().add((Object)t);
    }

    private void buildCamera() {
        this.camera = new PerspectiveCamera(true);
        this.cameraXform = new Xform();
        this.cameraXform.reset();
        this.root.getChildren().add((Object)this.cameraXform);
        this.cameraXform.getChildren().add((Object)this.camera);
        this.camera.setNearClip(0.01);
        this.camera.setFarClip(10000.0);
        this.camera.setTranslateZ(-800.0);
        this.cameraXform.setScaleX(1.0);
        this.cameraXform.setScaleY(1.0);
        this.setNewOrigin();
        this.subscene.setCamera((Camera)this.camera);
    }

    private void setNewOrigin() {
        Integer[][] positions = this.data.getPositions(1);
        int numCells = positions.length;
        int sumX = 0;
        int sumY = 0;
        int sumZ = 0;
        int i = 0;
        while (i < numCells) {
            sumX += positions[i][0].intValue();
            sumY += positions[i][1].intValue();
            sumZ += positions[i][2].intValue();
            ++i;
        }
        this.newOriginX = Math.round(sumX / numCells);
        this.newOriginY = Math.round(sumY / numCells);
        this.newOriginZ = (int)Math.round(5.0 * (double)sumZ / (double)numCells);
        this.cameraXform.setTranslate((double)this.newOriginX, (double)this.newOriginY, (double)this.newOriginZ);
        System.out.println("origin xyz: " + this.newOriginX + " " + this.newOriginY + " " + this.newOriginZ);
    }

    public void setSearchResultsList(ObservableList<String> list) {
        this.searchResultsList = list;
    }

    public void setResultsUpdateService(Service<Void> service) {
        this.searchResultsUpdateService = service;
        this.searchResultsUpdateService.setOnSucceeded((EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setGeneResultsUpdated(BooleanProperty updated) {
        this.geneResultsUpdated = updated;
        this.geneResultsUpdated.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void consultSearchResultsList() {
        this.searched = new boolean[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            this.searched[i] = this.localSearchResults.contains(this.names[i]);
            ++i;
        }
    }

    public void printCellNames() {
        int i = 0;
        while (i < this.names.length) {
            System.out.println(String.valueOf(this.names[i]) + CS + this.cells[i]);
            ++i;
        }
    }

    public void setRulesList(ObservableList<ColorRule> rulesList) {
        this.rulesList = rulesList;
        this.colorHash = new ColorHash(rulesList);
        this.rulesList.addListener((ListChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ArrayList<ColorRule> getRulesList() {
        ArrayList<ColorRule> list = new ArrayList<ColorRule>();
        for (ColorRule rule : this.rulesList) {
            list.add(rule);
        }
        return list;
    }

    public ObservableList<ColorRule> getObservableRulesList() {
        return this.rulesList;
    }

    public void setRulesList(ArrayList<ColorRule> list) {
        this.rulesList.clear();
        this.rulesList.setAll(list);
    }

    public int getTime() {
        return this.time.get();
    }

    public void setTime(int t) {
        if (t > 0 && t < this.endTime) {
            this.time.set(t);
        }
    }

    public double getRotationX() {
        return 0.0;
    }

    public void setRotationX(double rx) {
    }

    public double getRotationY() {
        return 0.0;
    }

    public void setRotationY(double ry) {
    }

    public double getRotationZ() {
        return 0.0;
    }

    public void setRotationZ(double rz) {
    }

    public double getTranslationX() {
        return 0.0;
    }

    public void setTranslationX(double tx) {
    }

    public double getTranslationY() {
        return 0.0;
    }

    public void setTranslationY(double ty) {
    }

    public double getScale() {
        double scale = this.zoom.get() - 0.25;
        return scale /= 3.167;
    }

    public void setScale(double scale) {
        this.zoom.set((scale *= 3.167) + 0.25);
    }

    public double getOthersVisibility() {
        return this.othersOpacity.get();
    }

    public void setOthersVisibility(double dim) {
    }

    public SubScene getSubScene() {
        return this.subscene;
    }

    public Group getRoot() {
        return this.root;
    }

    public ChangeListener<Number> getOthersOpacityListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void addListenerToOpacitySlider(Slider slider) {
        this.othersOpacity.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ChangeListener<String> getSearchFieldListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public int getStartTime() {
        return 1;
    }

    public EventHandler<ActionEvent> getZoomInButtonListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public EventHandler<ActionEvent> getZoomOutButtonListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public EventHandler<ActionEvent> getBackwardButtonListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public EventHandler<ActionEvent> getForwardButtonListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ void access$0(Window3DSubScene window3DSubScene) {
        window3DSubScene.refreshScene();
    }

    static /* synthetic */ ArrayList access$1(Window3DSubScene window3DSubScene) {
        return window3DSubScene.otherCells;
    }

    static /* synthetic */ void access$2(Window3DSubScene window3DSubScene) {
        window3DSubScene.addCellsToScene();
    }

    static /* synthetic */ IntegerProperty access$3(Window3DSubScene window3DSubScene) {
        return window3DSubScene.time;
    }

    static /* synthetic */ int access$4(Window3DSubScene window3DSubScene) {
        return window3DSubScene.endTime;
    }

    static /* synthetic */ void access$5(Window3DSubScene window3DSubScene, int n) {
        window3DSubScene.buildScene(n);
    }

    static /* synthetic */ int access$6(Window3DSubScene window3DSubScene, String string) {
        return window3DSubScene.getIndexByName(string);
    }

    static /* synthetic */ IntegerProperty access$7(Window3DSubScene window3DSubScene) {
        return window3DSubScene.selectedIndex;
    }

    static /* synthetic */ PlayService access$8(Window3DSubScene window3DSubScene) {
        return window3DSubScene.playService;
    }

    static /* synthetic */ Xform access$9(Window3DSubScene window3DSubScene) {
        return window3DSubScene.cameraXform;
    }

    static /* synthetic */ DoubleProperty access$10(Window3DSubScene window3DSubScene) {
        return window3DSubScene.zoom;
    }

    static /* synthetic */ SubScene access$11(Window3DSubScene window3DSubScene) {
        return window3DSubScene.subscene;
    }

    static /* synthetic */ double access$12(Window3DSubScene window3DSubScene) {
        return window3DSubScene.mousePosX;
    }

    static /* synthetic */ void access$13(Window3DSubScene window3DSubScene, double d) {
        window3DSubScene.mouseOldX = d;
    }

    static /* synthetic */ double access$14(Window3DSubScene window3DSubScene) {
        return window3DSubScene.mousePosY;
    }

    static /* synthetic */ void access$15(Window3DSubScene window3DSubScene, double d) {
        window3DSubScene.mouseOldY = d;
    }

    static /* synthetic */ void access$16(Window3DSubScene window3DSubScene, double d) {
        window3DSubScene.mousePosX = d;
    }

    static /* synthetic */ void access$17(Window3DSubScene window3DSubScene, double d) {
        window3DSubScene.mousePosY = d;
    }

    static /* synthetic */ double access$18(Window3DSubScene window3DSubScene) {
        return window3DSubScene.mouseOldX;
    }

    static /* synthetic */ void access$19(Window3DSubScene window3DSubScene, double d) {
        window3DSubScene.mouseDeltaX = d;
    }

    static /* synthetic */ double access$20(Window3DSubScene window3DSubScene) {
        return window3DSubScene.mouseOldY;
    }

    static /* synthetic */ void access$21(Window3DSubScene window3DSubScene, double d) {
        window3DSubScene.mouseDeltaY = d;
    }

    static /* synthetic */ double access$22(Window3DSubScene window3DSubScene) {
        return window3DSubScene.mouseDeltaX;
    }

    static /* synthetic */ double access$23(Window3DSubScene window3DSubScene) {
        return window3DSubScene.mouseDeltaY;
    }

    static /* synthetic */ void access$24(Window3DSubScene window3DSubScene, double d, double d2) {
        window3DSubScene.rotateAllCells(d, d2);
    }

    static /* synthetic */ int access$25(Window3DSubScene window3DSubScene, Sphere sphere) {
        return window3DSubScene.getPickedSphereIndex(sphere);
    }

    static /* synthetic */ StringProperty access$26(Window3DSubScene window3DSubScene) {
        return window3DSubScene.selectedName;
    }

    static /* synthetic */ String[] access$27(Window3DSubScene window3DSubScene) {
        return window3DSubScene.names;
    }

    static /* synthetic */ void access$28(Window3DSubScene window3DSubScene) {
        window3DSubScene.updateLocalSearchResults();
    }

    static /* synthetic */ DoubleProperty access$29(Window3DSubScene window3DSubScene) {
        return window3DSubScene.othersOpacity;
    }

    static /* synthetic */ HashMap access$30(Window3DSubScene window3DSubScene) {
        return window3DSubScene.opacityMaterialHash;
    }

    static /* synthetic */ void access$31(Window3DSubScene window3DSubScene, boolean bl) {
        window3DSubScene.inSearch = bl;
    }

    static /* synthetic */ BooleanProperty access$32(Window3DSubScene window3DSubScene) {
        return window3DSubScene.playingMovie;
    }
}

