%runs nuclear detection 

%input
%parameterfile is full path location of parameter file
% embryodir is full path of directory containing image files e.g.
% L:/disk1/bao/083105/image/tif/
% embryonumber is the prefix of the image file name e.g. 083105_L1
%suffix is an optional string that will be appended to the name to all
%output keeping one processing of a set of image data separate from another
% for example to test multiple parameter sets, or (in conjunction with ROI parameters) 
%if multiple embryos are in one image 
%outputdirectory is where the output goes

%output
%outputs int outputdir/embryonumber_fullmatlabresult.mat a dump of matlab
%detection results. The important part of this is the cell array esequence
%which contains structure fields finalpoints, finaldiams, which
%are the position and size of nuclei.
%output int outputdir is a zip file contaning lineaged results

function detect_track_driver_allmatlab(parameterfile,embryodir,embryonumber,suffix,outputdirectory,polygon_points,isred);%,lineageParameterFileName)
runexpression=true;
newimage=false;

'beginning lineaging'
tic
global parameters;


%cant pass blank string parameter on command line, so comes in as undef
if(~exist('suffix'))
    suffix='';
end


if(~exist('nodata'))
    nodata=true;%whether to use SN data to match online
end
nodatause=true;%whether to use SN data for diameter and stored bottom
savedata=true;
singlevolume=false;


readParameters;

load(distribution_file);

anisotropy=zres/xyres*downsampling;
downsample=downsampling;
tlist=linspace(start_time,end_time,(end_time-start_time+1));
firsttimestep=start_time;
allvalid=[];



eall={};

bottomdata={};

if(singlevolume&~nodata)
    zlevel=embryolevel;
else
    zlevel=slices;
end
%nucleibase=[nucleidir,embryonumber,'\'];
esequence={};
processSequence;

'detection completed, beginning lineaging'


mkdir([outputdirectory,suffix,embryonumber,'/nuclei']);


if (end_time-start_time>0)
    %parameterConfiguration;
    %parameterfile=lineageParameterFileName;
    %readParameters;
    trackingparameters.trainingmode=false;
    trackingparameters.recordanswers=false;
    evalforced=false;
    endtime=end_time;
    trackingparameters.endtime=endtime;
    trackingparameters.anisotropyvector=[1,1,anisotropy];
    parameters.anisotropyvector=[1,1,anisotropy];
    
    tracking_driver_new_classifier_based_version;

    %{
if(start_time~=1)
        tempesequence=esequence;
        esequence=cell(end_time,1);
        for i=1:length(tempesequence)
            esequence{start_time+i-1}=tempesequence{i};
        end
    end
    %}
  %{ 
if(MATLAB_STACK)
        tempv=ROIxmin;
        ROIxmin=ROIymin;
        ROIymin=tempv;
    end
%}
    saveGreedyNucleiFiles(esequence,endtime,[outputdirectory,suffix,embryonumber,'/nuclei'],anisotropy,ROIxmin,ROIymin);
  
     %esequence_con= scoreLinkConfidence(esequence,trackingparameters);
     %saveGreedyNucleiFilesAndConfidence(esequence_con,trackingparameters.endtime, trimmed_outputdirectory,anisotropy,ROIxmin,ROIymin,0,false);
   
%move output here to save matlab version after tracking
if(exist('bigfile')&&bigfile==true)
    save([embryodir,name,'_fullmatlabresult.mat'],'-v7.3');
else
    save([embryodir,name,'_fullmatlabresult.mat']);
end

else
      %now done in detection 
      %{
    if(start_time~=1)
        tempesequence=esequence;
        esequence=cell(end_time,1);
        for i=1:length(tempesequence)
            esequence{start_time+i-1}=tempesequence{i};
        end
    end
      %}
    base=[outputdirectory,suffix,embryonumber,'/nuclei/'];
    output_unlineaged_acetree;
end
zipname=[outputdirectory,embryonumber,'_',suffix,'.zip'];
zip(zipname,[outputdirectory,suffix,embryonumber,'/nuclei']);
%remove temp directory
rmdir([outputdirectory,suffix,embryonumber],'s');

toc

%then need to output xml file
%and run naming program
xmlname=[outputdirectory,embryonumber,'_',suffix,'.xml'];
file=fopen(xmlname,'w');

fprintf (file, '<?xml version=''1.0'' encoding=\''utf-8\''?>\n');
fprintf (file, '<embryo>\n');

if (newimage)
    fprintf (file,'<useStack type="1"/>\n');
    fprintf (file,['<image file="',embryodir,embryonumber,'_t',num2str(start_time),'.tif"/>\n']);
else
    fprintf (file,['<image file="',embryodir,'image/tif/',embryonumber,'-t',num2str(start_time,'%03d'),'-p01.tif"/>\n']);
end
fprintf (file,['<nuclei file="',zipname,'"/>\n']);

fprintf (file,'<end index="475"/>\n');
fprintf(file,['<resolution xyRes="',num2str(xyres),'" zRes="',num2str(zres),'" planeEnd="',num2str(slices),'"/> <exprCorr type="blot"/>\n']); 
fprintf (file,'<polar size="15"/>\n');
fprintf (file,'</embryo>');
fclose(file);

%edited duplicate 
zipnameedited=[outputdirectory,embryonumber,'_',suffix,'_edited.zip'];
xmlname=[outputdirectory,embryonumber,'_',suffix,'_edited.xml'];
file=fopen(xmlname,'w');

fprintf (file, '<?xml version=''1.0'' encoding=\''utf-8\''?>\n');
fprintf (file, '<embryo>\n');
if (newimage)
    %if looking at new images delete old images after use
   % rmdir([embryodir,'image/'],'s');
    fprintf (file,'<useStack type="1"/>\n');
    fprintf (file,['<image file="',embryodir,embryonumber,'_t1.tif"/>\n']);
else
     fprintf (file,['<image file="',embryodir,'image/tif/',embryonumber,'-t',num2str(start_time,'%03d'),'-p01.tif"/>\n']);
end
fprintf (file,['<nuclei file="',zipnameedited,'"/>\n']);

fprintf (file,'<end index="475"/>\n');
fprintf(file,['<resolution xyRes="',num2str(xyres),'" zRes="',num2str(zres),'" planeEnd="',num2str(slices),'"/> <exprCorr type="blot"/>\n']); 
fprintf (file,'<polar size="15"/>\n');
fprintf (file,'</embryo>');
fclose(file);
%edited duplicate 
copyfile (zipname,zipnameedited);


'lineaging completed'

'running expression'

