macro "dispinfusion"{
// This macro is to create a simp User Interface within ImageJ and 
// launch the spimfusion.exe console and pass arguments to the console
// Min Guo, May 2017

// Color options
pathCurrent = getDirectory("Select folder that contains this macro");
Dialog.create("diSPIM Fusion Color Selection");
items = newArray("Single color", "Dual color");
Dialog.addRadioButtonGroup("Color Options", items, 2, 1, "Single color");
Dialog.show();

colorChoice = Dialog.getRadioButton();
if(colorChoice=="Single color"){
	pathSPIMA = getDirectory("Select SPIMA (base images) folder");
	pathSPIMB = getDirectory("Select SPIMB folder");
	filePSFA = File.openDialog("Select PSF A");
	filePSFB = File.openDialog("Select PSF B");
	pathOutput = getDirectory("Select output folder");

	SPIMAList = getFileList(pathSPIMA);
	totalImageNum = lengthOf(SPIMAList);
	imageNumStart = 0;
	imageNumEnd = totalImageNum - 1;
	imageNumInterval = 1;

	print("Set input parameters...\n...\n");

	Dialog.create("diSPIM Fusion");
	//input images parameters
	Dialog.addString("SPIMA Directory",pathSPIMA,80);
	Dialog.addString("SPIMB Directory",pathSPIMB,80);
	Dialog.addString("ImageA Name","SPIMA_",20);
	Dialog.addString("ImageB Name","SPIMB_",20);
	Dialog.addString("Output Directory",pathOutput,80);
	Dialog.addNumber("Start #", imageNumStart);
	Dialog.addNumber("End #", imageNumEnd);
	Dialog.addNumber("Interval", imageNumInterval);
	Dialog.addNumber("Test #", imageNumStart);
	Dialog.addMessage("Initial Pixel Size");
	Dialog.addNumber("ImageA x", 0.1625,4,6,"um");
	Dialog.addNumber("ImageA y", 0.1625,4,6,"um");
	Dialog.addNumber("ImageA z", 1.0,4,6,"um");
	Dialog.addNumber("ImageB x", 0.1625,4,6,"um");
	Dialog.addNumber("ImageB y", 0.1625,4,6,"um");
	Dialog.addNumber("ImageB z", 1.0,4,6,"um");

	// registration parameters
	items = newArray("All images dependently", "All images independently",  "One image only", "No registration");
	Dialog.addRadioButtonGroup("Set Registration Options", items, 2, 2, "All images dependently");
	items = newArray("No rotation", "90 deg by Y-axis",  "-90 deg by Y-axis");
	Dialog.addRadioButtonGroup("ImageB Rotation", items, 1, 3, "-90 deg by Y-axis");
	Dialog.addCheckbox("Do 2D registration", false);
	Dialog.addCheckbox("Customize inital transformation matrix", false);
	Dialog.addCheckbox("Save Registered Images", false);
	Dialog.addNumber("Convergence Threshold", 0.0001, 6, 8," ");
	Dialog.addMessage("\n");

	// Joint Deconvolution parameters
	Dialog.addMessage("Set Deconvolution Options");
	Dialog.addNumber("Iterations", 10);
	Dialog.addNumber("Output Image Bit", 16);
	Dialog.addString("PSFA", filePSFA, 80);
	Dialog.addString("PSFB", filePSFB, 80);

	Dialog.addMessage("\n");
	Dialog.addMessage("Set GPU Options");
	Dialog.addCheckbox("Show GUP Device Information", true);
	Dialog.addNumber("GPU Device #", 0);
	Dialog.show();

	//Get parameters from dialog
	pathSPIMA = Dialog.getString();
	pathSPIMB = Dialog.getString();
	nameA = Dialog.getString();
	nameB = Dialog.getString();
	pathOutput = Dialog.getString();

	imageNumStart = Dialog.getNumber();
	imageNumEnd = Dialog.getNumber();
	imageNumInterval = Dialog.getNumber();
	imageNumTest = Dialog.getNumber();

	pixelSizeAx = Dialog.getNumber();
	pixelSizeAy = Dialog.getNumber();
	pixelSizeAz = Dialog.getNumber();
	pixelSizeBx = Dialog.getNumber();
	pixelSizeBy = Dialog.getNumber();
	pixelSizeBz = Dialog.getNumber();

	// registration
	regChoice = Dialog.getRadioButton();// 1, 2, 3, 4;
	regMode = 1; 
	if(regChoice=="All images dependently"){
		regMode = 1;
		}
	else if(regChoice=="All images independently"){
		regMode = 2;
		}
	else if(regChoice=="One image only"){
		regMode = 3;
		}
	else if(regChoice=="No registration"){
		regMode = 4;
		}

	rotChoice = Dialog.getRadioButton();// 0, 1, -1;
	imBRotation = -1;
	if(rotChoice=="No rotation"){
		imBRotation = 0;
		}
	else if(rotChoice=="90 deg by Y-axis"){
		imBRotation = 1; // please add this choice to the cuda exe
		}
	else if(rotChoice=="-90 deg by Y-axis"){
		imBRotation = -1;
		}
	reg2Dtriger = Dialog.getCheckbox(); //true: 1, false: 0
	inputTmx = Dialog.getCheckbox(); //true: 1, false: 0
	if(inputTmx){
		reg2Dtriger = false;
		fileTmx =  File.openDialog("Select transform matrix file");
	}
	else{
		fileTmx = "Balabalabala";
	}
	saveReg = Dialog.getCheckbox(); //true: 1, false: 0
	fTol = Dialog.getNumber();

	iteration = Dialog.getNumber();
	bitPerSample = Dialog.getNumber();
	filePSFA = Dialog.getString();
	filePSFB = Dialog.getString();


	//Set GPU Options
	dQuery = Dialog.getCheckbox();
	deviceNum = Dialog.getNumber();
	cudaExe = pathCurrent + "CudaApp\\spimfusion_singlecolor.exe";

	print("Parameters set done!!!\n\n");

	print("Lauching cuda program...\n...\n");
	print("cuda program running...\n...\n");

	result = exec(cudaExe+" "+pathSPIMA+" "+pathSPIMB+" "+nameA+" "+nameB+" "+pathOutput+" "+imageNumStart+" "+imageNumEnd+" "+
		imageNumInterval+" "+imageNumTest+" "+pixelSizeAx+" "+pixelSizeAy+" "+
		pixelSizeAz+" "+pixelSizeBx+" "+pixelSizeBy+" "+pixelSizeBz+" "+regMode+" "+
		imBRotation+" "+reg2Dtriger+" "+inputTmx+" "+fileTmx+" "+saveReg+" "+fTol+" "+
		iteration+" "+bitPerSample+" "+filePSFA+" "+filePSFB+" "+dQuery+" "+deviceNum);

	print("caculation resoult:"+result);
}
else if(colorChoice=="Dual color"){
	pathSPIMA1 = getDirectory("Select Color 1 SPIMA (base images) folder");
	pathSPIMB1 = getDirectory("Select Color 1 SPIMB folder");
	pathSPIMA2 = getDirectory("Select Color 2 SPIMA (base images) folder");
	pathSPIMB2 = getDirectory("Select Color 2 SPIMB folder");
	filePSFA = File.openDialog("Select PSF A");
	filePSFB = File.openDialog("Select PSF B");
	pathOutput = getDirectory("Select output folder");

	SPIMAList = getFileList(pathSPIMA1);
	totalImageNum = lengthOf(SPIMAList);
	imageNumStart = 0;
	imageNumEnd = totalImageNum - 1;
	imageNumInterval = 1;

	print("Set input parameters...\n...\n");

	Dialog.create("diSPIM Fusion");
	//input images parameters
	Dialog.addString("Color 1 SPIMA Directory",pathSPIMA1,80);
	Dialog.addString("Color 1 SPIMB Directory",pathSPIMB1,80);
	Dialog.addString("Color 1 ImageA Name","SPIMA_",20);
	Dialog.addString("Color 1 ImageB Name","SPIMB_",20);
	Dialog.addString("Color 2 SPIMA Directory",pathSPIMA2,80);
	Dialog.addString("Color 2 SPIMB Directory",pathSPIMB2,80);
	Dialog.addString("Color 2 ImageA Name","SPIMA_",20);
	Dialog.addString("Color 2 ImageB Name","SPIMB_",20);
	Dialog.addString("Output Directory",pathOutput,80);
	Dialog.addNumber("Start #", imageNumStart);
	Dialog.addNumber("End #", imageNumEnd);
	Dialog.addNumber("Interval", imageNumInterval);
	Dialog.addNumber("Test #", imageNumStart);
	Dialog.addMessage("Initial Pixel Size");
	Dialog.addNumber("ImageA x", 0.1625,4,6,"um");
	Dialog.addNumber("ImageA y", 0.1625,4,6,"um");
	Dialog.addNumber("ImageA z", 1.0,4,6,"um");
	Dialog.addNumber("ImageB x", 0.1625,4,6,"um");
	Dialog.addNumber("ImageB y", 0.1625,4,6,"um");
	Dialog.addNumber("ImageB z", 1.0,4,6,"um");

	// registration parameters
	items = newArray("All images dependently", "All images independently",  "One image only", "No registration");
	Dialog.addRadioButtonGroup("Set Registration Options", items, 2, 2, "All images dependently");
	items = newArray("No rotation", "90 deg by Y-axis",  "-90 deg by Y-axis");
	Dialog.addRadioButtonGroup("ImageB Rotation", items, 1, 3, "-90 deg by Y-axis");
	Dialog.addCheckbox("Do 2D registration", false);
	Dialog.addCheckbox("Customize inital transformation matrix", false);
	Dialog.addCheckbox("Save Registered Images", false);
	Dialog.addNumber("Convergence Threshold", 0.0001, 6, 8," ");
	Dialog.addMessage("\n");

	// Joint Deconvolution parameters
	Dialog.addMessage("Set Deconvolution Options");
	Dialog.addNumber("Iterations", 10);
	Dialog.addNumber("Output Image Bit", 16);
	Dialog.addString("PSFA", filePSFA, 80);
	Dialog.addString("PSFB", filePSFB, 80);

	Dialog.addMessage("\n");
	Dialog.addMessage("Set GPU Options");
	Dialog.addCheckbox("Show GUP Device Information", true);
	Dialog.addNumber("GPU Device #", 0);
	Dialog.show();

	//Get parameters from dialog
	pathSPIMA1 = Dialog.getString();
	pathSPIMB1 = Dialog.getString();
	nameA1 = Dialog.getString();
	nameB1 = Dialog.getString();
	pathSPIMA2 = Dialog.getString();
	pathSPIMB2 = Dialog.getString();
	nameA2 = Dialog.getString();
	nameB2 = Dialog.getString();
	pathOutput = Dialog.getString();

	imageNumStart = Dialog.getNumber();
	imageNumEnd = Dialog.getNumber();
	imageNumInterval = Dialog.getNumber();
	imageNumTest = Dialog.getNumber();

	pixelSizeAx = Dialog.getNumber();
	pixelSizeAy = Dialog.getNumber();
	pixelSizeAz = Dialog.getNumber();
	pixelSizeBx = Dialog.getNumber();
	pixelSizeBy = Dialog.getNumber();
	pixelSizeBz = Dialog.getNumber();

	// registration
	regChoice = Dialog.getRadioButton();// 1, 2, 3, 4;
	regMode = 1; 
	if(regChoice=="All images dependently"){
		regMode = 1;
		}
	else if(regChoice=="All images independently"){
		regMode = 2;
		}
	else if(regChoice=="One image only"){
		regMode = 3;
		}
	else if(regChoice=="No registration"){
		regMode = 4;
		}

	rotChoice = Dialog.getRadioButton();// 0, 1, -1;
	imBRotation = -1;
	if(rotChoice=="No rotation"){
		imBRotation = 0;
		}
	else if(rotChoice=="90 deg by Y-axis"){
		imBRotation = 1; // please add this choice to the cuda exe
		}
	else if(rotChoice=="-90 deg by Y-axis"){
		imBRotation = -1;
		}
	reg2Dtriger = Dialog.getCheckbox(); //true: 1, false: 0
	inputTmx = Dialog.getCheckbox(); //true: 1, false: 0
	if(inputTmx){
		reg2Dtriger = false;
		fileTmx =  File.openDialog("Select transform matrix file");
	}
	else{
		fileTmx = "Balabalabala";
	}
	saveReg = Dialog.getCheckbox(); //true: 1, false: 0
	fTol = Dialog.getNumber();

	iteration = Dialog.getNumber();
	bitPerSample = Dialog.getNumber();
	filePSFA = Dialog.getString();
	filePSFB = Dialog.getString();


	//Set GPU Options
	dQuery = Dialog.getCheckbox();
	deviceNum = Dialog.getNumber();
	cudaExe = pathCurrent + "CudaApp\\spimfusion_dualcolor.exe";

	print("Parameters set done!!!\n\n");

	print("Lauching cuda program...\n...\n");
	print("cuda program running...\n...\n");

	result = exec(cudaExe+" "+pathSPIMA1+" "+pathSPIMB1+" "+nameA1+" "+nameB1+" "+pathSPIMA2+" "+pathSPIMB2+" "+nameA2+" "+nameB2+" "+pathOutput+" "+imageNumStart+" "+imageNumEnd+" "+
		imageNumInterval+" "+imageNumTest+" "+pixelSizeAx+" "+pixelSizeAy+" "+
		pixelSizeAz+" "+pixelSizeBx+" "+pixelSizeBy+" "+pixelSizeBz+" "+regMode+" "+
		imBRotation+" "+reg2Dtriger+" "+inputTmx+" "+fileTmx+" "+saveReg+" "+fTol+" "+
		iteration+" "+bitPerSample+" "+filePSFA+" "+filePSFB+" "+dQuery+" "+deviceNum);

	print("caculation resoult:"+result);
}

}