macro "dispimfusion"{
// This macro is to create a simp User Interface within ImageJ and 
// launch the spimfusion.exe console and pass arguments to the console
// Min Guo, May 2017

//*** Default setup****
// Default folders/files for CUDA app
appPath = ".\\diSPIMFusion\\CudaApp\\";
filePSFA = ".\\diSPIMFusion\\PSFA.tif";
filePSFB = ".\\diSPIMFusion\\PSFB.tif";

// Default parameters
colorChoice="Single color";

nameA1 = "SPIMA_";
nameB1 = "SPIMB_";
nameA2 = "SPIMA_"; // for second color
nameB2 = "SPIMB_"; // for second color

pixelSizeAx = 0.1625;
pixelSizeAy = 0.1625;
pixelSizeAz = 1;
pixelSizeBx = 0.1625;
pixelSizeBy = 0.1625;
pixelSizeBz = 1;

regChoice = "All images dependently"; // registration mode
rotChoice = "-90 deg by Y-axis"; // rotation angle for SPIMB
reg2Dtriger = false; // do 2D registration or not
inputTmx = false;	// use customized transformation matrix input
saveReg = false; // save registerred images or not
fTol = 0.0001; // threshold/tolerance for registration convergence
iteration = 10; //iteration number for deconvolution
bitPerSample = 16; // output data bit: 16 or 32

dQuery = true; // show GPU information or not
deviceNum = 0; // GPU device #
memSave = false;

// Color options
Dialog.create("diSPIM Fusion Color Selection");
items = newArray("Single color", "Dual color");
Dialog.addRadioButtonGroup("Color Options", items, 2, 1, colorChoice);
Dialog.show();
colorChoice = Dialog.getRadioButton();

if(colorChoice=="Single color"){
	pathSPIMA1 = getDirectory("Select SPIMA (base images) folder");
	pathSPIMB1 = getDirectory("Select SPIMB folder");
	pathSPIMA2 = "...";
	pathSPIMB2 = "...";
	pathOutput = getDirectory("Select output folder");
	nameA2 = "..."; // for second color
	nameB2 = "..."; // for second color
	dualColor = false;
}
else{
	pathSPIMA1 = getDirectory("Select Color 1 SPIMA (base images) folder");
	pathSPIMB1 = getDirectory("Select Color 1 SPIMB folder");
	pathSPIMA2 = getDirectory("Select Color 2 SPIMA (base images) folder");
	pathSPIMB2 = getDirectory("Select Color 2 SPIMB folder");
	pathOutput = getDirectory("Select output folder");
	dualColor = true;
}

SPIMAList = getFileList(pathSPIMA1);
totalImageNum = lengthOf(SPIMAList);
imageNumStart = 0;
imageNumEnd = totalImageNum - 1;
imageNumInterval = 1;

print("Set input parameters...\n...\n");

Dialog.create("diSPIM Fusion");
	//input images parameters
Dialog.addString("SPIMA Directory",pathSPIMA1,80);
Dialog.addString("SPIMB Directory",pathSPIMB1,80);
Dialog.addString("ImageA Name",nameA1,20);
Dialog.addString("ImageB Name",nameB1,20);
Dialog.addString("Output Directory",pathOutput,80);
Dialog.addCheckbox("Dual Color", dualColor);
Dialog.addString("Color 2 SPIMA Directory",pathSPIMA2,80);
Dialog.addString("Color 2 SPIMB Directory",pathSPIMB2,80);
Dialog.addString("Color 2 ImageA Name",nameA2,20);
Dialog.addString("Color 2 ImageB Name",nameB2,20);
Dialog.addNumber("Start #", imageNumStart);
Dialog.addNumber("End #", imageNumEnd);
Dialog.addNumber("Interval", imageNumInterval);
Dialog.addNumber("Test #", imageNumStart);
Dialog.addMessage("Initial Pixel Size");
Dialog.addNumber("ImageA x", pixelSizeAx,4,6,"um");
Dialog.addNumber("ImageA y", pixelSizeAy,4,6,"um");
Dialog.addNumber("ImageA z", pixelSizeAz,4,6,"um");
Dialog.addNumber("ImageB x", pixelSizeBx,4,6,"um");
Dialog.addNumber("ImageB y", pixelSizeBy,4,6,"um");
Dialog.addNumber("ImageB z", pixelSizeBz,4,6,"um");

// registration parameters
items = newArray("All images dependently", "All images independently",  "One image only", "No registration");
Dialog.addRadioButtonGroup("Set Registration Options", items, 2, 2, regChoice);
items = newArray("No rotation", "90 deg by Y-axis",  "-90 deg by Y-axis");
Dialog.addRadioButtonGroup("ImageB Rotation", items, 1, 3, rotChoice);
Dialog.addCheckbox("Do 2D registration", reg2Dtriger);
Dialog.addCheckbox("Customize inital transformation matrix", inputTmx);
Dialog.addCheckbox("Save Registered Images", saveReg);
Dialog.addNumber("Convergence Threshold", fTol, 6, 8," ");
Dialog.addMessage("\n");

// Joint Deconvolution parameters
Dialog.addMessage("Set Deconvolution Options");
Dialog.addNumber("Iterations", iteration);
Dialog.addNumber("Output Image Bit", bitPerSample);

//GPU device settings
Dialog.addMessage("\n");
Dialog.addMessage("Set GPU Options");
Dialog.addCheckbox("Show GUP Device Information", dQuery);
Dialog.addNumber("GPU Device #", deviceNum);
Dialog.addCheckbox("GPU Memory Save Mode", memSave);

//default for cuda app
Dialog.addMessage("\n");
Dialog.addMessage("Default for CUDA app");
Dialog.addString("App location", appPath, 80);
Dialog.addString("PSFA", filePSFA, 80);
Dialog.addString("PSFB", filePSFB, 80);
Dialog.show();

//Get parameters from dialog
pathSPIMA1 = Dialog.getString();
pathSPIMB1 = Dialog.getString();
nameA1 = Dialog.getString();
nameB1 = Dialog.getString();
pathOutput = Dialog.getString();
dualColor = Dialog.getCheckbox();
pathSPIMA2 = Dialog.getString();
pathSPIMB2 = Dialog.getString();
nameA2 = Dialog.getString();
nameB2 = Dialog.getString();

imageNumStart = Dialog.getNumber();
imageNumEnd = Dialog.getNumber();
imageNumInterval = Dialog.getNumber();
imageNumTest = Dialog.getNumber();

pixelSizeAx = Dialog.getNumber();
pixelSizeAy = Dialog.getNumber();
pixelSizeAz = Dialog.getNumber();
pixelSizeBx = Dialog.getNumber();
pixelSizeBy = Dialog.getNumber();
pixelSizeBz = Dialog.getNumber();

// registration
regChoice = Dialog.getRadioButton();// 1, 2, 3, 4;
if(regChoice=="All images dependently"){
	regMode = 1;
}
else if(regChoice=="All images independently"){
	regMode = 2;
}
else if(regChoice=="One image only"){
	regMode = 3;
}
else if(regChoice=="No registration"){
	regMode = 4;
}

rotChoice = Dialog.getRadioButton();// 0, 1, -1;
if(rotChoice=="No rotation"){
	imBRotation = 0;
}
else if(rotChoice=="90 deg by Y-axis"){
imBRotation = 1; // please add this choice to the cuda exe
}
else if(rotChoice=="-90 deg by Y-axis"){
	imBRotation = -1;
}
reg2Dtriger = Dialog.getCheckbox(); //true: 1, false: 0
inputTmx = Dialog.getCheckbox(); //true: 1, false: 0
if(inputTmx){
	reg2Dtriger = false;
	fileTmx =  File.openDialog("Select transform matrix file");
}
else{
	fileTmx = "Balabalabala";
}
saveReg = Dialog.getCheckbox(); //true: 1, false: 0
fTol = Dialog.getNumber();
iteration = Dialog.getNumber();
bitPerSample = Dialog.getNumber();

//Set GPU Options
dQuery = Dialog.getCheckbox();
deviceNum = Dialog.getNumber();
memSave = Dialog.getCheckbox();

//CUDA app
appPath = Dialog.getString();
filePSFA = Dialog.getString();
filePSFB = Dialog.getString();

if(memSave){
	cudaExe = appPath + "spimfusion_memory_optimized.exe";
}
else{
	cudaExe = appPath + "spimfusion.exe";
}

print("Parameters set done!!!\n\n");

print("Lauching cuda program...\n...\n");
print("cuda program running...\n...\n");

// call CUDA app
if(dualColor==false){
	if(memSave){
		result = exec(cudaExe,pathSPIMA1,pathSPIMB1,nameA1,nameB1,pathOutput,imageNumStart,imageNumEnd,
			imageNumInterval,imageNumTest,pixelSizeAx,pixelSizeAy,
			pixelSizeAz,pixelSizeBx,pixelSizeBy,pixelSizeBz,regMode,
			imBRotation,reg2Dtriger,inputTmx,fileTmx,saveReg,fTol,
			iteration,bitPerSample,filePSFA,filePSFB,dQuery,deviceNum);
	}
	else{
		result = exec(cudaExe,pathSPIMA1,pathSPIMB1,nameA1,nameB1,pathOutput,imageNumStart,imageNumEnd,
			imageNumInterval,imageNumTest,pixelSizeAx,pixelSizeAy,
			pixelSizeAz,pixelSizeBx,pixelSizeBy,pixelSizeBz,regMode,
			imBRotation,reg2Dtriger,inputTmx,fileTmx,saveReg,fTol,
			iteration,bitPerSample,filePSFA,filePSFB,dQuery,deviceNum);
	}
	
}
else{
	if(memSave){
		result = exec(cudaExe,pathSPIMA1,pathSPIMB1,nameA1,nameB1,pathOutput,imageNumStart,imageNumEnd,
			imageNumInterval,imageNumTest,pixelSizeAx,pixelSizeAy,
			pixelSizeAz,pixelSizeBx,pixelSizeBy,pixelSizeBz,regMode,
			imBRotation,reg2Dtriger,inputTmx,fileTmx,saveReg,fTol,
			iteration,bitPerSample,filePSFA,filePSFB,dQuery,deviceNum,pathSPIMA2,pathSPIMB2,
			nameA2,nameB2);
	}
	else{
		result = exec(cudaExe,pathSPIMA1,pathSPIMB1,nameA1,nameB1,pathOutput,imageNumStart,imageNumEnd,
			imageNumInterval,imageNumTest,pixelSizeAx,pixelSizeAy,
			pixelSizeAz,pixelSizeBx,pixelSizeBy,pixelSizeBz,regMode,
			imBRotation,reg2Dtriger,inputTmx,fileTmx,saveReg,fTol,
			iteration,bitPerSample,filePSFA,filePSFB,dQuery,deviceNum,pathSPIMA2,pathSPIMB2,
			nameA2,nameB2);
	}
}

print("caculation result:"+result);
}