


import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;

import org.rhwlab.analysis.LeafReport;
import org.rhwlab.analysis.OnsetRDummy;
import org.rhwlab.dbaccess.DBAccess;
import org.rhwlab.sulston.StandardSulstonCA;

public class OnsetAndExpression {

	String			iSeries;
	String			iAceTreeConfigFilePath;
	String			iParent;
	//EmbryoXML		iEmbryoXML;
	//String			iAnnotsDir;
	String			iGene;
	Vector			iAllData;
	Vector			iLeafList;
	Hashtable		iLeafHash;
	Vector			iRealLeafList;
	Hashtable		iRealLeafHash;
	String			iLeafFate;
	int				iPlotVar;
	Vector			iSeriesData;
	Vector			iSeriesTimes;
	Vector			iCells;
	double			iPeakMax;
	Vector			iLeafReports;
	Hashtable		iCellTimes;
	PrintWriter		iPrintWriter;
	String			iPrefix;
	PrintWriter		iStaticPrintWriter;
	long			iStart;
	String			iLeavesFile;

	public OnsetAndExpression(String acetreeConfigFilePath, String gene) {
		iAceTreeConfigFilePath = acetreeConfigFilePath;
		iGene = gene;
		File f = new File(acetreeConfigFilePath);
        String series = f.getName();
        series = series.substring(0, series.length() - 4);
		iSeries = series;
		iParent = f.getParent();
		//iSeries = args[0];
		//iEmbryoXML = getEmbryoXML(iSeries);
		//iAnnotsDir = iEmbryoXML.iRecord[EmbryoXML.ANNOTS];
		iPlotVar = 7; //zblot
		iPrefix = "ZRLEXP";
		new StandardSulstonCA();
		readAllData();
		makeLeafList();
		iCellTimes = new Hashtable();
		//processLeaves();

	}

	void readAllData() {
		iAllData = new Vector();
		//String seriesFile = iAnnotsDir + "/dats/ZSCD" + iSeries + ".csv";
		String seriesFile = iParent + "/ZSCD" + iSeries + ".csv";
		//iGene = "gene"; //iEmbryoXML.iRecord[EmbryoXML.REDSIGNAL];
		try {
			FileInputStream fis = new FileInputStream(seriesFile);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
			br.readLine();
			while (br.ready()) {
				String s = br.readLine();
				iAllData.add(s);
				//println(s);
			}
			br.close();
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}
		iRealLeafList = new Vector();
		//iLeavesFile = iAnnotsDir + "/dats/LCD" + iSeries + ".csv";
		iLeavesFile = iParent + "/LCD" + iSeries + ".csv";
		try {
			FileInputStream fis = new FileInputStream(iLeavesFile);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
			br.readLine();
			while (br.ready()) {
				String s = br.readLine();
				iRealLeafList.add(s);
				//println(s);
			}
			br.close();
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}


	}

	void makeLeafList() {
		//String sfile2 = "/nfs/waterston/biowolp/sulston/leaves671.txt";
		iLeafList = new Vector();
		iLeafHash = new Hashtable();
	    URL url = OnsetRDummy.class.getResource("leaves671.txt");
	    InputStream istream = null;
		try {
	        istream = url.openStream();
			//FileInputStream fis = new FileInputStream(sfile2);
			BufferedReader br = new BufferedReader(new InputStreamReader(istream));
			while (br.ready()) {
				String s = br.readLine();
				if (s.length() <= 2) continue;
				//println("makeLeafList, " + s);
				String [] sa = s.split(C);
				iLeafList.add(sa[0]);
				iLeafHash.put(sa[0], sa[1]);

			}

		} catch(IOException ioe) {
			ioe.printStackTrace();
		}

	}


	void processLeaves() {
		//OnsetR oR = new OnsetR(iSeries);
		OnsetRDummy oR = new OnsetRDummy(iSeries, iLeavesFile);
		iLeafReports = oR.getLeafReportVector();
		println("processLeaves, A, " + iLeafReports.size());
		//println("processLeaves, B, " + (System.currentTimeMillis()  - iStart)/1000);
		//iLeafReports = readLeafReportsFromFile("leafReports.csv");
		LeafReport lr = null;
		for (int i=0; i < iLeafReports.size(); i++) {
			lr = (LeafReport)iLeafReports.get(i);
			//println("processLeaves, " + lr);
			long tx = System.currentTimeMillis();
			processLeaf(lr);
			//println("processLeaves, E, " + lr);

		}
		//println("processLeaves, C, " + (System.currentTimeMillis()  - iStart)/1000);
		reportResults();
		println("processLeaves, D, " + (System.currentTimeMillis()  - iStart)/1000);
	}

	void reportResults() {
		println("reportResults, entered, ");
		if (1 == 0) {
			makeLocalReport();
			return;
		}
		makePrintWriter();
		printHeader();
		for (int i=0; i < iLeafReports.size(); i++) {
			LeafReport lr = (LeafReport)iLeafReports.get(i);
			int determinant = Math.max(2000, (int)(0.1 * iPeakMax));
			boolean expression = false;
			lr.iExpressing = lr.iPeakExp >= determinant;
			iPrintWriter.println("" + lr);
		}
		iPrintWriter.close();

	}

	void makeLocalReport() {
		for (int i=0; i < iLeafReports.size(); i++) {
			LeafReport lr = (LeafReport)iLeafReports.get(i);
			int determinant = Math.max(2000, (int)(0.1 * iPeakMax));
			boolean expression = false;
			lr.iExpressing = lr.iPeakExp >= determinant;
			println("" + lr);
		}
	}

	void makePrintWriter() {
		PrintWriter pw = null;
		String outfile = iParent + "/" + iPrefix + iSeries + ".csv";
		println("makePrintWriter, " + outfile);
		try {
			FileOutputStream fos = new FileOutputStream(outfile);
			pw = new PrintWriter(fos, true);
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}
		iPrintWriter = pw;

	}

	void printHeader() {
		StringBuffer sb = new StringBuffer("cell");
		sb.append(C + "expressing");
		sb.append(C + "onset");
		sb.append(C + "peak");
		sb.append(C + "onsetCell");
		sb.append(C + "onsetTime");
		sb.append(C + "lifeFrac");
		sb.append(C + "fate");
		sb.append(C + "gene");
		sb.append(C + "series");
		iPrintWriter.println(sb.toString());

	}

	void processLeaf(LeafReport lr) {
		//if (lr.iOnset) println("processLeaf, A, " + lr);
		lr.iGene = iGene;
		String leaf = lr.iLeaf;
		lr.iFate = findRealLeafFate(leaf);
		iCells = getPath(leaf, 10);
		Vector v = new Vector();
		Vector vt = new Vector();
		boolean first = true;
		String currentCell = null;
		for (int i=0; i < iAllData.size(); i++) {

				String s = (String)iAllData.get(i);;
				String [] sa = s.split(C);
				boolean b = inCells(sa[1]);
				int time = Integer.parseInt(sa[2]);
				//b = b && time < iMaxTime;
				if (b) {
					if (!sa[1].equals(currentCell)) {
						currentCell = sa[1];
						Integer timeI = Integer.parseInt(sa[2]);
						iCellTimes.put(currentCell, timeI);
					}
					int t = Integer.parseInt(sa[2]);
					v.add(sa[iPlotVar]);
					vt.add(sa[2]);
					//println("processLeaf, " + s);
					//println("processLeaf, " + sa[1] + C + sa[2] + C + sa[iPlotVar]);
				}
			}
		iSeriesData = v;
		iSeriesTimes = vt;
		lr.iPeakExp = (int)getPeak();
		int time = 0;
		/****************8
		if (lr.iOnset) {
			time = onsetFromHighStart(lr.iOnsetTime);
			lr.iOnsetTime = time;
			if (time > 0) {
				lr.iOnset = true;

				String cname = getCell(time);
				lr.iOnsetCell = cname;
				String s = (String)StandardSulstonCA.cSulstonCATH.get(cname);
				String [] sa = s.split(C);
				int start = Integer.parseInt(sa[1]);
				int length = Integer.parseInt(sa[2]);
				lr.iFractionLifetime = ((double)time - start)/length;
			}
			//println("processLeaf, B, " + lr);



		}
		//time = Math.min(31, time);
		*/ // * ***********************************8/



	}

	String findRealLeafFate(String leafName) {
		String fate = null;
		for (int i=0; i < iLeafList.size(); i++) {
			String s = (String)iLeafList.get(i);
			if (s.startsWith(leafName)) {
				fate = (String)iLeafHash.get(s);
				break;
			}
		}
		return fate;
	}



	boolean inCells(String cname) {
		boolean b = false;
		for (int i=0; i < iCells.size(); i++) {
			b = cname.equals((String)iCells.get(i));
			if (b) break;

		}
		return b;
	}

	Vector getPath(String leaf, int stages) {
		boolean founder = false;
		Vector v = new Vector();
		String root = "P0";
		int count = 0;
		while(true) {
			v.add(0, leaf);
			if (leaf.equals(root)) break;
			if (++count == stages) break;
			int k = leaf.length();
			char c = leaf.charAt(k - 1);
			if (!founder) {
				if (Character.isLowerCase(c)) {
					leaf = leaf.substring(0, k - 1);
				} else {
					leaf = nextFounder(leaf);
					founder = true;
				}
			} else {
				leaf = nextFounder(leaf);
			}
		}
		return v;
	}

	String nextFounder(String leaf) {
		if (leaf.equals("AB")) leaf = "P0";
		else if (leaf.equals("C")) leaf = "P2";
		else if (leaf.equals("D")) leaf = "P3";
		else if (leaf.equals("P4")) leaf = "P3";
		else if (leaf.equals("P3")) leaf = "P2";
		else if (leaf.equals("P2")) leaf = "P1";
		else if (leaf.equals("P1")) leaf = "P0";
		else if (leaf.equals("E")) leaf = "EMS";
		else if (leaf.equals("MS")) leaf = "EMS";
		else if (leaf.equals("EMS")) leaf = "P1";
		else if (leaf.equals("Z2")) leaf = "P4";
		else if (leaf.equals("Z3")) leaf = "P4";
		return leaf;

	}

	boolean iDebug = false;

	double getPeak() {
		int n = 10;
		double sum = 0;
		Vector v = new Vector();
		//if (v.size() == 0) return 0;
		for (int i=0; i < n; i++) {
			//String s = (String)iSeriesData.get(i);
			double x = Double.parseDouble((String)iSeriesData.get(i));
			if (iDebug) println("getPeak, " + i + CS + x);
			sum += x;
			v.add(x);
		}
		double avg = sum / n;
		double peak = avg;
		for (int i = n; i < iSeriesData.size(); i++) {
			double a = (Double)v.remove(0);
			double b = Double.parseDouble((String)iSeriesData.get(i));
			int t = Integer.parseInt((String)iSeriesTimes.get(i));
			if (iDebug) println("getPeak, " + i + CS + b + CS + t);
			v.add(b);
			sum = sum - a + b;
			//println("getPeak, " + i + CS + avg + CS + b + CS + a + CS + testMean(v));
			avg = sum / n;
			if (avg > peak) {
				peak = avg;
				//println("getPeak, new, " + peak);
			}
		}

		if (peak > iPeakMax) iPeakMax = peak;
		return peak;
	}

	static final int
		 WINDOWWIDTH = 30
		;
	static final double
		 PVTEST = 1e-6
		;


	/**
	 * @param args
	 */
	public static void main(String[] args) {
		println("OnsetAndExpression.main, ");
		DBAccess.cDBLocation = null;
		if (args.length < 2) {
			println("please provide two arguments: ");
		    println("acetreeConfigFilePath gene");
			System.exit(0);
		}
		long start = System.currentTimeMillis();
		OnsetAndExpression oe = new OnsetAndExpression(args[0], args[1]);
		oe.iStart = start;
		oe.processLeaves();
		long duration = System.currentTimeMillis() - start;
		println("main, duration seconds=" + duration/1000);
		/* single leaf test procedure
		LeafReport lr = new LeafReport();
		lr.iLeaf = "ABplpaappaa";
		lr.iOnsetTime = 191;
		lr.iOnset = true;
		oe.processLeaf(lr);
		*/
	}
    public static void println(String s) {System.out.println(s);}
    public static void print(String s) {System.out.print(s);}
    public static final String CS = ", ", C = ",", Q = "\"";
    public static final String TAB = "\t", NULL = "";
    public static final DecimalFormat DF0 = new DecimalFormat("####");
    public static final DecimalFormat DF1 = new DecimalFormat("####.#");
    public static final DecimalFormat DF2 = new DecimalFormat("####.##");
    public static final DecimalFormat DF4 = new DecimalFormat("####.####");
    public static final DecimalFormat DFE = new DecimalFormat("0.####E0");

    public static String fmt4(double d) {return DF4.format(d);}
    public static String fmt2(double d) {return DF2.format(d);}
    public static String fmt1(double d) {return DF1.format(d);}
    public static String fmt0(double d) {return DF0.format(d);}
    public static String fmtE(double d) {return DFE.format(d);}

}
