import java.text.DecimalFormat;

import org.rhwlab.dbaccess.DBAccess;
import org.rhwlab.manifest.ManifestX;
import org.rhwlab.snight.Config;


public class ProcessAll {
	
	static long NOW;

	static long getProcessedMillis(long start) {
		NOW = System.currentTimeMillis();
		return (NOW - start);
	}



	/**
	 * @param args
	 */
	public static void main(String[] args) {
		println("ProcessAll.main, ");
        ManifestX.reportAndUpdateManifest();
        DBAccess.cDBLocation = ManifestX.getManifestValue("DBLocation");
		long start = System.currentTimeMillis();
		String configPath = args[0];
		Config config = new Config(configPath);
		int timepts = 0;
		if (args.length > 1) timepts = Integer.parseInt(args[1]);
		timepts = config.iEndingIndex;
		println("main, " + config);
		String [] sa = new String[2];
		sa[0] = configPath;
		sa[1] = String.valueOf(timepts);
		Measure1.main(sa);
		long now = System.currentTimeMillis();
		println("PROCESSALL, Measure1 completed in " + getProcessedMillis(start));
		sa[0] = configPath;
		sa[1] = String.valueOf(timepts);
		RedExtractor1.main(sa);
		println("PROCESSALL, RedExtractor1 completed in " + getProcessedMillis(NOW));
		sa[0] = configPath;
		sa[1] = String.valueOf(timepts);
		RedExcel2.main(sa);
		println("PROCESSALL, RedExcel2 completed in " + getProcessedMillis(NOW));
		sa[0] = configPath;
		sa[1] = String.valueOf(timepts);
		Align1.main(sa);
		println("PROCESSALL, Align1 completed in " + getProcessedMillis(NOW));

		sa[0] = configPath;
		sa[1] = String.valueOf(timepts);
		ZExpUpdate.main(sa);
		println("PROCESSALL, ZExpUpdate completed in " + getProcessedMillis(NOW));
		sa[0] = configPath;
		sa[1] = String.valueOf(timepts);
		OnsetAndExpression.main(sa);
		println("PROCESSALL, OnsetAndExpression completed in " + getProcessedMillis(NOW));
		
		
		
		println("PROCESSALL, " + configPath + ", complete in " + getProcessedMillis(start));

	}

	private static void println(String s) {System.out.println(s);}
    private static void print(String s) {System.out.print(s);}
    private static final String CS = ", ", C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");
    private static String fmt4(double d) {return DF4.format(d);}
    private static String fmt1(double d) {return DF1.format(d);}
    private static String fmt0(double d) {return DF0.format(d);}

}
