import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import org.rhwlab.analysis.EmbryoData;
import org.rhwlab.dbaccess.DBAccess;
import org.rhwlab.manifest.ManifestX;
import org.rhwlab.snight.Config;
public class RedExcel1 {


    private static String [] fleshOutArgs(String [] args) {
    	// assume args.length = 2 or 3
    	// and the arg[0] is a full path to an AceTree config file
    	// and args[1] is the number of time points
    	// and args[2] if present is a word thing lime "none", "global", "local", "blot"
    	// the words are defined in Config.REDCHOICE
        String [] args2 = new String[5];

        File atconfigFile = new File(args[0]);
        String series = atconfigFile.getName();
        series = series.substring(0, series.length() - 4);

        args2[0] = series;
        if (args.length > 2) args2[1] = args[2];
        else args2[1] = "blot";

        String csvFileName = atconfigFile.getParent();
        csvFileName += "/S" + series + ".csv";
        args2[2] = csvFileName;
        args2[3] = args[0]; // this is the AceTree config file path
        args2[4] = args[1];
        return args2;
    }


    public static void main(String [] args) {
		ManifestX.reportAndUpdateManifest();
    	try {
        	args = fleshOutArgs(args);
    		EmbryoData.spreadsheet1(args);
    	} catch(Exception e) {
    		e.printStackTrace();
    	}
    }

    private static void println(String s) {System.out.println(s);}
    private static final String CS = ", ", C = ",";

}
