import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;



public class RedExcel1N {

	String [] 		iVarNames;
	Hashtable		iSeriesHash;
	Vector			iLeaves;
	int				iDatum;
	String			iSeriesName;
	Vector			iLeavesHandled;

	public RedExcel1N() {

	}

	void readSeries(String pathname, String datum) {
		File f = new File(pathname);
		String name = f.getName();
		//println("readSeries, " + name);
		name = name.substring(0, name.indexOf("."));
		//println("readSeries, " + name);
		for (int i=0; i < name.length(); i++){
			if (Character.isDigit(name.charAt(i))) {
				name = name.substring(i, name.length());
				break;
			}
		}
		//println("readSeries, " + name);
		iSeriesName = name;
		iSeriesHash = new Hashtable();
		try {
			FileInputStream fis = new FileInputStream(pathname);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
			String s = br.readLine(); //toss header
			iVarNames = s.split(C);
			for (int i=0; i < iVarNames.length; i++) {
				if (iVarNames[i].equals(datum)) {
					iDatum = i;
					break;
				}
			}
			while (br.ready()) {
				s = br.readLine();
				//println("readSeries, " + s);
				addToHash(s);
			}
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}

	}

	void addToHash(String s) {
		String [] sa = s.split(C);
		String cellName = sa[1];
		Vector v = (Vector)iSeriesHash.get(cellName);
		if (v == null) {
			v = new Vector();
			iSeriesHash.put(cellName, v);
		}
		v.add(0,s);
	}


	void readLeaves() {
		iLeaves = new Vector();
	    URL url = RedExcel1N.class.getResource("LCD20081128_sulston.csv");
	    InputStream istream = null;
	    try {
	        istream = url.openStream();
	        BufferedReader br = new BufferedReader(new InputStreamReader(istream));
	        String s;
	        br.readLine(); //toss the header
	        while (br.ready()) {
	            s = br.readLine();
	            if (s.length() == 0) continue;
	            //println("readLeaves, " + s);
	            iLeaves.add(s);
	        }
	        br.close();
	    } catch(Exception e) {
	        e.printStackTrace();
	    }
	}

	void processLeaves() {
		iLeavesHandled = new Vector();
		for (int i=0; i < iLeaves.size(); i++) {
			String leaf = (String)iLeaves.get(i);
			if (iLeavesHandled.contains(leaf)) continue;
			//println("processLeaves, 1, " + i + CS + leaf);
			String s = processLeaf(leaf);
			if (s == null) continue;
			println(s);
			//break;

		}

	}

	String processLeaf(String cellName) {
		Vector v = null;
		for (int i=0; i < 10; i++) {
			//println("processLeaf, " + cellName);
			v = (Vector)iSeriesHash.get(cellName);
			if (v != null) break;
			cellName = getParent(cellName);
		}
		String leaf = cellName;
		if (iLeavesHandled.contains(leaf)) return null;
		iLeavesHandled.add(leaf);
		StringBuffer sb = new StringBuffer();
		int count = 0;
		while (cellName != null && v != null && count < 20) {
			for (int i=0; i < v.size(); i++) {
				String s = (String)v.get(i);
				String [] sa = s.split(C);
				int x = Integer.parseInt(sa[9]);
				if (x == 0) continue;
				//println("processLeaf, " + s);
				String d = sa[iDatum];
				d = dataCorrection(iDatum, sa);
				sb.insert(0, d);
				sb.insert(0, C);
			}
			cellName = getParent(cellName);
			if (sb.length() == 0) {
				leaf = cellName;
				if (iLeavesHandled.contains(leaf)) return null;
				iLeavesHandled.add(leaf);
			}
			if (cellName == null) break;
			v = (Vector)iSeriesHash.get(cellName);
			//println("processLeaf, 2, " + cellName + CS + v);
			count++;
		}
		sb.insert(0, leaf);
		sb.insert(0, C);
		sb.insert(0, iSeriesName);
		return sb.toString();
	}

	String dataCorrection(int datum, String [] data) {
		boolean doCorrection = false;
		if (!doCorrection) return data[datum];
		else {
			// put processing in here such as
			double z = Double.parseDouble(data[8]);
			int blot = Integer.parseInt(data[datum]);
			double blotc = blot / (1 - .033 * (z - 15));
			int intBlot = (int)Math.round(blotc);
			return String.valueOf(intBlot);
		}
	}

	String getParent(String cellName) {
		//println("getParent, " + cellName);
		char c = cellName.charAt(cellName.length() - 1);
		if (Character.isLowerCase(c)) {
			cellName = cellName.substring(0, cellName.length() - 1);
		} else cellName = getFounderParent(cellName);
		return cellName;
	}

	String getFounderParent(String cellName) {
		if (cellName.equals("P1")) return "P0";
		if (cellName.equals("AB")) return "P0";
		if (cellName.equals("P2")) return "P1";
		if (cellName.equals("EMS")) return "P1";
		if (cellName.equals("E")) return "EMS";
		if (cellName.equals("MS")) return "EMS";
		if (cellName.equals("C")) return "P2";
		if (cellName.equals("P3")) return "P2";
		if (cellName.equals("D")) return "P3";
		if (cellName.equals("P4")) return "P3";
		if (cellName.startsWith("Z")) return "P4";

		else return null;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// nominal arguments
		// arg[0] = full path name to CD..csv file
		// arg[1] = name of data item to be used
		// it can be anything on the CS..csv file in principle
		String item = "blot";
		if (args.length > 1) item = args[1];
		RedExcel1N re = new RedExcel1N();
		re.readLeaves();
		re.readSeries(args[0], item);
		re.processLeaves();

	}

    private static void println(String s) {System.out.println(s);}
    private static final String CS = ", ", C = ",";

}
