

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

import org.rhwlab.dbaccess.EmbryoXML;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.vembryo.Vembryo4;

public class ZExpUpdate {

	String			iSeries;
	//String			iAnnotsDir;
	String			iAceTreeConfigFilePath;
	String			iParent;
	//EmbryoXML		iEmbryoXML;
	String			iInfile;
	String			iOutfile;
	Vector			iOutput;
	String []		iHeader;
	Vector			iSulston350Cells;
	Hashtable		iHSave;

	static int SULSTON350TIME = 251;

	public ZExpUpdate(String acetreeConfigFilePath) {
		iAceTreeConfigFilePath = acetreeConfigFilePath;
		File f = new File(acetreeConfigFilePath);
        String series = f.getName();
        series = series.substring(0, series.length() - 4);
		iSeries = series;
		iParent = f.getParent();
		//getEmbryoXML();
		//println("ZExpUpdate, " + iAnnotsDir);
		iOutput = new Vector();
		iSulston350Cells = getSulston350Cells();


	}

	void readSCD() {
		String activeCell = "XXX";
		boolean extendable = false;
		boolean extended = false;
		Hashtable hSave = null;
		int k = 0;
		String parent = new File(iAceTreeConfigFilePath).getParent();
		iInfile = parent + "/SCD" + iSeries + ".csv";
		println("readSCD, " + iInfile);
		//iInfile = iAnnotsDir + "/dats/SCD" + iSeries + ".csv";
		try {
			FileInputStream fis = new FileInputStream(iInfile);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
			while(br.ready()) {
				String s = br.readLine();
				if (s.length() < 2) continue;
				//println("readSCD, " + s);
				String [] sa = s.split(C);
				if (k++ == 0) {
					iHeader = sa;
					for (int i=0; i < iHeader.length; i++) {
						if (iHeader[i].equals("cross")) iHeader[i] = "zblot";
						//println(i + CS + iHeader[i]);
					}
					continue;
				}
				Hashtable h = makeLineHash(iHeader, s);
				if (h == null) continue;
				String cell = (String)h.get("cell");
				if (!cell.equals(activeCell)) {
					extended = false;
					activeCell = cell;
				}


				//println("readSCD, " + s);
				if (!processLine(h) && !extended) {
					if (iHSave == null) continue;
					cell = (String)iHSave.get("cell");
					extendable = iSulston350Cells.contains(cell);
					if (!extendable) continue;
					String stlast = (String)iHSave.get("time");
					int tlast = Integer.parseInt(stlast);
					for (int t = tlast + 1; t < SULSTON350TIME; t++) {
						iHSave.put("time", String.valueOf(t));
						processLine(iHSave);
					}
					extended = true;
				}
			}
			br.close();

		} catch(IOException ioe) {
			ioe.printStackTrace();
		}
	}

	boolean processLine(Hashtable h) {

		String cell = (String)h.get("cell");
		if (cell.equals("ABalapaaaa")) {
			StringBuffer sb = new StringBuffer();
			sb.append((String)h.get(iHeader[0]));
			for (int i=1; i < iHeader.length; i++) {
				String ss = (String)h.get(iHeader[i]);
				sb.append(C + ss);
			}
			//println("processLine, " + sb.toString());

		}



		double midPlane = 15;
		double zcorSlope = 0.0331;
		String s = (String)h.get("none");
		if (s.equals("0")) {
			return false; // we omit such lines
		}
		s = (String)h.get("blot");
		double blot = Double.parseDouble(s);
		s = (String)h.get("zraw");

		double z = Double.parseDouble(s);
		double zb = blot * ( 1 + (z - midPlane) * zcorSlope);
		int zblot = (int)Math.round(zb);
		h.put("zblot", String.valueOf(zblot));
		StringBuffer sb = new StringBuffer();
		sb.append((String)h.get(iHeader[0]));
		for (int i=1; i < iHeader.length; i++) {
			sb.append(C + (String)h.get(iHeader[i]));
		}
		iOutput.add(sb.toString());
		//println("processLine, " + sb.toString());
		iHSave = h;
		return true;
	}

	public static Hashtable makeLineHash(String [] header, String s) {
		Hashtable h = new Hashtable();
		String [] sa = s.split(C);
		try {
		for (int i=0; i < header.length; i++) {
			h.put(header[i], sa[i]);
		}
		} catch(ArrayIndexOutOfBoundsException aiobe) {
			return null;
		}
		return h;

	}

	void writeZSCD() {
		PrintWriter pw = null;
		String outfile =  iParent + "/ZSCD" + iSeries + ".csv";;
		println("writeZSCD, " + outfile);
		try {
			FileOutputStream fos = new FileOutputStream(outfile);
			pw = new PrintWriter(fos, true);
		} catch(IOException ioe) {
			ioe.printStackTrace();
		}
		pw.println(stringFromArray(iHeader));
		for (int i=0; i < iOutput.size(); i++) {
			String s = (String)iOutput.get(i);
			pw.println(s);
		}
		if (pw != null) pw.close();

	}

	String stringFromArray(String [] sa) {
		StringBuffer sb = new StringBuffer(sa[0]);
		for (int i=1; i < sa.length; i++) {
			sb.append(C + sa[i]);

		}
		return sb.toString();
	}

	/*
	void getEmbryoXML() {
		iEmbryoXML = getEmbryoXML(iSeries);
		String annots = iEmbryoXML.iRecord[EmbryoXML.ANNOTS];
		iAnnotsDir = annots;

	}

	EmbryoXML getEmbryoXML(String series) {
    	EmbryoXML exml = null;
		try{
    		exml = new EmbryoXML(series);
    	} catch(FileNotFoundException fnfe) {
    		fnfe.printStackTrace();
    	}
    	return exml;
	}
	*/

	Vector getSulston350Cells() {
        String series = "20081128_sulston";
        int time = 250;
        Vembryo4 ve4 = new Vembryo4(series, "CD");
        Vector nr = ve4.getNucleiRecord();
        Vector nuclei = (Vector)nr.get(time - 1);
        Vector s = new Vector();
        for (int i=0; i < nuclei.size(); i++) {
        	Nucleus n = (Nucleus)nuclei.get(i);
        	s.add(n.identity);
        }
        Collections.sort(s);
        println("getSulston350Cells, " + s.size());

        for (int i=0; i < s.size(); i++) {
        	String cs = (String)s.get(i);
        	//println("sulstonTest, " + i + CS + cs);

        }

		return s;
	}

	static void driver() {
		Vector reps = new Vector();
		String repsList = "/nfs/waterston/acexpress/lists/representativePromoters.txt";
		String filePath = repsList;
		try {
			FileInputStream fis = new FileInputStream(filePath);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
			while (br.ready()) {
				String s = br.readLine();
				if (s.length() < 2) continue;
				if (s.startsWith("#")) continue;
				reps.add(s);
			}

		} catch(IOException ioe) {
			ioe.printStackTrace();
		}
		String wildList = "/nfs/waterston/acexpress/lists/WildTypeList.txt";
		//wildList = "seriesList.txt";
		filePath = wildList;
		try {
			FileInputStream fis = new FileInputStream(filePath);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
			while (br.ready()) {
				String s = br.readLine();
				if (s.length() < 2) continue;
				if (s.startsWith("#")) continue;
				if (!reps.contains(s)) {
					println("driver, " + s);
					//String [] sa = s.split(" ");
					//ZExpUpdate zeu = new ZExpUpdate(sa[0]);
					//zeu.readSCD();
					//zeu.writeZSCD();

				}
			}

		} catch(IOException ioe) {
			ioe.printStackTrace();
		}

	}



	/**
	 * @param args
	 */
	public static void main(String[] args) {
		println("ZExpUpdate.main, " + args[0]);
		//driver();
		//*
		ZExpUpdate zeu = new ZExpUpdate(args[0]);
		zeu.readSCD();
		zeu.writeZSCD();
		//*/


	}

    private static void println(String s) {System.out.println(s);}
    private static void print(String s) {System.out.print(s);}
    private static final String CS = ", ", C = ",", Q="\"";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF2 = new DecimalFormat("####.##");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");
    private static String fmt4(double d) {return DF4.format(d);}
    private static String fmt2(double d) {return DF2.format(d);}
    private static String fmt1(double d) {return DF1.format(d);}
    private static String fmt0(double d) {return DF0.format(d);}

}
