/*
 * Copyright 2005 University of Washington Genome Sciences
 * All rights reserved
 */
package org.rhwlab.image;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.io.TiffDecoder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

import org.rhwlab.snight.Nucleus;
import org.rhwlab.utils.EUtils;

/**
 * Provides a JFrame window to contain the ImageJ ImagePlus object
 * 
 * @author biowolp
 * @version 1.0 January 25, 2005
 */
public class ImageWindowX {
    ImageCanvas             iImgCanvas;
    static ImagePlus        iImgPlus;
    String                  iTitle;
    static Object []        iSpecialEffect;
    Vector                  iAnnotsShown;
    boolean                 iMouseEventHandled;
    int                     iImageTime;
    int                     iTimeInc;
    int                     iImagePlane;
    int                     iPlaneInc;
    boolean                 iIsMainImgWindow;
    boolean                 iIsRightMouseButton;
    boolean                 iSaveImage;
    boolean                 iSaveInProcess;
    boolean                 iNewConstruction;
    //private JTabbedPane     iTabbedPane;
    private JPanel          iControlPanel;
    protected JMenuBar      iMenuBar;
    protected JToolBar      iToolBar;
    protected JButton	    iHelp;
    protected JButton       iProperties;
    
    static boolean         cAcbTree = false;

    static byte []          iRpix;
    static byte []          iGpix;
    static byte []          iBpix;
    


    // static variables and functions
    
    public static String        cZipTifFilePath;
    public static String        cTifPrefix;
    public static String        cTifPrefixR;
    public static int           cUseZip;
    public static int           cImageWidth;
    public static int           cImageHeight;
    public static int           cLineWidth;
    public static String        cCurrentImageFile;
    
    static ZipImage             cZipImage;

    /**
     * this is the constructor that is actually used
     * note that there are many static functions and class variables
     */
    public ImageWindowX(String title, ImagePlus imgPlus) {
        iTitle = title;
        iImgPlus = imgPlus;
    }
    



    private static void showError(String fileName) {
	new Throwable().printStackTrace();
        String message = "Exiting: cannot find image\n";
        message += fileName;
        JOptionPane pane = new JOptionPane(message);
        JDialog dialog = pane.createDialog(null, "Error");
        dialog.show();
    }
    
    public static ImagePlus makeImage(String s) {
        //System.out.println("makeImage: " + s + CS + cUseZip);
        cCurrentImageFile = s;
        //new Throwable().printStackTrace();
        ImagePlus ip = null;
        //iSpecialEffect = null;
        //if (iSpecialEffect != null) iSpecialEffect = null;

        
        switch(cUseZip) {
        case 0:
            ip = doMakeImageFromTif(s);
            break;
        case 1:
            //ip = doMakeImageFromZip(s);
            break;
        default:
            ip = doMakeImageFromZip2(s);
            break;
            
        }
        /*
        if (cUseZip == 0) {
            ip = doMakeImageFromTif(s);
        } else {
            ip = doMakeImageFromZip(s);
        }
        */
        //if (cImageWidth == 0 && ip != null) {
        if (ip != null) {
            cImageWidth = ip.getWidth();
            cImageHeight = ip.getHeight();
            //System.out.println("***ImageWindow: " + cImageWidth + CS + cImageHeight);
        }
        if (ip == null) return iImgPlus;
        else return ip;
    }
    
    public static ImagePlus doMakeImageFromTif(String s) {
        //System.out.println("ImageWindow.doMakeImageFromTif entered: " + s);
        FileInputStream fis;
        ImagePlus ip = null;
        String ss = cZipTifFilePath + "/" + s;
        //System.out.println("ImageWindow.makeImage entered: " + ss);
        
        
        ip = new Opener().openImage(ss);
        
        

        /*
        
        if (ip != null) {
            ip = convertToRGB(ip);
        } else {
            ip = new ImagePlus();
            ImageProcessor iproc = new ColorProcessor(cImageWidth, cImageHeight);
            ip.setProcessor(s, iproc);
        }
        */
        return ip;
    }

    
    public static ImagePlus doMakeImageFromZip2(String s) {
        cZipImage = new ZipImage(cZipTifFilePath + "/" + s);
        int k1 = s.indexOf("/") + 1;
        String ss = s.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ss += ".tif";
        ZipEntry ze = null;
        if (cZipImage != null) ze = cZipImage.getZipEntry(ss);
        ImagePlus ip;
        if (ze == null) {
            ip = new ImagePlus();
            ImageProcessor iproc = new ColorProcessor(cImageWidth, cImageHeight);
            ip.setProcessor(s, iproc);
        }
        else ip = cZipImage.readData(ze);
        return ip;
    }



    public static ImagePlus readData(FileInputStream fis, boolean bogus) {
        if (fis == null) return null;
        int byteCount;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            InputStream is = (InputStream)fis;
            byte data[] = new byte[DATA_BLOCK_SIZE];

            //  4. read source zipped data and write to uncompressed stream
            while ( (byteCount = is.read(data, 0, DATA_BLOCK_SIZE)) != -1) {
                out.write(data, 0, byteCount);
            }
        } catch(IOException ioe) {
            ioe.printStackTrace();
        }
        return openTiff(new ByteArrayInputStream(out.toByteArray()), true);

    }
    
    public static ImagePlus readData(FileInputStream fis) {
        if (fis == null) return null;
        byte [] ba = readByteArray(fis);
        return openTiff(new ByteArrayInputStream(ba), true);
    }
    
    public static byte[] readByteArray(FileInputStream fis) {
        if (fis == null) return null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int byteCount;
        byte[] buf = new byte[4096];
        try {
            InputStream is = (InputStream)fis;
            byte data[] = new byte[DATA_BLOCK_SIZE];

            //  4. read source zipped data and write to uncompressed stream
            while ( (byteCount = is.read(data, 0, DATA_BLOCK_SIZE)) != -1) {
                out.write(data, 0, byteCount);
            }
        } catch(IOException ioe) {
            ioe.printStackTrace();
        }
        return out.toByteArray();

    }
    
    /** Attempts to open the specified inputStream as a
    TIFF, returning an ImagePlus object if successful. */
    public static ImagePlus openTiff(InputStream in, boolean convertToRGB) {
        //System.out.println("openTiff entered");
        if (in == null) return null;
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, null);
            info = td.getTiffInfo();
        } catch (FileNotFoundException e) {
            IJ.error("TiffDecoder", "File not found: "+e.getMessage());
            return null;
        } catch (Exception e) {
            IJ.error("TiffDecoder", ""+e);
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) // dump tiff tags
            IJ.log(info[0].info);
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        // detect 8 bit or RGB from the FileInfo object info[0]
        if (info[0].getBytesPerPixel() == 1 && convertToRGB) {
            imp = convertToRGB(imp);
        }
        //IJ.showStatus("");
        return imp;
    }

    /**
     * If the images in the zip archive are 8 bit tiffs,
     * we use that as the green plane of an RGB image processor
     * so the program is always showing RGB images
     * 
     * @param ip an Image processor obtained from the image file
     * @return
     */
    private static ImagePlus convertToRGB(ImagePlus ip) {
        //System.out.println("convertToRGB entered");
        ImageProcessor iproc = ip.getProcessor();
        byte [] bpix = (byte [])iproc.getPixels();
        byte [] R = new byte[bpix.length];
        byte [] G = new byte[bpix.length];
        byte [] B = new byte[bpix.length];
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.getRGB(R, G, B);
        // special test removal
        G = bpix;
        R = getRedChannel(R);
        // special test insert
        //byte [] ba = getRedChannel(R);
        //System.arraycopy(ba, 0, R, 0, ba.length);
        //System.arraycopy(ba, 0, G, 0, ba.length);
        //System.arraycopy(ba, 0, B, 0, ba.length);
        //R = ba;
        //G = ba;
        //B = ba;
        
        // end special
        iRpix = R;
        iGpix = G;
        iBpix = B;
        return buildImagePlus(ip);
        //iproc3.setRGB(R, G, B);
        //ip.setProcessor("test", iproc3);
        //return ip;    
    }
    
    private static ImagePlus buildImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, iGpix, iBpix);
        ip.setProcessor("test", iproc3);
        return ip;
        
    }
    
    protected static ImagePlus makeRedImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, new byte[iRpix.length], new byte[iRpix.length]);
        ip.setProcessor("test", iproc3);
        return ip;
    }
    
    protected static ImagePlus makeGreenImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        //System.out.println("makeGreenImagePlus: " + iproc);
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        //System.out.println("makeGreenImagePlus2: " + iproc + CS + iGpix  + CS + iRpix);
        iproc3.setRGB(new byte[iRpix.length], iGpix, new byte[iRpix.length]);
        ip.setProcessor("test", iproc3);
        return ip;
    }
    
    protected static ImagePlus makePlainImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        if (cAcbTree) {
            iproc3.setRGB(iRpix, iRpix, iRpix);
        } else {
            iproc3.setRGB(new byte[iRpix.length], new byte[iRpix.length], new byte[iRpix.length]);
            
        }
        ip.setProcessor("test", iproc3);
        return ip;
    }
    
    
    
    private static byte[] getRedChannel(byte [] R) {
        String fileName = ""; //makeRedChannelName();
        //println("getRedChannel: " + fileName);
        File f = new File(fileName);
        if (f.exists()) {
            FileInputStream fis;
            ImagePlus ip = null;
            ip = new Opener().openImage(fileName);
            if (ip != null) {
                ByteProcessor bproc = (ByteProcessor)ip.getProcessor();
                R = (byte [])bproc.getPixels();
            }
        }
        return R;
        
    }
    
    
    // end of static stuff
    
    public ImageWindowX() {
        
    }
    
    /**
     * this constructor for test purposes only
     */
    public ImageWindowX(String title, ImagePlus imgPlus, boolean test) {
        iTitle = title;
        iImgPlus = imgPlus;
        ImageCanvas ic = new ImageCanvas(imgPlus);
        iImgCanvas = ic;
        
    }


    



    


    
    /* (non-Javadoc)
     * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
     */
    public void quickRefresh() {
        iImgCanvas.repaint();
    }
    
    public void setSpecialEffect(Object [] specialEffect) {
        iSpecialEffect = specialEffect;
    }
    
    
    private void redrawMe() {
        iImgCanvas.repaint();
    }

    protected void setImageTimeAndPlaneFromTitle() {
        //System.out.println("setImage..: " + iTitle);
        int k = iTitle.lastIndexOf(DASHT) + DASHT.length();
        //System.out.println("setImage..: " + k);
        String time = iTitle.substring(k, k + 3);
        //System.out.println("setImage..: " + time);
        iImageTime = Integer.parseInt(time);
        String s = iTitle.substring(k);
        //System.out.println("setImage..: " + s);
        k = s.indexOf(DASHP) + DASHP.length();
        String plane = s.substring(k, k + 2);
        //System.out.println("setImage..: " + plane);
        iImagePlane = Integer.parseInt(plane);
        iTimeInc = 0;
        iPlaneInc = 0;
        String random = RANDOMT;
        if (cUseZip > 0) random = RANDOMF;
        iIsMainImgWindow = iTitle.indexOf(random) == -1;
    }

    
    public ImageCanvas getCanvas() {
        return iImgCanvas;
    }
    
    public ImagePlus getImagePlus() {
        return iImgPlus;
    }
    
    ////////////////////////////////////////
    
    
    
    public void clearAnnotations() {
        iAnnotsShown.clear();
    }
    
    public void setSaveImageState(boolean saveIt) {
        iSaveImage = saveIt;
    }
    
    public Object [] getSpecialEffect() {
        return iSpecialEffect;
    }
    
    protected static final String
    RANDOMF = ".zip0"
   ,RANDOMT = ".tif0"
   ,DASHT = "-t"
   ,DASHP = "-p"
   ;

    public static void main(String[] args) {
        System.out.println("ImageWindow main");
        test3();
    }
    
    public static void test3() {
        FileInputStream fis;
        ImagePlus ip = null;
        String ss = "/home/biowolp/AncesTree/temp2/images/050405-t050-p15.tif";
        try {
            fis = new FileInputStream(ss);
            byte [] ba = readByteArray(fis);
            ip = openTiff(new ByteArrayInputStream(ba), false);
            //ip = readData(fis);
        } catch(IOException ioe) {
            System.out.println("ImageWindow.test3 exception ");
            System.out.println(ioe);
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        System.out.println("width, height: " + width + CS + height);
        ByteProcessor bproc = new ByteProcessor(width, height);
        //test(bproc);
        ImagePlus ip2 = new ImagePlus("newtest3", bproc);
        ij.gui.ImageWindow iImgWin = new ij.gui.ImageWindow(ip2);
        
        FileSaver fs = new FileSaver(ip2);
        fs.saveAsTiff();
        
    }
    
    public static void test(ImageProcessor ip) {
        byte [] pixels = (byte [])ip.getPixels();
        int width = ip.getWidth();
        OvalRoi oRoi = new OvalRoi(560, 130, 55, 55);
        ip.setRoi(oRoi);
        Rectangle r = ip.getRoi();
        int offset, i;
        for (int y=r.y; y < (r.y + r.height); y++) {
            offset = y * width;
            for (int x = r.x; x < (r.x + r.width); x++) {
                i = offset + x;
                if (oRoi.contains(x, y)) {
                    pixels[i] = (byte)(128.*Math.random());
                }
            }
        }
    }

    public static final Integer
         ANTERIOR = new Integer(1)
        ,POSTERIOR = new Integer(2)
        ,NONE = new Integer(0)
        ;
    
    private static final String
         CS = ", "
        ;
    
    private static final int
    DATA_BLOCK_SIZE  = 2048
   //,LINEWIDTH = 1
   ;
    
    public static final int 
         NCENTROID = 0
        ,SCENTROID = 1
        ,ANNOTATIONS = 2
        ,UPPERSIS = 3
        ,LOWERSIS = 4
        ,LINEWIDTH = 5
        ;

    public static final Color [] COLOR = {
            Color.RED
            ,new Color(140,70,255)
            ,Color.GREEN
            ,Color.YELLOW
            ,Color.CYAN
            ,Color.MAGENTA
            ,Color.PINK
            ,Color.LIGHT_GRAY
            ,Color.WHITE
    };
    
    public static final int [] WIDTHS = {1,2,3};
    
    private static void println(String s) {System.out.println(s);}

    /* (non-Javadoc)
     * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
     */
    public void keyReleased(KeyEvent e) {
        // TODO Auto-generated method stub
        
    }


    /* (non-Javadoc)
     * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
     */
    public void keyTyped(KeyEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}
