package org.rhwlab.sulston;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;

import org.rhwlab.tree.Cell;
import org.rhwlab.vembryo.Vembryo3;

public class StandardSulstonCA {

	public static Hashtable 		cSulstonCATH;

	public StandardSulstonCA() {
		if (cSulstonCATH == null) {
			cSulstonCATH = processResourceFile();
		}
	}

	public static int getSulstonTime(String cname, double frac) {
		if (cSulstonCATH == null) {
			return 0;
		}
		String s = (String)cSulstonCATH.get(cname);
		//println("getSulstonTime, " + s);
		String [] sa = s.split(C);
		int base = Integer.parseInt(sa[1]);
		int inc = (int)Math.round(Integer.parseInt(sa[2]) * frac);
		return base + inc;
	}






	Hashtable processResourceFile() {
		//println("processResourceFile, ");
		Hashtable h = new Hashtable();
	    URL url = this.getClass().getResource("/org/rhwlab/sulston/SulstonCAT.csv");
	    InputStream istream = null;
	    try {
	        istream = url.openStream();
	        BufferedReader br = new BufferedReader(new InputStreamReader(istream));
	        String s;
	        br.readLine(); //toss the header
	        while (br.ready()) {
	            s = br.readLine();
	            if (s.length() < 2) continue;
				String [] sa = s.split(C);
				h.put(sa[0], s);
				//int tt = Integer.parseInt(sa[2]);
				//if (tt > 100) println("processResourceFile, " + s);
	        }
	        br.close();
	    } catch(Exception e) {
	        e.printStackTrace();
	    }
	    return h;
	}


	void test() {
		int count = 0;
		String csvPath = "/net/waterston/vol1/annots/biowolp/20081128_sulston/dats/CA20081128_sulston.csv";
		Vembryo3 ve3 = new Vembryo3(csvPath, false, false);
		Hashtable h = (Hashtable)ve3.getCellsByName();
		Cell root = ve3.getRoot();
		Enumeration e = root.breadthFirstEnumeration();
		//Enumeration e = h.keys();
		while (e.hasMoreElements()) {
			//String cname = (String)e.nextElement();
			//Cell c = (Cell)h.get(cname);
			Cell c = (Cell)e.nextElement();
			if (!c.isLeaf()) continue;
			String cname = c.getName();
			int start = c.getTime();
			int end = c.getLifeTime();

			//println("test, " + cname + CS + count + CS + start + CS + end);
			println(cname + C + start + C + end);
			count++;
		}
		//println("test, count=" + count);

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		println("StandardSulstonCA.main, ");
		StandardSulstonCA sca = new StandardSulstonCA();
		sca.test();



	}
	private static void println(String s) {System.out.println(s);}
    private static void print(String s) {System.out.print(s);}
    private static final String CS = ", ", C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");
    private static String fmt4(double d) {return DF4.format(d);}
    private static String fmt1(double d) {return DF1.format(d);}
    private static String fmt0(double d) {return DF0.format(d);}

}
