function varargout = lineage_launcher(varargin)
%LINEAGE_LAUNCHER M-file for lineage_launcher.fig
%      LINEAGE_LAUNCHER, by itself, creates a new LINEAGE_LAUNCHER or raises the existing
%      singleton*.
%
%      H = LINEAGE_LAUNCHER returns the handle to a new LINEAGE_LAUNCHER or the handle to
%      the existing singleton*.
%
%      LINEAGE_LAUNCHER('Property','Value',...) creates a new LINEAGE_LAUNCHER using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to lineage_launcher_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      LINEAGE_LAUNCHER('CALLBACK') and LINEAGE_LAUNCHER('CALLBACK',hObject,...) call the
%      local function named CALLBACK in LINEAGE_LAUNCHER.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to runbutton (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help lineage_launcher

% Last Modified by GUIDE v2.5 10-Sep-2010 09:55:47

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @lineage_launcher_OpeningFcn, ...
                   'gui_OutputFcn',  @lineage_launcher_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before lineage_launcher is made visible.
function lineage_launcher_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no outputname args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line outputname for lineage_launcher
handles.outputname = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes lineage_launcher wait for user response (see UIRESUME)
% uiwait(handles.figure1);
handles.ROIcount=0;
handles.ROIs={};
guidata(hObject,handles)

% --- Outputs from this function are returned to the command line.
function varargout = lineage_launcher_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning outputname args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line outputname from handles structure
varargout{1} = handles.outputname;


% --- Executes on button press in runbutton.
function runbutton_Callback(hObject, eventdata, handles)
% hObject    handle to runbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
suffix=get(handles.embryosuffix,'String');
parameterfilenames={};

embryodir=handles.embryodir;
wrongslashes=findstr(embryodir,'\');
embryodir(wrongslashes)='/';
outputdir=get(handles.outputdir,'String');
if(iscell(outputdir))
    outputdir=outputdir{1};
end
wrongslashes=findstr(outputdir,'\');
outputdir(wrongslashes)='/';
outputdir=[outputdir,'/'];


outputdirectory=[outputdir,handles.embryodirname,'/'];
mkdir(outputdirectory);

for i=1:length(handles.ROIs)
%for each embryo ROI
%make copy of param file with emb name
%append configuration matching gui to it
%first one gets sliceoutput=true
%close it
paramfilename=[outputdirectory,'/paramfile_',handles.embryoname,suffix,num2str(i,'%04d'),'.txt'];

%paramfilename=[get(handles.outputdir,'String'),'\paramfile_',num2str(i,'%04d'),'_',suffix,'.txt'];
wrongslashes=findstr(paramfilename,'\');
paramfilename(wrongslashes)='/';

parameterfilenames{i}=paramfilename;
copyfile(get(handles.parameterfilename,'String'),paramfilename);

file=fopen(paramfilename,'a');


if(get(handles.simpletiff,'Value'))
    fprintf(file,'newscope=false;\n\r');
     fprintf(file,'MATLAB_STACK=false;\n\r');
        fprintf(file,'SIMPLETIFF=true;\n\r');
else
    if(get(handles.matlabim,'Value'))
            fprintf(file,'newscope=false;\n\r');
              fprintf(file,'SIMPLETIFF=false;\n\r');
            fprintf(file,'MATLAB_STACK=true;\n\r');
    end
    
 
end

fprintf(file,'%%Parameter overwrites generated by ROI interface:\n\r');
if(get(handles.green,'Value'))
    fprintf(file,'rednuclei=false;\n\r');
else
    fprintf(file,'rednuclei=true;\n\r');
end
fprintf(file,['start_time=',get(handles.starttime,'String'),';\n\r']);
fprintf(file,['end_time=',get(handles.endtime,'String'),';\n\r']);

if(i==1&&get(handles.makeslices,'Value'))
    fprintf(file,'outputSlice=true;\n\r');
else
    fprintf(file,'outputSlice=false;\n\r');
end

%output ROI i
fprintf(file,'ROI=true;\n\r');
points=round(handles.ROIs{i}.getPosition());
fprintf(file,['ROIxmin=',num2str(max(1,min(points(:,1)))),';\n\r']);
fprintf(file,['ROIxmax=',num2str(max(points(:,1))),';\n\r']);
fprintf(file,['ROIymin=',num2str(max(1,min(points(:,2)))),';\n\r']);
fprintf(file,['ROIymax=',num2str(max(points(:,2))),';\n\r']);


%build up a string for the polygonal ROI to put in parameter file
bigstring='ROIpoints=[';
for p=1:size(points,1);
    bigstring=[bigstring,num2str(points(p,1)),' ',num2str(points(p,2)),' ; '];
end
bigstring=[bigstring,']'];
fprintf(file,[bigstring,';\n\r']);%save point array in parameter file

fclose(file);
end

for i=1:length(handles.ROIs)
%for each embryo ROI
%call main detction with images 
%call tracking
%put everything in right final location
%this is done with call to central driver script
embryodir=handles.embryodir;
wrongslashes=findstr(embryodir,'\');
embryodir(wrongslashes)='/';
outputdir=get(handles.outputdir,'String');
if(iscell(outputdir))
    outputdir=outputdir{1};
end
wrongslashes=findstr(outputdir,'\');
outputdir(wrongslashes)='/';
outputdir=[outputdir,'/'];
points=round(handles.ROIs{i}.getPosition());
tic

if(get(handles.green,'Value'))
    lineageparameterfile='parameterConfigurationGreen.m';
  %  detect_track_driver(parameterfilenames{i},embryodir,handles.embryoname,[suffix,num2str(i)],outputdirectory,points,false);

   detect_track_driver_allmatlab(parameterfilenames{i},embryodir,handles.embryoname,[suffix,num2str(i)],outputdirectory,points,false,lineageparameterfile);
else
      lineageparameterfile='parameterConfiguration.m';
  % detect_track_driver(parameterfilenames{i},embryodir,handles.embryoname,[suffix,num2str(i)],outputdirectory,points,true);
  detect_track_driver_allmatlab(parameterfilenames{i},embryodir,handles.embryoname,[suffix,num2str(i)],outputdirectory,points,true,lineageparameterfile);
 
end
toc
end
'all embryos completed'

% --- Executes on button press in reset.
function reset_Callback(hObject, eventdata, handles)
% hObject    handle to reset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes when selected object is changed in colorchannel.
function colorchannel_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in colorchannel 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
%if changed update to one of default param files for red or green 
if(get(handles.green,'Value'))
set(handles.parameterfilename,'String','L:\bin\starryniteII\matlab-parameters-file-newscope_middle_weak_thresholds_journalV_besthack_nodata.txt');
else
    set(handles.parameterfilename,'String','L:\bin\starryniteII\Red_anthonytest.txt');
end


function embryosuffix_Callback(hObject, eventdata, handles)
% hObject    handle to embryosuffix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of embryosuffix as text
%        str2double(get(hObject,'String')) returns contents of embryosuffix as a double



% --- Executes during object creation, after setting all properties.
function embryosuffix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to embryosuffix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function parameterfilename_Callback(hObject, eventdata, handles)
% hObject    handle to parameterfilename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of parameterfilename as text
%        str2double(get(hObject,'String')) returns contents of parameterfilename as a double



% --- Executes during object creation, after setting all properties.
function parameterfilename_CreateFcn(hObject, eventdata, handles)
% hObject    handle to parameterfilename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in parameterbutton.
function parameterbutton_Callback(hObject, eventdata, handles)
% hObject    handle to parameterbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] = uigetfile('*.*');
set(handles.parameterfilename,'String',[PathName,FileName]);



function imagefilename_Callback(hObject, eventdata, handles)
% hObject    handle to imagefilename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of imagefilename as text
%        str2double(get(hObject,'String')) returns contents of imagefilename as a double


 
% --- Executes during object creation, after setting all properties.
function imagefilename_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imagefilename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in imagebutton.
function imagebutton_Callback(hObject, eventdata, handles)
% hObject    handle to imagebutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] = uigetfile('l:/duz/project/imaging/*.*');
%looks for the 
ind=max(strfind(FileName,'_'));
if (isempty(ind))
    ind=regexp(FileName,'\d' ,'once');
end
ind3=(findstr(PathName,'\'));
ind3=ind3(length(ind3)-1);%take second to last occurance of dir delimater
ind2=max(findstr(FileName,'.'));

set(handles.imagefilename,'String',[PathName,FileName(1:ind-1)]);



suffix=FileName(ind2+1:length(FileName));
framenum=str2num(FileName(ind+2:ind2-1));
if(get(handles.simpletiff,'Value'))
    X=loadSimpleStackTiff([PathName,FileName]);
    'simple tiff'
else 
if (strcmp(suffix,'mat'))
    load([PathName,FileName]);
    X=stack;
    clear stack;
    handles.matlabformat=true;
else
    %to do
    %check if simpletiff radio button 
    if(get(handles.green,'Value'))
        X=im2double(((loadCellStackMetamorph([PathName,FileName(1:ind-1)],framenum,2,30,[0,0,0,0],false))));
    else
        X=im2double(((loadCellStackMetamorph([PathName,FileName(1:ind-1)],framenum,1,30,[0,0,0,0],false))));
    end
end
end


im=max(X,[],3);
%im=medfilt2(im,[5,5],'symmetric');

minvalr=prctile(reshape(im,[1,numel(im)]),25);
maxvalr=prctile(reshape(im,[1,numel(im)]),99); 
im(im>maxvalr)=maxvalr;
im(im<minvalr)=minvalr;

hold on;
i=imagesc(fliplr(im));
axis tight;
set(handles.axes1,'YDir','reverse');
colormap(gray);
set(i,'HitTest','off');
handles.embryodirname=PathName(ind3+1:length(PathName)-1);%end dir name
handles.embryodir=PathName;%vs full path
handles.embryoname=FileName(1:ind-1);
guidata(hObject,handles)


% --- Executes on mouse press over axes background.
function axes1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axes1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.ROIcount=handles.ROIcount+1;
handles.ROIs{handles.ROIcount}=impoly(handles.axes1);
guidata(hObject,handles)



function endtime_Callback(hObject, eventdata, handles)
% hObject    handle to endtime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of endtime as text
%        str2double(get(hObject,'String')) returns contents of endtime as a double


% --- Executes during object creation, after setting all properties.
function endtime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to endtime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function starttime_Callback(hObject, eventdata, handles)
% hObject    handle to starttime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of starttime as text
%        str2double(get(hObject,'String')) returns contents of starttime as a double


% --- Executes during object creation, after setting all properties.
function starttime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to starttime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in outputdirbutton.
function outputdirbutton_Callback(hObject, eventdata, handles)
% hObject    handle to outputdirbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
path = uigetdir('L:\duz\project\Lineage-analysis\');
set(handles.outputdir,'String',path);


function outputdir_Callback(hObject, eventdata, handles)
% hObject    handle to outputdir (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of outputdir as text
%        str2double(get(hObject,'String')) returns contents of outputdir as a double


% --- Executes during object creation, after setting all properties.
function outputdir_CreateFcn(hObject, eventdata, handles)
% hObject    handle to outputdir (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in makeslices.
function makeslices_Callback(hObject, eventdata, handles)
% hObject    handle to makeslices (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of makeslices
